/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.thumbnail.CannotGenerateThumbnailException;
import com.atlassian.confluence.pages.thumbnail.ThumbnailInfo;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.user.User;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.scriptutil.ScriptUtils;

public class AttachmentHelper {
    protected final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    public final String NEW = "new";
    public final String REPLACE = "replace";
    public final String KEEP = "keep";
    public final String SPECIAL_VALUE_HOME = "@home";
    protected String attachmentString;
    protected final String i18nKey;
    protected final I18NBean i18nBean;
    protected final SettingsManager settingsManager;
    protected final SpaceManager spaceManager;
    protected final PageManager pageManager;
    protected final PermissionManager permissionManager;
    protected final AttachmentManager attachmentManager;
    protected final ThumbnailManager thumbnailManager;
    protected Page page;
    protected String attachmentName;
    protected Attachment attachment = null;
    boolean isInitialized = false;

    public AttachmentHelper(String attachmentString, String i18nKey, I18NBean i18nBean, SettingsManager settingsManager, SpaceManager spaceManager, PageManager pageManager, PermissionManager permissionManager, AttachmentManager attachmentManager, ThumbnailManager thumbnailManager) {
        this.attachmentString = attachmentString;
        this.i18nKey = i18nKey;
        this.i18nBean = i18nBean;
        this.settingsManager = settingsManager;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.attachmentManager = attachmentManager;
        this.thumbnailManager = thumbnailManager;
    }

    public boolean useExistingAttachment() {
        this.log.debug("use existing attachment: {}", (Object)(this.attachment != null ? 1 : 0));
        return this.attachment != null;
    }

    public Attachment getAttachment() throws MacroExecutionException {
        this.log.debug("attachment: {}", (Object)this.attachment);
        return this.attachment;
    }

    public String getAttachmentName(MacroInfo info) throws MacroExecutionException {
        if (!this.isInitialized) {
            this.initialize(info);
        }
        this.log.debug("attachmentName: {}", (Object)this.attachmentName);
        return this.attachmentName;
    }

    public Page getPage() throws MacroExecutionException {
        return this.page;
    }

    public void initialize(MacroInfo info) throws MacroExecutionException {
        PageContext pageContext = info.getConversionContext().getPageContext();
        if (pageContext == null) {
            throw new MacroExecutionException("Export to an attachment can only be used in a page context.");
        }
        String attachmentVersion = info.getMacroParams().getString("attachmentversion", "new");
        if (!("keep".equalsIgnoreCase(attachmentVersion) || "new".equalsIgnoreCase(attachmentVersion) || "replace".equalsIgnoreCase(attachmentVersion))) {
            attachmentVersion = "new";
        }
        if (this.attachmentString != null) {
            String pageName;
            String spaceKey;
            boolean onAnotherPage;
            int spaceAt = this.attachmentString.indexOf(58);
            int attachAt = this.attachmentString.indexOf(94);
            if (spaceAt < 0 && attachAt == 0) {
                this.attachmentString = this.attachmentString.substring(1);
                attachAt = -1;
            }
            boolean onCurrentPage = spaceAt < 0 && attachAt < 0;
            boolean bl = onAnotherPage = attachAt > 0 && attachAt > spaceAt;
            if (!onCurrentPage && !onAnotherPage) {
                throw new MacroExecutionException(ScriptUtils.getText(this.i18nBean, this.i18nKey + ".error.not-attachment-expression", this.attachmentString));
            }
            if (onCurrentPage) {
                spaceKey = pageContext.getSpaceKey();
                pageName = pageContext.getPageTitle();
            } else {
                spaceKey = spaceAt == -1 ? pageContext.getSpaceKey() : this.attachmentString.substring(0, spaceAt);
                pageName = attachAt == 0 ? pageContext.getPageTitle() : this.attachmentString.substring(spaceAt + 1, attachAt);
            }
            this.attachmentName = attachAt < 0 ? this.attachmentString : this.attachmentString.substring(attachAt + 1);
            this.page = this.getPageWithSpecialValueHandling(pageName, pageContext, spaceKey, onCurrentPage);
            if (this.page == null && onCurrentPage) {
                this.attachmentName = null;
            }
            if (this.attachmentName != null) {
                if ("keep".equalsIgnoreCase(attachmentVersion)) {
                    this.attachment = this.attachmentManager.getAttachment((ContentEntityObject)this.page, this.attachmentName);
                } else {
                    boolean hasAttachmentCreatePermission = this.permissionManager.hasCreatePermission((User)AuthenticatedUserThreadLocal.get(), (Object)this.page, Attachment.class);
                    if (!hasAttachmentCreatePermission) {
                        this.attachmentName = null;
                        this.log.debug("Not keep and user doesn't have permission to create attachment, so revert to no existing attachment");
                    }
                }
            }
        }
    }

    public Attachment createAttachment(MacroInfo info, byte[] content, String mimeType) throws MacroExecutionException {
        return this.createAttachmentsWithLimit(info, content, mimeType);
    }

    public Attachment createAttachmentsWithLimit(MacroInfo info, byte[] content, String mimeType) throws MacroExecutionException {
        String attachmentVersion = info.getMacroParams().getString("attachmentversion", "new");
        String attachmentComment = info.getMacroParams().getString("attachmentcomment", "");
        Integer attachmentLimit = Integer.parseInt(info.getMacroParams().getString("attachmentLimit", "0"));
        Attachment newVersion = null;
        try {
            if (this.page == null) {
                throw new MacroExecutionException("Unexpected condition - page is null");
            }
            Attachment currentVersion = this.attachmentManager.getAttachment((ContentEntityObject)this.page, this.attachmentName);
            boolean hasRemovePermission = this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.REMOVE, (Object)currentVersion);
            if (currentVersion != null && "replace".equalsIgnoreCase(attachmentVersion) && hasRemovePermission) {
                this.log.warn("DELETE attachment (with all version): " + currentVersion);
                this.attachmentManager.removeAttachmentFromServer(currentVersion);
                currentVersion = null;
            }
            try {
                newVersion = this.saveAsAttachment((ContentEntityObject)this.page, mimeType, this.attachmentName, content, attachmentComment, currentVersion);
                if (currentVersion != null && "new".equalsIgnoreCase(attachmentVersion) && attachmentLimit > 0 && hasRemovePermission) {
                    List previousVersions = this.attachmentManager.getPreviousVersions(newVersion);
                    Collections.reverse(previousVersions);
                    if (previousVersions != null && previousVersions.size() > attachmentLimit) {
                        int index = previousVersions.size() - attachmentLimit;
                        for (int i = 0; i < index; ++i) {
                            this.attachmentManager.removeAttachmentVersionFromServer((Attachment)previousVersions.get(i));
                        }
                    }
                }
                this.attachment = newVersion;
            }
            catch (IOException exception) {
                this.log.error(exception.toString(), (Throwable)exception);
                newVersion = null;
            }
        }
        catch (NumberFormatException exception) {
            this.log.error(exception.toString(), (Throwable)exception);
            throw new MacroExecutionException("Please give the valid positive integer value for Attachment Limit " + exception.toString(), (Throwable)exception);
        }
        catch (CloneNotSupportedException exception) {
            this.log.error(exception.toString(), (Throwable)exception);
            throw new MacroExecutionException("Unexpected exception adding attachment: " + exception.toString(), (Throwable)exception);
        }
        catch (Exception exception) {
            this.log.error(exception.toString(), (Throwable)exception);
            throw new MacroExecutionException("Unexpected exception adding attachment: " + exception.toString(), (Throwable)exception);
        }
        return newVersion;
    }

    public Attachment createImageAttachment(MacroInfo info, BufferedImage image, String imageFormat) throws MacroExecutionException {
        try {
            return this.createAttachmentsWithLimit(info, this.getImageAsByteArray(image, imageFormat), "image/" + imageFormat);
        }
        catch (IOException exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getImageAsByteArray(BufferedImage image, String imageFormat) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, imageFormat, outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    private Attachment saveAsAttachment(ContentEntityObject content, String mimeType, String attachmentFileName, byte[] bytes, String comment, Attachment currentVersion) throws CloneNotSupportedException, IOException {
        Attachment previousVersion = (Attachment)(null != currentVersion && currentVersion.isPersistent() ? currentVersion.clone() : null);
        Attachment attachment = null == previousVersion ? new Attachment() : currentVersion;
        attachment.setContainer(content);
        attachment.setContentType(mimeType);
        attachment.setVersionComment(comment);
        attachment.setFileName(attachmentFileName);
        attachment.setFileSize((long)bytes.length);
        if (null == previousVersion) {
            content.addAttachment(attachment);
        }
        this.attachmentManager.saveAttachment(attachment, previousVersion, (InputStream)new ByteArrayInputStream(bytes));
        return attachment;
    }

    public String getAttachmentHtml(boolean thumbnail, String imageMap, String imageMapSegment) {
        StringBuilder builder = new StringBuilder("<span class=\"image-wrap\">");
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        boolean usingThumbnail = thumbnail && this.thumbnailManager.isThumbnailable(this.attachment);
        this.log.debug("type: {}, is thumbnailable: {}", (Object)this.attachment.getContentType(), (Object)this.thumbnailManager.isThumbnailable(this.attachment));
        if (usingThumbnail) {
            this.thumbnailManager.getThumbnail(this.attachment);
            try {
                ThumbnailInfo thumbnailInfo = this.thumbnailManager.getThumbnailInfo(this.attachment);
                builder.append(String.format("<a class=\"confluence-thumbnail-link\" href=\"%s%s\"><img src=\"%s\" width=\"%d\" height=\"%d\"></a>", baseUrl, this.attachment.getDownloadPathWithoutVersion(), thumbnailInfo.getThumbnailUrlPath(), thumbnailInfo.getThumbnailWidth(), thumbnailInfo.getThumbnailHeight()));
            }
            catch (CannotGenerateThumbnailException ignore) {
                this.log.error("Unable to create thumbnail version of specified attachment", (Throwable)ignore);
                usingThumbnail = false;
            }
        }
        if (!usingThumbnail) {
            builder.append(imageMap).append("<img src=\"").append(baseUrl).append(ScriptUtils.xmlEncodeAmpersand(this.attachment.getDownloadPath())).append("\" ").append(ScriptUtils.xmlEncodeAmpersand(imageMapSegment).trim()).append("/>");
        }
        return builder.append("</span>").toString();
    }

    protected Page getPageWithSpecialValueHandling(String name, PageContext pageContext, String spaceKey, boolean forgivePageNotFound) throws MacroExecutionException {
        Page page = null;
        if (spaceKey == null && pageContext != null) {
            spaceKey = pageContext.getSpaceKey();
        }
        if (spaceKey != null && "@home".equalsIgnoreCase(name)) {
            page = this.getSpace(spaceKey).getHomePage();
        }
        if (pageContext != null) {
            if ("@self".equalsIgnoreCase(name)) {
                page = this.pageManager.getPage(spaceKey, pageContext.getPageTitle());
            } else if ("@parent".equalsIgnoreCase(name)) {
                page = this.pageManager.getPage(spaceKey, pageContext.getPageTitle()).getParent();
            }
        }
        if (page == null && (page = this.pageManager.getPage(spaceKey, name)) == null && spaceKey != null) {
            this.getSpace(spaceKey);
            if (!forgivePageNotFound) {
                throw new MacroExecutionException(ScriptUtils.getText(this.i18nBean, this.i18nKey + ".error.page-not-found", name, spaceKey));
            }
        }
        return page;
    }

    protected Space getSpace(String spaceKey) throws MacroExecutionException {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            throw new MacroExecutionException(ScriptUtils.getText(this.i18nBean, this.i18nKey + ".error.space-not-found", spaceKey));
        }
        return space;
    }
}

