/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.RenderedContentStore;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.atlassian.user.User;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.opensymphony.webwork.ServletActionContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.macroutil.MacroParameterStorage;
import org.swift.confluence.scriptutil.BlacklistDomains;
import org.swift.confluence.scriptutil.Constants;
import org.swift.confluence.scriptutil.EncryptDecryptHelper;
import org.swift.confluence.scriptutil.ScriptMacroWithLegacyRender;

public class ScriptUtils {
    protected static final Logger log = LoggerFactory.getLogger((String)"org.swift.confluence.scriptutil.ScriptUtils");
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char NEW_LINE = '\n';
    public static final String COMMA = ",";
    public static final String COLON = ":";
    public static final String NBSP = "&nbsp;";
    protected static final Pattern PARAGRAPH_PATTERN = Pattern.compile("<p>(.*?)</p>", 34);
    protected static final Pattern CLASS_ATTRIBUTE_PATTERN = Pattern.compile("(class=['\"]([^'\"]*)['\"])");
    protected static final Pattern TR_PATTERN = Pattern.compile("(<tr([^>]*)>)");
    public static final String CONFLUENCE_TABLE = "confluenceTable";
    public static final int RES_FILE = 1;
    public static final int RES_URL = 2;
    public static final int RES_STRING = 3;
    public static final int RES_STREAM = 4;
    public static final String EDITOR_BLANK = "\u00a0";
    public static final String UTF8_BOM = "\ufeff";
    public static final String UTF16_BOM = "\ufffe";
    public static final String WHITE_LIST_ERROR_VM = "html/org/swift/confluence/scriptutil/whitelist-error.vm";
    protected static final Pattern PREVIEW_URL_PATTERN = Pattern.compile("(\\?|&)preview=(%2F|\\/)\\d+(%2F|\\/)\\d+(%2F|\\/)", 8);
    protected static final Pattern SAME_INSTANCE_URL_PATTERN = Pattern.compile("(download(%2F|\\/)attachments)|((%2F|\\/)?rest(%2F|\\/))|((%2F|\\/)status)", 8);
    protected static long uniqueId = System.currentTimeMillis();
    protected static final ConfluenceBandanaContext bandanaContext = new ConfluenceBandanaContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStreamAsString(InputStream input, String encoding) throws MacroExecutionException, IOException {
        Reader reader;
        StringBuilder inputBuilder = new StringBuilder();
        Reader reader2 = reader = input == null ? null : ScriptUtils.getReader(input, encoding);
        if (reader != null) {
            try {
                int readCount;
                char[] buffer = new char[1024];
                while ((readCount = reader.read(buffer)) >= 0) {
                    inputBuilder.append(buffer, 0, readCount);
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return ScriptUtils.removeUTF8BOM(inputBuilder.toString());
    }

    public static String getFileAsString(File file, String encoding) throws IOException, MacroExecutionException {
        FileInputStream stream = new FileInputStream(file);
        return ScriptUtils.getStreamAsString(stream, encoding);
    }

    public static int getResourceType(String name, boolean allowUrl) throws MacroExecutionException {
        if (name.charAt(0) == '#') {
            if (allowUrl) {
                String sub = name.substring(1);
                return sub.contains("://") && ScriptUtils.checkUrlIsAllowed(sub, false) ? 2 : 1;
            }
            return 1;
        }
        return name.indexOf(94) == -1 ? 3 : 4;
    }

    public static boolean checkUrlIsAllowed(String url, boolean throwError, BandanaManager bandanaManager, String allowWhitelistedUrlsKey, String blacklistDomainsKey) throws MacroExecutionException {
        if (ScriptUtils.checkUrlIsAllowed(url, throwError)) {
            if (!BlacklistDomains.isURLBlacklisted(url, ScriptUtils.getGlobalBlacklistDomains(bandanaManager, blacklistDomainsKey), null)) {
                return ScriptUtils.checkUrlWhitelisted(bandanaManager, allowWhitelistedUrlsKey, url);
            }
            throw new MacroExecutionException("The data cannot be displayed because the URL is blacklisted. Contact your Confluence administrator to find out more.");
        }
        return false;
    }

    public static boolean checkUrlIsAllowed(String url, boolean throwError, BandanaManager bandanaManager, String allowWhitelistedUrlsKey, String blacklistDomainsKey, String[] blacklistDomainValues) throws MacroExecutionException {
        if (ScriptUtils.checkUrlIsAllowed(url, throwError)) {
            if (!BlacklistDomains.isURLBlacklisted(url, ScriptUtils.getGlobalBlacklistDomains(bandanaManager, blacklistDomainsKey))) {
                return ScriptUtils.checkUrlWhitelisted(bandanaManager, allowWhitelistedUrlsKey, url);
            }
            throw new MacroExecutionException("The data cannot be displayed because the URL is blacklisted. Contact your Confluence administrator to find out more.");
        }
        return false;
    }

    public static boolean checkUrlIsAllowed(String name, boolean throwError) throws MacroExecutionException {
        if (name.matches("(?:http|https|ftp|ftps|sftp)://.*") || ScriptUtils.isUrlRelative(name)) {
            if (ScriptUtils.isPreviewUrl(name)) {
                throw new MacroExecutionException("The URL cannot be used as a reference to the attachment because it is used for previewing the attachment only. Use the recommended Attachment option in the Method of location script field to choose an attachment from a page.");
            }
            if (!ScriptUtils.isSameInstanceUrlValid(name)) {
                throw new MacroExecutionException("The URL provided is not valid because it is a page reference to the current instance. Please use a URL to a supported format.");
            }
            return true;
        }
        if (throwError) {
            throw new MacroExecutionException("URL is invalid or not allowed.");
        }
        return false;
    }

    private static boolean isSameInstanceUrlValid(String url) {
        if (GeneralUtil.getGlobalSettings() != null && url.startsWith(GeneralUtil.getGlobalSettings().getBaseUrl()) || ScriptUtils.isUrlRelative(url)) {
            Matcher matcher = SAME_INSTANCE_URL_PATTERN.matcher(url);
            if (matcher.find()) {
                return true;
            }
            log.debug("The URL {} is not a download attachment URL or rest API URL of same instance. ", (Object)url);
            return false;
        }
        return true;
    }

    public static boolean isUrlRelative(String url) {
        return !url.contains("://");
    }

    public static void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isFile(String name) {
        return name.startsWith("#");
    }

    public static Map<String, String> keysToLowerCase(Map<String, String> params) {
        HashMap<String, String> lcParams = new HashMap<String, String>();
        for (Map.Entry<String, String> e : params.entrySet()) {
            lcParams.put(e.getKey().toLowerCase(), e.getValue());
        }
        return lcParams;
    }

    public static boolean isWhitespace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String handleHtmlValue(String value, boolean isAntiXssMode) {
        if (ScriptUtils.isWhitespace(value)) {
            return NBSP;
        }
        return StringUtils.replace((String)(isAntiXssMode ? GeneralUtil.htmlEncode((String)value) : value), (String)"\n", (String)"<br/>");
    }

    public static String ensureWikiValue(String value) {
        if (value != null) {
            value = StringUtils.replace((String)value, (String)"|", (String)"\\|");
            value = StringUtils.replace((String)value, (String)"[", (String)"\\[");
            value = StringUtils.replace((String)value, (String)"]", (String)"\\]");
            value = StringUtils.replace((String)value, (String)"{", (String)"\\{");
            value = StringUtils.replace((String)value, (String)"}", (String)"\\}");
            value = StringUtils.replace((String)value, (String)"*", (String)"\\*");
            value = StringUtils.replace((String)value, (String)"#", (String)"\\#");
            value = StringUtils.replace((String)value, (String)"~", (String)"\\~");
            return StringUtils.replace((String)value, (String)"!", (String)"\\!");
        }
        return "";
    }

    public static String removeSpecificHtmlTags(String html, boolean removeHeadTagOnly) {
        String output = html.replaceAll("<html(?:>|(?: [^>]*>))|<body(?:>|(?: [^>]*>))|</html\\s*>|</body\\s*>", "");
        if (removeHeadTagOnly) {
            return output.replaceAll("<head(?:>|(?: [^>]*>))|</head\\s*>", "");
        }
        return output.replaceAll("(?s)<head(?:>|(?: [^>]*>)).*</head\\s*>", "");
    }

    public static synchronized long getUniqueId() {
        return uniqueId++;
    }

    public static String getUniqueId(String key, MacroInfo info) {
        ConversionContext context = info.getConversionContext();
        int id = 0;
        id = context.getProperty(key) != null ? (Integer)context.getProperty(key) + 1 : 1;
        context.setProperty(key, (Object)id);
        return Integer.toString(id);
    }

    public static String toHexString(String input) {
        String output = "";
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            output = output + "-" + Integer.toHexString(ch);
        }
        return output;
    }

    public static int maxOfArray(int[] array) {
        int max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return max;
    }

    public static String generateColumnTypesString(String string) throws MacroExecutionException {
        return ScriptUtils.generateColumnTypesString(ScriptUtils.csvDataAsList(string, COMMA, '\"', '\n'));
    }

    public static String generateColumnTypesString(List<String> types) {
        StringBuilder columnTypes = new StringBuilder();
        columnTypes.append("[");
        if (types != null) {
            Pattern pattern = Pattern.compile("(?i)((?:ff)|(?:fc)|(?:cc)|(?:[a-z\\.\\:\\-/]))(?:([^\"]*)|(?:\"([^\"]*)\"))");
            for (int i = 0; i < types.size(); ++i) {
                Matcher matcher;
                String type = "S";
                String format = "";
                String typeString = types.get(i).trim();
                if (typeString.length() > 0 && (matcher = pattern.matcher(typeString)).matches()) {
                    type = matcher.group(1).toUpperCase();
                    format = matcher.group(2);
                    if (format == null) {
                        format = matcher.group(3);
                    }
                }
                columnTypes.append(i == 0 ? "'" : ", '").append(type).append(GeneralUtil.htmlEncode((String)format)).append("'");
            }
        }
        columnTypes.append("]");
        return columnTypes.toString();
    }

    public static boolean getBoolean(String name, boolean def, MacroInfo info) {
        boolean result = def;
        String value = info.getMacroParams().getString(name, "").trim();
        if (value.equalsIgnoreCase(def ? FALSE : TRUE)) {
            result = !def;
        }
        return result;
    }

    public static boolean getBoolean(String name, boolean def, Map<String, String> map) {
        boolean result = def;
        String value = map.get(name);
        if (value != null && (value = value.trim()).equalsIgnoreCase(def ? FALSE : TRUE)) {
            result = !def;
        }
        return result;
    }

    public static boolean getBoolean(String name, boolean def, MacroInfo info, Map<String, String> map) {
        boolean result = def;
        String value = info.getMacroParams().getString(name, map.get(name));
        if (value != null && value.trim().equalsIgnoreCase(def ? FALSE : TRUE)) {
            result = !def;
        }
        return result;
    }

    public static int getInteger(String name, int def, MacroInfo info) {
        int result = def;
        try {
            result = info.getMacroParams().getInteger(name, def);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Integer getIntegerOrNull(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException exception) {
            return null;
        }
    }

    public static int getInteger(String string, int defaultValue) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException exception) {
            return defaultValue;
        }
    }

    public static String quoteString(String string, char quote) {
        StringBuilder result = new StringBuilder();
        result.append(quote);
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == quote) {
                    result.append(quote);
                }
                result.append(string.charAt(i));
            }
        }
        result.append(quote);
        return result.toString();
    }

    public static String stripQuotes(String string, char quote) {
        if (string.length() > 1 && string.charAt(0) == quote && string.charAt(string.length() - 1) == quote) {
            StringBuilder result = new StringBuilder(string.length());
            boolean previousWasQuote = false;
            for (int i = 1; i < string.length() - 1; ++i) {
                boolean nextIsQuote;
                if (previousWasQuote) {
                    result.append(string.charAt(i));
                    previousWasQuote = false;
                    continue;
                }
                boolean isQuote = string.charAt(i) == quote;
                boolean isLast = i == string.length() - 2;
                boolean bl = nextIsQuote = string.charAt(i + 1) == quote && !isLast;
                if (isQuote && !nextIsQuote) {
                    return string;
                }
                boolean bl2 = previousWasQuote = isQuote && !isLast && nextIsQuote;
                if (previousWasQuote) continue;
                result.append(string.charAt(i));
            }
            return result.toString();
        }
        return string;
    }

    public static String toSeparatedString(Collection<String> list, String separator) {
        boolean first = true;
        StringBuilder result = new StringBuilder();
        if (list != null) {
            for (String string : list) {
                if (!first) {
                    result.append(separator);
                } else {
                    first = false;
                }
                result.append(string);
            }
        }
        return result.toString();
    }

    public static String toSeparatedString(List<String> list, String separator, char quote) {
        boolean first = true;
        StringBuilder result = new StringBuilder();
        if (list != null) {
            for (String string : list) {
                if (!first) {
                    result.append(separator);
                } else {
                    first = false;
                }
                result.append(ScriptUtils.quoteString(string, quote));
            }
        }
        return result.toString();
    }

    @Deprecated
    public static List<String> fromSeparatedString(String data, String separator, char quote) throws MacroExecutionException {
        ArrayList<String> result = new ArrayList<String>();
        List<String> list = ScriptUtils.csvDataAsList(data, separator, quote, '\n');
        for (String string : list) {
            result.add(ScriptUtils.stripQuotes(string.trim(), quote));
        }
        return result;
    }

    public static boolean findInSeparatedString(String find, String separatedString, String separator, char quote) {
        try {
            List<String> list = ScriptUtils.csvDataAsList(separatedString, separator, quote, '\n');
            return list.contains(find);
        }
        catch (MacroExecutionException exception) {
            return false;
        }
    }

    public static Reader getReader(InputStream in, String encoding) throws MacroExecutionException {
        if (encoding != null && !encoding.equals("")) {
            ScriptUtils.validateEncoding(encoding);
            try {
                return new InputStreamReader(in, encoding);
            }
            catch (UnsupportedEncodingException exception) {
                throw new MacroExecutionException("Unsupported encoding: " + encoding + ". Valid encodings and aliases are: " + ScriptUtils.getValidEncodings());
            }
        }
        return new InputStreamReader(in);
    }

    public static void validateEncoding(String encoding) throws MacroExecutionException {
        if (encoding != null && !encoding.equals("")) {
            try {
                Charset.forName(encoding);
            }
            catch (Exception exception) {
                throw new MacroExecutionException("Invalid encoding: " + encoding + ". ");
            }
        }
    }

    public static String getValidEncodings() {
        StringBuilder result = new StringBuilder();
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        for (String name : Charset.availableCharsets().keySet()) {
            Charset charset = (Charset)charsets.get(name);
            result.append("\n  " + charset);
            for (String alias : charset.aliases()) {
                result.append(", " + alias);
            }
        }
        return result.toString();
    }

    public static String convertMacLineEnding(String string) {
        return string.contains("\r") && !string.contains("\r\n") ? string.replace('\r', '\n') : string;
    }

    public static String[] getLines(String string) {
        return string.split("\\r?\\n");
    }

    public static List<String> csvDataAsList(String inData, String inDelimiter, char quote, char eol) throws MacroExecutionException {
        Pattern pattern;
        String data = inData;
        String delimiter = inDelimiter != null ? inDelimiter : COMMA;
        boolean blankWhenLineStartsWithDelimiter = true;
        if (delimiter.length() != 1 || delimiter == " ") {
            if (delimiter.equalsIgnoreCase("whitespace")) {
                delimiter = "[ \\t\\x0B\\f]+";
                blankWhenLineStartsWithDelimiter = false;
            } else if (delimiter.equalsIgnoreCase("blank") || delimiter.equalsIgnoreCase("blanks") || delimiter.equals("") || delimiter.equals(" ")) {
                delimiter = " +";
                blankWhenLineStartsWithDelimiter = false;
            } else if (delimiter.equalsIgnoreCase("tab")) {
                delimiter = "\\t";
                blankWhenLineStartsWithDelimiter = false;
            } else if (delimiter.equalsIgnoreCase("pipe")) {
                delimiter = "\\|";
            } else if (delimiter.length() == 3 && delimiter.substring(0, 1).equals(Character.valueOf(quote)) && delimiter.substring(2, 1).equals(Character.valueOf(quote))) {
                delimiter = delimiter.substring(1, 2);
            } else if (delimiter.length() > 0) {
                delimiter = delimiter.substring(0, 1);
            }
        }
        String patternString = "(?:^|" + delimiter + ")(?=(?:[^" + quote + "]*" + quote + "[^" + quote + "]*" + quote + ")*(?![^" + quote + "]*" + quote + "))";
        if (blankWhenLineStartsWithDelimiter) {
            pattern = Pattern.compile(eol + delimiter);
            Matcher matcher = pattern.matcher(data);
            data = matcher.replaceAll(eol + " " + delimiter);
            if (delimiter.equals("\\|") || delimiter.equals("\\*") || delimiter.equals("\\+")) {
                delimiter = delimiter.substring(1);
            }
            if (data.startsWith(delimiter)) {
                data = " " + data;
            }
        }
        pattern = Pattern.compile(patternString, 8);
        int limit = 3000;
        int endIndex = 0;
        ArrayList<String> values = new ArrayList<String>();
        String[] strings = null;
        while (endIndex < data.length()) {
            int startIndex = endIndex;
            if (data.length() < startIndex + limit) {
                endIndex = data.length();
            } else {
                boolean evenQuote = true;
                for (endIndex = startIndex; endIndex < data.length(); ++endIndex) {
                    if (data.charAt(endIndex) == quote) {
                        boolean bl = evenQuote = !evenQuote;
                    }
                    if (!evenQuote || data.charAt(endIndex) != eol) continue;
                    ++endIndex;
                    break;
                }
            }
            for (int loopCount = 0; loopCount < 2; ++loopCount) {
                try {
                    String row = data.substring(startIndex, endIndex);
                    strings = pattern.split(row);
                    break;
                }
                catch (StackOverflowError error) {
                    String message = "Unable to successfully parse csv data. Likely due to unbalanced double quotes, extremely long rows, or other factors related to length of data. Modify your data or ask you administrator to increase Confluence stack space (-Xss). Error was located between " + startIndex + " and " + endIndex + "." + (endIndex - startIndex <= 120 ? "" : " Starting at text: " + data.substring(startIndex, startIndex + 120) + ".");
                    log.warn("Attempting to recover from error: {}", (Object)message);
                    int eolIndex = data.indexOf(eol, startIndex + 1);
                    log.debug("loopCount: {}, eolIndex: {}", (Object)loopCount, (Object)eolIndex);
                    if (loopCount > 0 || eolIndex < 0 || eolIndex >= endIndex) {
                        throw new MacroExecutionException(message);
                    }
                    endIndex = eolIndex;
                    continue;
                }
            }
            int startPosition = 0;
            if (strings.length > 1 && strings[0].equals("")) {
                startPosition = 1;
            }
            for (int i = startPosition; i < strings.length; ++i) {
                values.add(ScriptUtils.getCsvDataElement(strings[i], quote, eol));
            }
        }
        return values;
    }

    public static String getCsvDataElement(String data, char quote, char eol) {
        boolean isEol = ScriptUtils.endsWithChar(data, eol);
        String trimmed = data.trim();
        String stripped = ScriptUtils.stripQuotes(trimmed, quote);
        if (isEol) {
            stripped = stripped + eol;
        } else if (stripped.length() != trimmed.length() && ScriptUtils.endsWithChar(stripped, eol)) {
            stripped = stripped.substring(0, stripped.length() - 1);
        }
        return stripped;
    }

    public static boolean endsWithChar(String string, char c) {
        return string != null && string.length() > 0 && string.charAt(string.length() - 1) == c;
    }

    public static String concatenateFileNames(String name1, String name2) {
        if ("".equals(name1)) {
            return name2;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(name1.substring(0, name1.length() - (name1.endsWith("/") || name1.endsWith("\\") ? 1 : 0)));
        builder.append(File.separatorChar);
        builder.append(name2.substring(name2.startsWith("/") || name2.startsWith("\\") ? 1 : 0));
        return builder.toString();
    }

    @Deprecated
    public static String getProfile(String profile, BandanaManager bandanaManager, String bandanaKey) throws MacroExecutionException {
        String value = null;
        if (profile != null) {
            try {
                Map map = (Map)bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), bandanaKey);
                value = (String)map.get(profile);
            }
            catch (Exception exception) {
                throw new MacroExecutionException("Exception accessing profile data for " + bandanaKey + ". Exception: " + exception);
            }
            if (value == null) {
                throw new MacroExecutionException("Profile not found: " + profile);
            }
        }
        return value;
    }

    public static boolean isKeyInBandana(BandanaManager bandanaManager, String key) {
        try {
            return null != bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), key);
        }
        catch (Exception exception) {
            log.debug("Exception accessing bandana: {}", (Object)exception.toString());
            return false;
        }
    }

    public static Map<String, String> getMap(String profile) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (profile != null) {
            String[] array = profile.split("\\|");
            for (int i = 0; i < array.length; ++i) {
                int index = array[i].indexOf("=");
                String key = "";
                String value = "";
                if (index < 0) {
                    key = array[i];
                } else if (index != 0) {
                    key = array[i].substring(0, index);
                    value = array[i].substring(index + 1).trim();
                }
                if (value.contains("@")) {
                    value = value.replaceAll("@base_url@", GeneralUtil.getGlobalSettings().getBaseUrl());
                }
                if ((key = key.trim().toLowerCase()).equals("")) continue;
                map.put(key, value);
            }
        }
        return map;
    }

    public static String getStandardTableHtml(MacroInfo info, String id, String extra) {
        return ScriptUtils.getStandardTableHtml(info, id, extra, true);
    }

    public static String getStandardTableHtml(MacroInfo info, String id, String extra, boolean applyParameters) {
        Matcher matcher;
        String border;
        String className = applyParameters ? info.getMacroParams().getString("class", null) : null;
        String style = applyParameters ? info.getMacroParams().getString("style", null) : null;
        String width = applyParameters ? info.getMacroParams().getString("width", null) : null;
        String string = border = applyParameters ? info.getMacroParams().getString("border", null) : null;
        if (StringUtils.isNotBlank((String)extra) && (matcher = CLASS_ATTRIBUTE_PATTERN.matcher(extra)).find()) {
            if (className == null) {
                className = matcher.group(2);
            }
            extra = extra.replaceFirst(matcher.group(1), "");
        }
        if (className == null || className.equalsIgnoreCase("@default")) {
            className = CONFLUENCE_TABLE;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<table ");
        String extraLowerCase = extra.toLowerCase();
        if (StringUtils.isNotBlank((String)id) && ScriptUtils.isNotDuplicated("id", extraLowerCase)) {
            builder.append("id=\"").append(id).append("\" ");
        }
        if (StringUtils.isNotBlank((String)className) && ScriptUtils.isNotDuplicated("class", extraLowerCase)) {
            builder.append("class=\"").append(GeneralUtil.htmlEncode((String)className)).append("\" ");
        }
        if (width != null && ScriptUtils.isNotDuplicated("width", extraLowerCase)) {
            builder.append("width=\"").append(GeneralUtil.htmlEncode((String)width)).append("\" ");
        }
        if (border != null && ScriptUtils.isNotDuplicated("border", extraLowerCase)) {
            builder.append("border=\"").append(GeneralUtil.htmlEncode((String)border)).append("\" ");
        }
        if (StringUtils.isNotBlank((String)extra)) {
            builder.append(extra);
        }
        builder.append(">");
        return builder.toString();
    }

    protected static boolean isNotDuplicated(String name, String extraLowerCase) {
        return !extraLowerCase.contains(" " + name + "=");
    }

    public static List<String> getStyles(MacroInfo info, String parameterName) throws MacroExecutionException {
        String styles = GeneralUtil.htmlEncode((String)info.getMacroParams().getString(parameterName.toLowerCase(), ""));
        return ScriptUtils.csvDataAsList(styles + (styles.endsWith(COMMA) ? " " : ""), COMMA, '\'', '\n');
    }

    public static int findTokenIndex(String string, int beginIndex, String token) {
        int start2;
        int start = string.length();
        if (beginIndex < start && (start2 = string.substring(beginIndex).indexOf(token)) >= 0) {
            start = beginIndex + start2;
        }
        return start;
    }

    public static int findTableIndex(String string, int beginIndex) {
        return ScriptUtils.findTokenIndex(string, beginIndex, Constants.START_TABLE);
    }

    public static int findMatchedEndTokenIndex(String string, int beginIndex, String startToken, String endToken) {
        int end = string.length();
        if (beginIndex < end) {
            int start = ScriptUtils.findTokenIndex(string, beginIndex, startToken);
            end = ScriptUtils.findTokenIndex(string, beginIndex, endToken);
            int start2 = ScriptUtils.findTokenIndex(string, start + startToken.length(), startToken);
            while (end < string.length() && start2 < end) {
                int end2 = ScriptUtils.findMatchedEndTokenIndex(string, start2, startToken, endToken);
                end = ScriptUtils.findTokenIndex(string, end2 + endToken.length(), endToken);
                start2 = ScriptUtils.findTokenIndex(string, end2 + endToken.length(), startToken);
            }
        }
        return end;
    }

    public static int findMatchedEndTableIndex(String string, int beginIndex) {
        return ScriptUtils.findMatchedEndTokenIndex(string, beginIndex, Constants.START_TABLE, Constants.END_TABLE);
    }

    public static String stripFirstParagraphTags(String xml) {
        String trimmed = StringUtils.trim((String)xml);
        Matcher matcher = PARAGRAPH_PATTERN.matcher(trimmed);
        if (matcher.find() && matcher.start() == 0 && matcher.end() == trimmed.length()) {
            return matcher.group(1);
        }
        return xml;
    }

    public static String htmlDecode(String string) {
        StringBuffer builder = new StringBuffer();
        Pattern pattern = Pattern.compile("(&[^;]+;)");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String text;
            String replacement = text = matcher.group(1);
            if ("&amp;".equals(text) || "&#38;".equals(text)) {
                replacement = "&";
            } else if ("&lt;".equals(text)) {
                replacement = "<";
            } else if ("&gt;".equals(text)) {
                replacement = ">";
            } else if ("&quot;".equals(text)) {
                replacement = "\"";
            } else if ("&#39;".equals(text)) {
                replacement = "'";
            }
            matcher.appendReplacement(builder, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    public static String xmlEncodeAmpersand(String string) {
        return StringUtils.replace((String)string, (String)"&", (String)"&amp;");
    }

    public static String xmlDecodeAmpersand(String string) {
        return StringUtils.replace((String)string, (String)"&amp;", (String)"&");
    }

    public static String trim(String string) {
        return ScriptUtils.replaceEditorBlank(string).trim();
    }

    public static String replaceEditorBlank(String string) {
        return string == null ? "" : string.replaceAll(EDITOR_BLANK, " ");
    }

    public static String escapeRegex(String string) {
        String specialCharacters = "([\\/\\.\\*\\+\\?\\|\\(\\)\\[\\]\\{\\}\\\\])";
        return string.replaceAll(specialCharacters, "\\\\$1");
    }

    public static String render(XhtmlContent xhtmlContent, MacroInfo info, String content) throws MacroExecutionException {
        return ScriptUtils.render(xhtmlContent, info.getConversionContext(), content);
    }

    public static String render(XhtmlContent xhtmlContent, ConversionContext conversionContext, String content) throws MacroExecutionException {
        try {
            return content == null ? "" : xhtmlContent.convertStorageToView(content, conversionContext);
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                exception.printStackTrace();
                log.debug("content: {}", (Object)content);
            }
            throw new MacroExecutionException("Error rendering xhtml content. Exception: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String renderLegacy(SubRenderer subRenderer, PageContext pageContext, String content) {
        pageContext.pushRenderMode(ScriptMacroWithLegacyRender.LEGACY_RENDER_MODE);
        try {
            String string = subRenderer.render(content, (RenderContext)pageContext, ScriptMacroWithLegacyRender.LEGACY_RENDER_MODE);
            return string;
        }
        finally {
            pageContext.popRenderMode();
        }
    }

    public static boolean isMobile(MacroInfo info) {
        return "mobile".equals(info.getConversionContext().getPropertyAsString("output-device-type"));
    }

    public static String removeUTF8BOM(String string) {
        if (string.startsWith(UTF8_BOM) || string.startsWith(UTF16_BOM)) {
            string = string.substring(1);
        }
        return string;
    }

    public static String getText(I18NBean bean, String key, String replacement) {
        Object[] replaceArray = new String[]{replacement};
        return bean.getText(key, replaceArray);
    }

    public static String getText(I18NBean bean, String key, String replacement1, String replacement2) {
        Object[] replaceArray = new String[]{replacement1, replacement2};
        return bean.getText(key, replaceArray);
    }

    public static String getText(I18NBean bean, String key, String replacement1, String replacement2, String replacement3) {
        Object[] replaceArray = new String[]{replacement1, replacement2, replacement3};
        return bean.getText(key, replaceArray);
    }

    public static void log(int[] array, String text) {
        if (log.isDebugEnabled() && array != null) {
            for (int i = 0; i < array.length; ++i) {
                log.debug(text + "[{}]: {}", (Object)i, (Object)array[i]);
            }
        }
    }

    public static void log(Object[] array, String text) {
        if (log.isDebugEnabled() && array != null) {
            for (int i = 0; i < array.length; ++i) {
                log.debug(text + "[{}]: {}", (Object)i, (Object)(array[i] == null ? "null" : array[i].toString()));
            }
        }
    }

    public static void log(Map<?, ?> map, String text) {
        if (log.isDebugEnabled() && map != null) {
            for (Object key : map.keySet()) {
                log.debug(text + "[{}]: {}", key, (Object)(map.get(key) == null ? "null" : map.get(key).toString()));
            }
        }
    }

    public static void logParams(MacroInfo info) {
        ScriptUtils.logParams(info.getMacroParams());
    }

    public static void logParams(MacroParameterStorage macroParams) {
        if (log.isDebugEnabled()) {
            for (String key : macroParams.getParams().keySet()) {
                String value = macroParams.getParams().get(key);
                if (value != null) {
                    log.debug("parameter key: {}, value: {}", (Object)key, (Object)macroParams.getParams().get(key));
                    continue;
                }
                log.debug("parameter key: {}, value: null", (Object)key);
            }
        }
    }

    public static long getTimeMark(String text, long timeMark) {
        long newTimeMark = System.currentTimeMillis();
        long diff = newTimeMark - timeMark;
        log.debug(" > > > > > > > > >   timeMark diff: {} {}, time: " + newTimeMark, (Object)(timeMark == 0L ? 0L : diff), (Object)text);
        return newTimeMark;
    }

    public static String clean(String value, boolean encode) {
        return encode ? GeneralUtil.htmlEncode((String)value) : value;
    }

    public static DateFormat getDateFormat(String inDateFormat, String defaultDateFormat) throws MacroExecutionException {
        String dateFormat;
        SimpleDateFormat df = null;
        String string = dateFormat = inDateFormat != null ? inDateFormat.trim() : "";
        if ("".equals(dateFormat)) {
            dateFormat = defaultDateFormat;
        }
        try {
            df = "".equals(dateFormat) ? new SimpleDateFormat() : new SimpleDateFormat(dateFormat);
        }
        catch (IllegalArgumentException exception) {
            throw new MacroExecutionException("Invalid dateFormat pattern. " + exception.toString());
        }
        return df;
    }

    public static String getTimeZoneOffsetHours(TimeZone timezone) {
        String offset = timezone.getDisplayOffset();
        Integer hours = new Integer(offset.substring(0, 3).replace('+', ' ').trim());
        return hours.toString() + (offset.substring(3, 5).equals("30") ? ".5" : "");
    }

    public static String getPsuedoRequestParameters(MacroInfo info, String key) {
        Object object = info.getConversionContext().getProperty(key);
        if (object instanceof String) {
            log.debug("pseudo request parameters: {}, for key: {}", object, (Object)key);
            return (String)object;
        }
        return null;
    }

    public static String getCachePsuedoRequestParameters(MacroInfo info) {
        return ScriptUtils.getPsuedoRequestParameters(info, "org.swift.confluence.cache.request_parameters");
    }

    public static boolean isPreview(MacroInfo info) {
        return info.getConversionContext().getOutputType().equals(ConversionContextOutputType.PREVIEW.value());
    }

    public static String toHex(String string) {
        try {
            return String.format("%040x", new BigInteger(1, string.getBytes("UTF8")));
        }
        catch (Exception exception) {
            return "exception: " + exception.toString();
        }
    }

    public static String generateAnchor(PageContext context, String anchor) {
        String result = "";
        if (context != null && !"".equals(anchor)) {
            if (context.getPageTitle() != null) {
                result = context.getPageTitle() + "-";
            } else if (context.getSpaceKey() != null) {
                result = context.getSpaceKey() + "-";
            }
            result = result + StringUtils.trimToEmpty((String)RenderedContentStore.stripTokens((String)anchor));
            result = result.replaceAll(" ", "");
            return GeneralUtil.urlEncode((String)result);
        }
        return result;
    }

    public static void sleep(int milliseconds) {
        try {
            if (milliseconds > 0) {
                Thread.sleep(milliseconds);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static HttpSession getSession() {
        return ServletActionContext.getRequest().getSession();
    }

    public static String getTempDirectoryAbsolutePath(BootstrapManager bootstrapManager) {
        return bootstrapManager.getFilePathProperty("webwork.multipart.saveDir");
    }

    public static String getTempDirectory(BootstrapManager bootstrapManager) {
        int homeDirIndex;
        String tempDirectory = ScriptUtils.getTempDirectoryAbsolutePath(bootstrapManager);
        if (bootstrapManager.getLocalHome() != null && (homeDirIndex = tempDirectory.indexOf(bootstrapManager.getLocalHome().getPath())) != -1) {
            tempDirectory = tempDirectory.substring(homeDirIndex + bootstrapManager.getLocalHome().getPath().length() + 1);
        }
        return tempDirectory;
    }

    public static String getServerLocalHome(BootstrapManager bootstrapManager) {
        return bootstrapManager.getLocalHome().getPath();
    }

    public static boolean isWhitelistedUrl(String uri) throws MacroExecutionException {
        try {
            OutboundWhitelist whitelist = (OutboundWhitelist)ContainerManager.getComponent((String)"outboundWhitelist");
            log.debug("whitelist isallowed for {}:{}", (Object)uri, (Object)whitelist.isAllowed(new URI(uri)));
            return whitelist.isAllowed(new URI(uri));
        }
        catch (URISyntaxException e) {
            log.error("Error while checking whether given url is whitelisted in Confluence", (Throwable)e);
            throw new MacroExecutionException(e.getMessage());
        }
    }

    public static String renderDeniedByWhiteListConfiguration(String url) throws MacroExecutionException {
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("invalidURL", TRUE);
        contextMap.put("url", url);
        contextMap.put("remoteUser", AuthenticatedUserThreadLocal.get());
        try {
            return VelocityUtils.getRenderedTemplate((String)WHITE_LIST_ERROR_VM, (Map)contextMap);
        }
        catch (Exception e) {
            log.error("Error while trying to display whitelist error!", (Throwable)e);
            throw new MacroExecutionException(e.getMessage());
        }
    }

    public static boolean checkUrlWhitelisted(BandanaManager bandanaManager, String configKey, String url) throws MacroExecutionException {
        if (ScriptUtils.getGlobalAllowWhitelistedUrls(bandanaManager, configKey) && !ScriptUtils.isWhitelistedUrl(url)) {
            throw new MacroExecutionException("URL content not available because it is not from an allowed source. Contact an administrator to discuss whitelist restrictions on this site.");
        }
        return true;
    }

    public static boolean getGlobalAllowWhitelistedUrls(BandanaManager bandanaManager, String configKey) {
        boolean result = "on".equals(bandanaManager.getValue((BandanaContext)bandanaContext, configKey));
        log.debug("Global allowWhitelistedUrlsKey on: {}", (Object)result);
        return result;
    }

    public static boolean getGlobalBlacklistDomains(BandanaManager bandanaManager, String configKey) {
        boolean result = "on".equals(bandanaManager.getValue((BandanaContext)bandanaContext, configKey));
        log.debug("Global blacklistDomainsKey on: {}", (Object)result);
        return result;
    }

    public static String buildAppDataToMigrate(BandanaManager bandanaManager, String appKey, Map<String, String> appConfigMap) {
        JsonObject appData = new JsonObject();
        for (Map.Entry<String, String> entry : appConfigMap.entrySet()) {
            String value = null;
            try {
                value = (String)bandanaManager.getValue((BandanaContext)bandanaContext, appKey + "." + entry.getKey());
            }
            catch (Exception e) {
                log.debug("Error while retrieving app data ", (Throwable)e);
            }
            if (value == null) {
                value = entry.getValue();
            }
            if (value.equals("on")) {
                appData.addProperty(entry.getKey(), Boolean.valueOf(true));
                continue;
            }
            if (value.equals("off")) {
                appData.addProperty(entry.getKey(), Boolean.valueOf(false));
                continue;
            }
            appData.addProperty(entry.getKey(), value);
        }
        Gson gson = new Gson();
        String payload = gson.toJson((JsonElement)appData);
        return payload;
    }

    public static String buildAppDataCustomToMigrate(BandanaManager bandanaManager, String appKey, Map<String, String> appConfigMap, Map<String, String> cloudKeysMap) {
        JsonObject appData = new JsonObject();
        for (Map.Entry<String, String> entry : appConfigMap.entrySet()) {
            String value = null;
            try {
                value = (String)bandanaManager.getValue((BandanaContext)bandanaContext, appKey + "." + entry.getKey());
            }
            catch (Exception e) {
                log.debug("Error while retrieving app data : {}", (Throwable)e);
            }
            if (value == null) {
                value = entry.getValue();
            }
            if (value.equals("on")) {
                appData.addProperty(cloudKeysMap.get(entry.getKey()), Boolean.valueOf(true));
                continue;
            }
            if (value.equals("off")) {
                appData.addProperty(cloudKeysMap.get(entry.getKey()), Boolean.valueOf(false));
                continue;
            }
            appData.addProperty(cloudKeysMap.get(entry.getKey()), value);
        }
        return ScriptUtils.appDatatoJson(appData);
    }

    public static String buildProfilesForMigration(BandanaManager bandanaManager, String appKey) {
        Map profileMap = null;
        try {
            profileMap = (Map)bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), appKey + ".profile");
        }
        catch (Exception exception) {
            log.error("Problem while access profiles {} ", (Throwable)exception);
        }
        JsonObject profilesData = new JsonObject();
        if (profileMap != null) {
            for (Map.Entry profile : profileMap.entrySet()) {
                JsonObject profileData = new JsonObject();
                Map<String, String> profileParamMap = ScriptUtils.getMap((String)profile.getValue());
                String user = profileParamMap.get("user");
                String url = profileParamMap.get("url");
                String headerparams = profileParamMap.get("headerparams");
                String urlparams = profileParamMap.get("urlparams");
                String accessToken = profileParamMap.get("accesstoken");
                String passwordenc = profileParamMap.get("passwordenc");
                String password = profileParamMap.get("password");
                if (StringUtils.isNotBlank((String)user)) {
                    profileData.addProperty("user", user);
                }
                if (StringUtils.isNotBlank((String)url)) {
                    profileData.addProperty("url", url);
                }
                if (StringUtils.isNotBlank((String)headerparams)) {
                    profileData.addProperty("requestHeaders", headerparams);
                }
                if (StringUtils.isNotBlank((String)urlparams)) {
                    profileData.addProperty("urlParameters", urlparams);
                }
                profileData.addProperty("type", profileParamMap.getOrDefault("profiletype", "URL").toLowerCase());
                if (StringUtils.isNotBlank((String)accessToken)) {
                    try {
                        profileData.addProperty("accessToken", EncryptDecryptHelper.decryptText(accessToken));
                    }
                    catch (Exception e) {
                        log.error("Exception in decryption : {}" + e);
                        profileData.addProperty("accessToken", "");
                    }
                }
                if (StringUtils.isNotBlank((String)passwordenc)) {
                    try {
                        profileData.addProperty("password", EncryptDecryptHelper.decryptText(passwordenc));
                    }
                    catch (Exception e) {
                        log.error("Exception in getting password-enc decryption : {} " + e);
                        profileData.addProperty("password", "");
                    }
                } else if (StringUtils.isNotBlank((String)password)) {
                    profileData.addProperty("password", password);
                }
                profilesData.add((String)profile.getKey(), (JsonElement)profileData);
            }
        }
        return ScriptUtils.appDatatoJson(profilesData);
    }

    public static String appDatatoJson(JsonObject propertiesData) {
        Gson gson = new Gson();
        String payload = gson.toJson((JsonElement)propertiesData);
        return payload;
    }

    public static Map<String, Object> getPluginInfo(PluginLicenseManager licenseManager) {
        HashMap<String, Object> pluginAnalyticsData = new HashMap<String, Object>();
        try {
            PluginAccessor pluginAccessor = (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor");
            pluginAnalyticsData.put("version", ScriptUtils.getPluginVersion(licenseManager, pluginAccessor));
            pluginAnalyticsData.put("state", pluginAccessor.getPlugin(ScriptUtils.getPluginKey(licenseManager)).getPluginState());
            ScriptUtils.populatePluginLicenseInfo(licenseManager, pluginAnalyticsData);
        }
        catch (Exception e) {
            log.debug("Error while capturing plugin information ", (Throwable)e);
            pluginAnalyticsData.put("pluginInfoError", "Internal error");
            pluginAnalyticsData.put("pluginInfoErrorDetail", e.getMessage());
        }
        return pluginAnalyticsData;
    }

    private static void populatePluginLicenseInfo(PluginLicenseManager licenseManager, Map<String, Object> pluginAnalyticsData) throws Exception {
        HashMap<String, Object> licenseData = new HashMap<String, Object>();
        Option pluginLicenseOption = licenseManager.getLicense();
        if (pluginLicenseOption != null && pluginLicenseOption.isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)pluginLicenseOption.get();
            if (pluginLicense != null && pluginLicense.getSupportEntitlementNumber().isDefined()) {
                licenseData.put("supportEntitlementNumber", pluginLicense.getSupportEntitlementNumber().get());
            } else {
                licenseData.put("supportEntitlementNumber", "NONE");
            }
            licenseData.put("type", pluginLicense.getLicenseType().name());
            licenseData.put("evaluation", pluginLicense.isEvaluation());
            licenseData.put("active", pluginLicense.isValid());
        } else {
            licenseData.put("supportEntitlementNumber", "NONE");
            licenseData.put("type", "UNLICENSED");
            licenseData.put("pluginLicenseError", "NONE");
        }
        pluginAnalyticsData.put("license", licenseData);
    }

    public static Map<String, Object> getHostInfo(HostLicenseInformation hostLicenseInformation) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            LicenseService licenseService = (LicenseService)ContainerManager.getComponent((String)"licenseService");
            SystemInformationService systemInformationService = (SystemInformationService)ContainerManager.getComponent((String)"systemInformationService");
            ConfluenceInfo confluenceInfo = systemInformationService.getConfluenceInfo();
            data.put("host", confluenceInfo.getServerId());
            data.put("version".toString(), confluenceInfo.getVersion());
            data.put("licenseType", licenseService.retrieve().getLicenseType().name());
        }
        catch (Exception e) {
            log.debug("Error while capturing host information ", (Throwable)e);
            return null;
        }
        return data;
    }

    @Deprecated
    public static Map<String, Object> getHostInfo() {
        return ScriptUtils.getHostInfo(null);
    }

    private static String getPluginVersion(PluginLicenseManager licenseManager, PluginAccessor pluginAccessor) {
        return pluginAccessor.getPlugin(licenseManager.getPluginKey()).getPluginInformation().getVersion();
    }

    private static String getPluginKey(PluginLicenseManager licenseManager) {
        return licenseManager.getPluginKey();
    }

    public static String getAnalyticsProjectConfig() {
        try {
            LicenseService licenseService = (LicenseService)ContainerManager.getComponent((String)"licenseService");
            String licenseType = licenseService.retrieve().getLicenseType().name();
            if (licenseType.equals(LicenseType.DEVELOPER.name()) || licenseType.equals(LicenseType.TESTING.name())) {
                return "application-dev.properties";
            }
            return "application-prod.properties";
        }
        catch (Exception e) {
            log.debug("Error finding project config.", (Object)e.toString());
            return "application-dev.properties";
        }
    }

    public static boolean isReadOnly() {
        boolean result = false;
        try {
            Object accessModeService = ContainerManager.getInstance().getContainerContext().getComponent((Object)"accessModeService");
            if (null != accessModeService) {
                result = (Boolean)accessModeService.getClass().getMethod("isReadOnlyAccessModeEnabled", new Class[0]).invoke(accessModeService, new Object[0]);
            }
        }
        catch (Exception e) {
            log.debug("Error checking readonly mode.", (Object)e.toString());
        }
        return result;
    }

    public static boolean addBobSwiftWebSection(WebInterfaceContext context, String pluginKey) {
        boolean result;
        block4: {
            result = true;
            try {
                if (ScriptUtils.isReadOnly()) break block4;
                Date thisPluginLoadDate = null;
                PluginAccessor pluginAccessor = (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor");
                WebInterfaceManager webInterfaceManager = (WebInterfaceManager)ContainerManager.getComponent((String)"webInterfaceManager");
                Plugin thisPlugin = pluginAccessor.getEnabledPlugin(pluginKey);
                if (thisPlugin != null && thisPlugin.getModuleDescriptor("bobswift-config-section") != null) {
                    thisPluginLoadDate = thisPlugin.getDateLoaded();
                }
                List webDescriptors = webInterfaceManager.getSections("system.admin");
                for (WebSectionModuleDescriptor w : webDescriptors) {
                    Date otherPluginLoadDate;
                    if (w.getPluginKey().equalsIgnoreCase(pluginKey) || !w.getKey().equalsIgnoreCase("bobswift-config-section") || !w.getPluginKey().contains("org.swift.confluence") || !(otherPluginLoadDate = w.getPlugin().getDateLoaded()).before(thisPluginLoadDate)) continue;
                    result = false;
                    break;
                }
            }
            catch (Exception e) {
                log.error("Error while adding web section ", (Object)e.toString());
                return result;
            }
        }
        return result;
    }

    public static boolean isXssTagsExists(String htmlContent) {
        boolean result = false;
        if (StringUtils.isNotBlank((String)htmlContent)) {
            Document doc = Jsoup.parse(htmlContent);
            Elements scriptTag = doc.select("script");
            Elements onEvents = doc.getElementsByAttributeStarting("on");
            Elements anchorWithScript = doc.select("a[href*=javascript]");
            Elements anchorWithUnicodeScript = doc.select("a[href*=&#106;&#97;&#118;&#97;&#115;&#99;&#114;&#105;&#112;&#116;]");
            Elements allTagIncludes = doc.select("script[src], iframe[src], input[src], img[src], img[dynsrc], img[lowsrc], audio[src], source[src], source[srcset], embed[src], track[src], video[src]");
            Elements linkWithScript = doc.select("link[href*=javascript]");
            Elements objectInclude = doc.select("object[data]");
            Elements backgroudElements = doc.getElementsByAttributeStarting("background");
            Elements styleBkgdImage = doc.getElementsByAttributeValueContaining("style", "background-image");
            Elements styleExpression = doc.getElementsByAttributeValueContaining("style", "expression");
            result = StringUtils.isNotBlank((String)scriptTag.toString()) || StringUtils.isNotBlank((String)onEvents.toString()) || StringUtils.isNotBlank((String)anchorWithScript.toString()) || StringUtils.isNotBlank((String)anchorWithUnicodeScript.toString()) || StringUtils.isNotBlank((String)allTagIncludes.toString()) || StringUtils.isNotBlank((String)linkWithScript.toString()) || StringUtils.isNotBlank((String)objectInclude.toString()) || StringUtils.isNotBlank((String)backgroudElements.toString()) || StringUtils.isNotBlank((String)styleBkgdImage.toString()) || StringUtils.isNotBlank((String)styleExpression.toString());
        }
        return result;
    }

    public static Map<String, Object> hideSensitiveData(Map<String, Object> sourceDataMap, Map<String, String> sensitiveDataMapWithDefaultVal) {
        try {
            if (sourceDataMap != null && !sourceDataMap.isEmpty() && sensitiveDataMapWithDefaultVal != null && !sensitiveDataMapWithDefaultVal.isEmpty()) {
                CaseInsensitiveMap sourceMap = new CaseInsensitiveMap(sourceDataMap);
                for (Map.Entry<String, String> param : sensitiveDataMapWithDefaultVal.entrySet()) {
                    String paramName = param.getKey();
                    if (!sourceMap.containsKey(paramName) || !StringUtils.isNotBlank((String)((String)sourceMap.get(paramName)))) continue;
                    sourceMap.put(paramName, param.getValue());
                }
                return sourceMap;
            }
        }
        catch (Exception e) {
            log.debug("Error while hiding sensitive data {} ", (Object)e.getMessage());
        }
        return sourceDataMap;
    }

    private static Whitelist buildWhiteList() {
        Whitelist allowedTags = Whitelist.relaxed();
        allowedTags.addAttributes(":all", "style", "class");
        return allowedTags;
    }

    public static boolean hasXssContent(String htmlContent) {
        if (StringUtils.isNotBlank((String)htmlContent)) {
            return !Jsoup.isValid(htmlContent, ScriptUtils.buildWhiteList());
        }
        return false;
    }

    public static String cleanXssInHtml(String htmlContent) {
        if (StringUtils.isNotBlank((String)htmlContent)) {
            return Jsoup.clean(htmlContent, ScriptUtils.buildWhiteList());
        }
        return htmlContent;
    }

    public static boolean isPreviewUrl(String url) {
        Matcher matcher = PREVIEW_URL_PATTERN.matcher(url);
        if (matcher.find()) {
            log.debug("The URL {} is a preview URL and its not a valid attachment URL. Please use the attachment option. ", (Object)url);
            return true;
        }
        return false;
    }

    public static boolean isUrl(String url) {
        return url.contains("://");
    }

    public static String appendUrls(String url1, String url2) {
        boolean endsWith = url1.endsWith("/");
        boolean startsWith = url2.startsWith("/");
        if (endsWith && startsWith) {
            return url1 + url2.substring(1);
        }
        if (!endsWith && !startsWith) {
            return url1 + '/' + url2;
        }
        return url1 + url2;
    }

    public static InputStream retrieveDataFromAppLink(MacroInfo info, ApplicationLink appLink, String url, String cookie, I18nResolver i18nResolver, String pluginKeyPrefix) throws MacroExecutionException {
        ApplicationLinkRequestFactory requestFactory = appLink.createAuthenticatedRequestFactory();
        try {
            Response response;
            ApplicationLinkRequest applicationLinkRequest = requestFactory.createRequest(Request.MethodType.GET, url);
            if (cookie != null) {
                applicationLinkRequest.setHeader("Cookie", cookie);
            }
            if ((response = (Response)applicationLinkRequest.execute((ApplicationLinkResponseHandler)new ApplicationLinkResponseHandler<Response>(){

                public Response handle(Response response) throws ResponseException {
                    return response;
                }

                public Response credentialsRequired(Response response) throws ResponseException {
                    return response;
                }
            })).isSuccessful()) {
                InputStream stream = response.getResponseBodyAsStream();
                return stream;
            }
            throw new MacroExecutionException(response.getStatusCode() + " : " + response.getStatusText());
        }
        catch (CredentialsRequiredException e) {
            URI authorisationURI = e.getAuthorisationURI(appLink.getRpcUrl());
            throw new MacroExecutionException(i18nResolver.getText(pluginKeyPrefix + ".click-to-authorize", new Serializable[]{authorisationURI.toString()}));
        }
        catch (ResponseException re) {
            log.error(re.getMessage());
            throw new MacroExecutionException(i18nResolver.getText(pluginKeyPrefix + ".error.http.invalid") + ".");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new MacroExecutionException(e.getMessage());
        }
    }

    public static String getStreamAsString(MacroInfo info, InputStream stream) throws MacroExecutionException, IOException {
        String data = ScriptUtils.getStreamAsString(stream, info.getMacroParams().getString("encoding", ""));
        IOUtils.closeQuietly((InputStream)stream);
        return data;
    }

    public static ApplicationLink getApplicationLinkFromURL(String url, ApplicationLinkService applicationLinkService) {
        if (StringUtils.isNotBlank((String)url)) {
            for (ApplicationLink appLink : applicationLinkService.getApplicationLinks()) {
                if (!url.contains(appLink.getDisplayUrl().toString())) continue;
                return appLink;
            }
        }
        return null;
    }

    public static void safeWatchStart(StopWatch startWatch) {
        try {
            startWatch.start();
        }
        catch (IllegalStateException exception) {
            log.error("Exception while starting the stopwatch: {}", (Throwable)exception);
        }
    }

    public static void safeWatchStop(StopWatch stopWatch) {
        try {
            stopWatch.stop();
        }
        catch (IllegalStateException exception) {
            log.error("Exception while stoping the stopwatch: {}", (Throwable)exception);
        }
    }

    public static String getLoggedinUserTime(UserAccessor userAccessor, FormatSettingsManager formatSettingsManager) throws Exception {
        ConfluenceUserPreferences preferences = userAccessor.getConfluenceUserPreferences((User)AuthenticatedUserThreadLocal.get());
        SimpleDateFormat dateFormatter = new SimpleDateFormat("HH:mm a MM/dd/yyyy z");
        dateFormatter.setTimeZone(preferences.getTimeZone().getWrappedTimeZone());
        return dateFormatter.format(new Date(System.currentTimeMillis()));
    }

    public static boolean checkForhyperlinkTag(String message) {
        String hyperlinkTagPattern = "(?i)<a([^>]+)>(.+?)</a>";
        Pattern patternTag = Pattern.compile(hyperlinkTagPattern);
        Matcher matcherTag = patternTag.matcher(message);
        return matcherTag.find();
    }
}

