/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBean;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.scriptutil.ScriptUtils;

public class ProfileHelper {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final MacroInfo info;
    protected final I18NBean i18nBean;
    protected final String i18nPrefix;
    protected final BandanaManager bandanaManager;
    protected final UserAccessor userAccessor;
    protected final String bandanaKey;
    protected final String macroName;
    protected String profileParameterName = "profile";
    protected String profileDefault = "";
    protected String profileName;
    protected Map<String, String> profileMap = null;
    protected int recursionLevel = 0;
    protected int recursionMaximum = 5;
    protected boolean throwNotFoundException = true;

    public ProfileHelper(MacroInfo info, I18NBean i18nBean, String i18nPrefix, BandanaManager bandanaManager, UserAccessor userAccessor, String bandanaKey, String macroName) {
        this.info = info;
        this.bandanaManager = bandanaManager;
        this.userAccessor = userAccessor;
        this.bandanaKey = bandanaKey;
        this.macroName = macroName;
        this.i18nBean = i18nBean;
        this.i18nPrefix = i18nPrefix;
    }

    public void setProfileParameterName(String name) {
        this.profileParameterName = name;
    }

    public String getProfileParameterName() {
        return this.profileParameterName;
    }

    public void setProfileDefault(String defaultValue) {
        this.profileDefault = defaultValue;
    }

    public void setRecursionMaximum(int max) {
        this.recursionMaximum = max;
    }

    public void setThrowNotFoundException(boolean value) {
        this.throwNotFoundException = value;
    }

    public String getProfileName() {
        if (this.profileName == null) {
            this.profileName = this.info.getMacroParams().getString(this.getProfileParameterName(), "").trim();
        }
        return this.profileName;
    }

    public String getUrlParameter() throws MacroExecutionException {
        String url = this.getStringParameter("url", null);
        if (url != null && !ScriptUtils.isUrl(url) && this.getProfileMap().get("url") != null) {
            url = ScriptUtils.appendUrls(this.getProfileMap().get("url"), url);
        }
        return url;
    }

    public String getStringParameter(String parameter, String defaultValue) throws MacroExecutionException {
        String value = this.info.getMacroParams().getString(parameter, null);
        if (value == null && (value = this.getProfileMap().get(parameter)) == null) {
            value = defaultValue;
        }
        return value;
    }

    public Integer getIntegerParameter(String parameter, Integer defaultValue) throws MacroExecutionException {
        Integer value = this.info.getMacroParams().getInteger(parameter, null);
        if (value == null && (value = ScriptUtils.getIntegerOrNull(this.getProfileMap().get(parameter))) == null) {
            value = defaultValue;
        }
        return value;
    }

    public Map<String, String> getProfileMap() throws MacroExecutionException {
        if (this.profileMap == null) {
            String profileName = this.getProfileName();
            if (StringUtils.isNotBlank((String)profileName)) {
                this.profileMap = ScriptUtils.getMap(this.getProfileString(profileName, this.bandanaKey, this.throwNotFoundException));
            }
            if (this.profileMap == null) {
                this.profileMap = new HashMap<String, String>();
            } else {
                this.updateProfileMap();
            }
        }
        return this.profileMap;
    }

    protected void updateProfileMap() throws MacroExecutionException {
        ++this.recursionLevel;
        this.log.debug("recursion level: {}, max level: {}", (Object)this.recursionLevel, (Object)this.recursionMaximum);
        if (this.recursionLevel <= this.recursionMaximum) {
            String referencedProfile = this.profileMap.get(this.profileParameterName);
            if (StringUtils.isNotBlank((String)referencedProfile)) {
                try {
                    Map<String, String> referencedProfileMap = ScriptUtils.getMap(this.getProfileString(referencedProfile, this.bandanaKey, true));
                    this.log.debug("referenced profile found: {}, map: {}", (Object)referencedProfile, referencedProfileMap);
                    this.profileMap.remove(this.profileParameterName);
                    for (String key : referencedProfileMap.keySet()) {
                        if (this.profileMap.containsKey(key)) continue;
                        this.profileMap.put(key, referencedProfileMap.get(key));
                    }
                    if (this.log.isDebugEnabled()) {
                        for (String key : this.profileMap.keySet()) {
                            this.log.debug("key: {}, value: {}", (Object)key, (Object)this.profileMap.get(key));
                        }
                    }
                    this.updateProfileMap();
                }
                catch (MacroExecutionException exception) {
                    this.log.debug("Indirectly referenced from profile: {}, recursion level: {}", (Object)this.getProfileName(), (Object)this.recursionLevel);
                    this.log.error(exception.toString());
                }
            }
        } else if (this.recursionMaximum <= 0) {
            this.profileMap.put(this.profileParameterName, this.getProfileName());
        }
    }

    protected String getProfileString(String profile, String bandanaKey, boolean throwNotFoundException) throws MacroExecutionException {
        String value = null;
        if (profile != null) {
            try {
                Object object = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), bandanaKey);
                if (object instanceof Map) {
                    Map map = (Map)object;
                    value = (String)map.get(profile);
                }
            }
            catch (Exception exception) {
                this.log.error("Exception accessing profile data: {}", (Object)exception.toString(), (Object)exception);
                throw new MacroExecutionException("Exception accessing profile data for " + bandanaKey + ". Exception: " + exception);
            }
            if (value == null && throwNotFoundException) {
                throw new MacroExecutionException(ScriptUtils.getText(this.i18nBean, this.i18nPrefix + ".error.profile.profile-not-found", profile));
            }
        }
        return value;
    }
}

