/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.macroutil;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import java.util.Map;
import org.swift.confluence.macroutil.ConfluencePageInfo;
import org.swift.confluence.macroutil.MacroParameterStorage;

public class MacroInfo
extends ConfluencePageInfo {
    public static final String MACRO_BODY = "@body";
    private static final ThreadLocal<ConversionContext> CONVERSION_CONTEXT_THREAD_LOCAL = new ThreadLocal();
    private final String body;
    private Map<String, String> macroParametersMap;
    private XhtmlContent xhtmlContent;
    protected ConversionContext conversionContext;
    private MacroParameterStorage macroParameterStorage;

    public static ConversionContext getCurrentConversionContext() {
        return CONVERSION_CONTEXT_THREAD_LOCAL.get();
    }

    public MacroInfo(Map<String, String> params, String body, ConversionContext conversionContext) {
        super(conversionContext.getEntity());
        this.macroParametersMap = params;
        this.body = body;
        this.setConversionContext(conversionContext);
        this.macroParametersMap.put(MACRO_BODY, body);
    }

    public String getMacroBody() {
        return this.body;
    }

    public MacroParameterStorage getMacroParams() {
        if (this.macroParameterStorage == null) {
            this.macroParameterStorage = new MacroParameterStorage(this.macroParametersMap);
        }
        return this.macroParameterStorage;
    }

    public Map<String, String> getMacroParamsMap() {
        return this.macroParametersMap;
    }

    public ConversionContext getConversionContext() {
        return this.conversionContext;
    }

    private void setConversionContext(ConversionContext conversionContext) {
        this.conversionContext = conversionContext;
        CONVERSION_CONTEXT_THREAD_LOCAL.set(conversionContext);
    }

    public XhtmlContent getXhtmlContent() {
        return this.xhtmlContent;
    }

    @Override
    public void close() {
        super.close();
        if (CONVERSION_CONTEXT_THREAD_LOCAL.get() == this.conversionContext) {
            CONVERSION_CONTEXT_THREAD_LOCAL.remove();
        }
        this.conversionContext = null;
    }
}

