/*
 * Decompiled with CFR 0.152.
 */
package com.appfire.confluence.rest.analytics;

import com.appfire.common.analytics.util.AnalyticEvent;
import com.appfire.confluence.rest.analytics.Analytics;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.upm.api.license.HostLicenseInformation;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.event.PluginLicenseAddedEvent;
import com.atlassian.upm.api.license.event.PluginLicenseUpdatedEvent;
import com.atlassian.upm.datacentercompatibility.impl.CompatibilityHostLicenseInformation;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.swift.confluence.scriptutil.EncryptDecryptHelper;

@Component
public class AnalyticsListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsListener.class);
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final BandanaManager bandanaManager;
    @ComponentImport
    private final XhtmlContent xhtmlManager;
    private final CompatibilityHostLicenseInformation hostLicenseInformation;
    @ComponentImport
    private final PluginLicenseEventRegistry pluginLicenseEventRegistry;
    private final Analytics analytics;
    @ComponentImport
    private final BootstrapManager bootstrapManager;

    @Autowired
    public AnalyticsListener(@ComponentImport EventPublisher eventPublisher, @ComponentImport PluginLicenseManager pluginLicenseManager, BandanaManager bandanaManager, XhtmlContent xhtmlManager, @ComponentImport HostLicenseInformation upmHostLicenseInformation, @ComponentImport LicenseHandler licenseHandler, PluginLicenseEventRegistry pluginLicenseEventRegistry, BootstrapManager bootstrapManager) {
        this.eventPublisher = eventPublisher;
        this.eventPublisher.register((Object)this);
        this.bandanaManager = bandanaManager;
        this.xhtmlManager = xhtmlManager;
        this.bootstrapManager = bootstrapManager;
        this.pluginLicenseEventRegistry = pluginLicenseEventRegistry;
        this.pluginLicenseEventRegistry.register((Object)this);
        this.hostLicenseInformation = new CompatibilityHostLicenseInformation(upmHostLicenseInformation, licenseHandler);
        this.analytics = new Analytics(pluginLicenseManager, this.hostLicenseInformation);
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        try {
            String filePrefix = "org.swift.confluence";
            String confluenceSharedHome = this.bootstrapManager.getSharedHome().getAbsolutePath();
            String pluginFolderPath = confluenceSharedHome + File.separator + filePrefix;
            EncryptDecryptHelper.initialize(pluginFolderPath, filePrefix);
        }
        catch (Exception e) {
            log.error("Error while generating encryption keys ", (Object)e.getMessage());
        }
        Plugin thisPlugin = event.getPlugin();
        try {
            if ("org.swift.confluence.cli".equalsIgnoreCase(thisPlugin.getKey())) {
                this.analytics.postInstallUninstallEvent(AnalyticEvent.Event.INSTALL);
            }
        }
        catch (Exception e) {
            log.error("Error in analytics listener : {}", (Object)e.getMessage());
        }
    }

    public void destroy() throws Exception {
        this.analytics.postInstallUninstallEvent(AnalyticEvent.Event.UNINSTALL);
        log.debug("destroy called");
        this.eventPublisher.unregister((Object)this);
        this.pluginLicenseEventRegistry.unregister((Object)this);
    }

    @EventListener
    public void onEvent(PluginLicenseAddedEvent event) {
        this.analytics.postAnalyticsEvent(AnalyticEvent.Event.LICENSED, AnalyticEvent.SubEvent.LICENSEADDED.getEvent());
    }

    @EventListener
    public void onEvent(PluginLicenseUpdatedEvent event) {
        this.analytics.postAnalyticsEvent(AnalyticEvent.Event.LICENSED, AnalyticEvent.SubEvent.LICENSEUPDATED.getEvent());
    }

    public void afterPropertiesSet() throws Exception {
    }
}

