/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.macroutil.MacroInfo;

public class TableHelper {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected boolean enableHighlighting = true;
    protected boolean enableSorting = true;
    protected boolean sortDescending = false;
    protected boolean retainRowStyleOrder = true;
    protected boolean autoNumber = false;
    protected boolean autoNumberSort = false;
    protected boolean enableHeadingAttributes = true;
    protected boolean autoTotal = false;
    protected boolean sortIcon = false;
    protected int heading = 1;
    protected int footing = 0;
    protected String sortTip = "@default";
    protected String sortColumn = "";
    protected String highlightColor = "lightgoldenrodyellow";
    protected String columnAttributes = "";
    protected String columnTypes = "";
    protected String columnCalculations = "";
    protected boolean allowExport = false;
    protected boolean displayDataFilter = false;
    protected String width = "";
    protected String border = "";
    protected String tableClass = "";
    protected String style = "";
    protected boolean multiple = true;
    protected String columnStyles = "";
    protected String rowStyles = "";
    protected String autoTotalRowStyle = "";
    protected boolean applyRowStyleToCell = false;
    protected boolean hideHeader = false;
    protected boolean applyColStyleToCell = false;
    protected String exportFileDelimiter = "Comma";
    protected String rowOrientation = "vertical";
    protected static final String FALSE = "false";
    protected static final String DEFAULT = "@default";
    protected static final String TABLE_SORTER_OBJECT = "org_swift_TableSorter";
    protected static final String MODULE = "org.swift.confluence.tablesorter:tablesorter";

    protected void setHeading(MacroInfo info) {
        String headingString = info.getMacroParams().getString("heading", null);
        if (headingString != null) {
            if (FALSE.equalsIgnoreCase(headingString)) {
                this.heading = 0;
            } else {
                try {
                    this.heading = Integer.parseInt(headingString);
                    if (this.heading < 0) {
                        this.heading = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    protected int getHeading() {
        return this.heading;
    }

    public boolean isAllowExport() {
        return this.allowExport;
    }

    public boolean hasAttachmentPermission(MacroInfo info) {
        PermissionManager permissionManager = (PermissionManager)ContainerManager.getComponent((String)"permissionManager");
        return permissionManager.hasCreatePermission((User)AuthenticatedUserThreadLocal.get(), (Object)info.getContent(), Attachment.class);
    }

    public Map<String, String> getTableProperties(MacroInfo info) {
        HashMap<String, String> tablePropertyMap = new HashMap<String, String>();
        tablePropertyMap.put("enableHighlighting", info.getMacroParams().getBoolean("enableHighlighting", this.enableHighlighting).toString());
        tablePropertyMap.put("enableSorting", info.getMacroParams().getBoolean("enableSorting", this.enableSorting).toString());
        tablePropertyMap.put("sortDescending", info.getMacroParams().getBoolean("sortDescending", this.sortDescending).toString());
        tablePropertyMap.put("retainRowStyleOrder", info.getMacroParams().getBoolean("retainRowStyleOrder", this.retainRowStyleOrder).toString());
        tablePropertyMap.put("autoNumber", info.getMacroParams().getBoolean("autoNumber", this.autoNumber).toString());
        tablePropertyMap.put("autoNumberSort", info.getMacroParams().getBoolean("autoNumberSort", this.autoNumberSort).toString());
        tablePropertyMap.put("enableHeadingAttributes", info.getMacroParams().getBoolean("enableHeadingAttributes", this.enableHeadingAttributes).toString());
        tablePropertyMap.put("autoTotal", info.getMacroParams().getBoolean("autoTotal", this.autoTotal).toString());
        tablePropertyMap.put("sortIcon", info.getMacroParams().getBoolean("sortIcon", this.sortIcon).toString());
        tablePropertyMap.put("sortTip", info.getMacroParams().getString("sortTip", this.sortTip));
        tablePropertyMap.put("sortColumn", info.getMacroParams().getString("sortColumn", this.sortColumn));
        tablePropertyMap.put("highlightColor", info.getMacroParams().getString("highlightColor", this.highlightColor));
        tablePropertyMap.put("columnAttributes", info.getMacroParams().getString("columnAttributes", this.columnAttributes));
        tablePropertyMap.put("columnTypes", info.getMacroParams().getString("columnTypes", this.columnTypes));
        tablePropertyMap.put("columnCalculations", info.getMacroParams().getString("columnCalculations", this.columnCalculations));
        tablePropertyMap.put("footing", info.getMacroParams().getInteger("footing", this.footing).toString());
        this.setHeading(info);
        tablePropertyMap.put("heading", String.valueOf(this.getHeading()));
        tablePropertyMap.put("hasAttachmentPermission", String.valueOf(this.hasAttachmentPermission(info)));
        tablePropertyMap.put("allowExport", String.valueOf(info.getMacroParams().getBoolean("allowExport", this.allowExport)));
        tablePropertyMap.put("displayDataFilter", String.valueOf(info.getMacroParams().getBoolean("displayDataFilter", this.displayDataFilter)));
        tablePropertyMap.put("width", info.getMacroParams().getString("width", this.width));
        tablePropertyMap.put("border", info.getMacroParams().getString("border", this.border));
        tablePropertyMap.put("style", info.getMacroParams().getString("style", this.style));
        tablePropertyMap.put("class", info.getMacroParams().getString("class", this.tableClass));
        tablePropertyMap.put("columnStyles", info.getMacroParams().getString("columnStyles", this.columnStyles));
        tablePropertyMap.put("rowStyles", info.getMacroParams().getString("rowStyles", this.rowStyles));
        tablePropertyMap.put("multiple", info.getMacroParams().getBoolean("multiple", this.multiple).toString());
        tablePropertyMap.put("applyRowStyleToCell", info.getMacroParams().getBoolean("applyRowStyleToCell", this.applyRowStyleToCell).toString());
        tablePropertyMap.put("applyColStyleToCell", info.getMacroParams().getBoolean("applyColStyleToCell", this.applyColStyleToCell).toString());
        tablePropertyMap.put("hideHeader", info.getMacroParams().getBoolean("hideHeader", this.hideHeader).toString());
        tablePropertyMap.put("exportFileDelimiter", info.getMacroParams().getString("exportFileDelimiter", this.exportFileDelimiter));
        tablePropertyMap.put("autoTotalRowStyle", info.getMacroParams().getString("autoTotalRowStyle", this.autoTotalRowStyle));
        tablePropertyMap.put("rowOrientation", info.getMacroParams().getString("rowOrientation", this.rowOrientation));
        return tablePropertyMap;
    }
}

