/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.scriptutil.EncryptDecryptHelper;
import org.swift.confluence.scriptutil.ScriptUtils;
import org.swift.confluence.scriptutil.bean.ProfileBean;

public class ProfileHelperAO {
    protected static final Logger log = LoggerFactory.getLogger(ProfileHelperAO.class);

    public static Object retrieveDataFromUrl(MacroInfo info, ProfileBean profileBean, String url, SettingsManager settingsManager, I18nResolver i18nResolver, String pluginKeyPrefix) throws MacroExecutionException, IOException {
        String headerParams = ProfileHelperAO.getStringParameter(info, profileBean, "headerparams", null);
        headerParams = ProfileHelperAO.applyReplacementVariablesForProfile(headerParams, info, profileBean, i18nResolver, pluginKeyPrefix);
        String urlParams = ProfileHelperAO.getStringParameter(info, profileBean, "urlparams", null);
        urlParams = ProfileHelperAO.applyReplacementVariablesForProfile(urlParams, info, profileBean, i18nResolver, pluginKeyPrefix);
        String password = null;
        try {
            password = ProfileHelperAO.retrivePassword(info, profileBean);
        }
        catch (Exception e) {
            throw new MacroExecutionException(i18nResolver.getText(pluginKeyPrefix + ".problem.encountered.retrieving.password"));
        }
        InputStream stream = ProfileHelperAO.getUrlStreamWithParams(info, profileBean, url, false, ProfileHelperAO.getSessionCookie(info, url, settingsManager), headerParams, urlParams, password, settingsManager, i18nResolver, pluginKeyPrefix);
        String data = ScriptUtils.getStreamAsString(stream, info.getMacroParams().getString("encoding", ""));
        IOUtils.closeQuietly((InputStream)stream);
        return data;
    }

    public static InputStream retrieveStreamFromUrl(MacroInfo info, ProfileBean profileBean, String url, SettingsManager settingsManager, I18nResolver i18nResolver, String pluginKeyPrefix) throws MacroExecutionException, IOException {
        String headerParams = ProfileHelperAO.getStringParameter(info, profileBean, "headerparams", null);
        headerParams = ProfileHelperAO.applyReplacementVariablesForProfile(headerParams, info, profileBean, i18nResolver, pluginKeyPrefix);
        String urlParams = ProfileHelperAO.getStringParameter(info, profileBean, "urlparams", null);
        urlParams = ProfileHelperAO.applyReplacementVariablesForProfile(urlParams, info, profileBean, i18nResolver, pluginKeyPrefix);
        String password = null;
        try {
            password = ProfileHelperAO.retrivePassword(info, profileBean);
        }
        catch (Exception e) {
            throw new MacroExecutionException(i18nResolver.getText(pluginKeyPrefix + ".problem.encountered.retrieving.password"));
        }
        InputStream stream = ProfileHelperAO.getUrlStreamWithParams(info, profileBean, url, false, ProfileHelperAO.getSessionCookie(info, url, settingsManager), headerParams, urlParams, password, settingsManager, i18nResolver, pluginKeyPrefix);
        return stream;
    }

    private static String applyReplacementVariablesForProfile(String input, MacroInfo info, ProfileBean profileBean, I18nResolver i18nResolver, String pluginKeyPrefix) throws MacroExecutionException {
        if (StringUtils.isNotBlank((String)input)) {
            try {
                String accessToken = ProfileHelperAO.getStringParameter(info, profileBean, "accesstoken", null);
                String user = ProfileHelperAO.getStringParameter(info, profileBean, "user", null);
                String password = ProfileHelperAO.retrivePassword(info, profileBean);
                if (StringUtils.isNotBlank((String)accessToken)) {
                    input = input.replaceAll("\\$accessToken", EncryptDecryptHelper.decryptText(accessToken));
                }
                if (StringUtils.isNotBlank((String)user)) {
                    input = input.replaceAll("\\$user", user);
                }
                if (StringUtils.isNotBlank((String)password)) {
                    input = input.replaceAll("\\$password", password);
                }
            }
            catch (Exception e) {
                throw new MacroExecutionException(i18nResolver.getText(pluginKeyPrefix + ".error.ocurred.decrypting.token"));
            }
        }
        return input;
    }

    private static String retrivePassword(MacroInfo info, ProfileBean profileBean) throws Exception {
        String password = null;
        if (profileBean != null && StringUtils.isNotBlank((String)(password = profileBean.getPassword()))) {
            return EncryptDecryptHelper.decryptText(password, password);
        }
        return password;
    }

    public static InputStream getUrlStreamWithParams(MacroInfo info, ProfileBean profileBean, String name, boolean wantJson, String cookie, String headerParams, String urlParams, String pwd, SettingsManager settingsManager, I18nResolver i18nResolver, String pluginKeyPrefix) throws MacroExecutionException {
        URLConnection connection = null;
        HttpURLConnection httpConnection = null;
        if (ScriptUtils.isUrlRelative(name)) {
            name = ProfileHelperAO.getBaseUrl(settingsManager) + (name.startsWith("/") ? "" : "/") + name;
        }
        StringBuffer urlString = new StringBuffer(name);
        if (urlParams != null && StringUtils.isNotBlank((String)urlParams)) {
            String[] urlParamsArr = urlParams.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            if (!name.contains("?")) {
                urlString.append("?");
            } else if (urlString.indexOf("?") != urlString.length() - 1) {
                urlString.append("&");
            }
            for (int i = 0; i < urlParamsArr.length; ++i) {
                urlString.append(urlParamsArr[i]);
                if (i == urlParamsArr.length - 1) continue;
                urlString.append("&");
            }
        }
        try {
            connection = new URL(urlString.toString()).openConnection();
            Integer timeout = info.getMacroParams().getInteger("timeout", -1);
            if (timeout > 0) {
                connection.setConnectTimeout(timeout);
                connection.setReadTimeout(timeout);
            }
            String user = ProfileHelperAO.getStringParameter(info, profileBean, "user", null);
            log.debug("user:{}", (Object)user);
            if (StringUtils.isNotBlank((String)user)) {
                String password;
                String string = password = StringUtils.isNotBlank((String)pwd) ? pwd : ProfileHelperAO.getStringParameter(info, profileBean, "password", null);
                if (StringUtils.isBlank((String)password)) {
                    throw new MacroExecutionException(i18nResolver.getText(pluginKeyPrefix + ".error.password-required"));
                }
                log.debug("Using basic authentication.");
                String basic = user + ":" + password;
                String encoding = new String(Base64.encodeBase64(basic.getBytes()));
                connection.setRequestProperty("Authorization", "Basic " + encoding);
            }
            if (wantJson) {
                connection.setRequestProperty("Content-Type", "application/json");
            }
            if (headerParams != null && StringUtils.isNotBlank((String)headerParams)) {
                String[] headerParamsArr;
                for (String headerParam : headerParamsArr = headerParams.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
                    connection.setRequestProperty(headerParam.split(":")[0].trim(), headerParam.split(":")[1].trim());
                }
            }
            if (cookie != null) {
                log.debug("Connection using cookie: {}", (Object)cookie);
                connection.setRequestProperty("Cookie", cookie);
            }
            ScriptUtils.log(connection.getRequestProperties(), "request properties");
            InputStream stream = connection.getInputStream();
            return stream;
        }
        catch (MalformedURLException e) {
            log.debug("Malformed: {}", (Object)e.getMessage());
            throw new MacroExecutionException(i18nResolver.getText(pluginKeyPrefix + ".error.http.invalid"));
        }
        catch (FileNotFoundException e) {
            log.debug("Not found: {}", (Object)e.getMessage());
            throw new MacroExecutionException(i18nResolver.getText(pluginKeyPrefix + ".error.http.not-found"));
        }
        catch (MacroExecutionException e) {
            log.debug("MacroExecutionException: {}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            int responseCode = -1;
            log.debug("Unexpected exception: " + e.getMessage());
            if (connection instanceof HttpURLConnection) {
                try {
                    httpConnection = (HttpURLConnection)connection;
                    responseCode = httpConnection.getResponseCode();
                    if (log.isDebugEnabled()) {
                        log.debug("Error retrieving server data: {}. Details: {}", (Object)responseCode, (Object)e.toString());
                        String errors = ScriptUtils.getStreamAsString(httpConnection.getErrorStream(), null);
                        log.debug("Server reported errors: {}", (Object)errors);
                    }
                }
                catch (IOException e1) {
                    log.debug("Attempts to log more information on the failure were not successful. " + e1.getMessage());
                }
            }
            if (responseCode == -1) {
                throw new MacroExecutionException(i18nResolver.getText(pluginKeyPrefix + ".error.server", new Serializable[]{e.getMessage()}));
            }
            throw new MacroExecutionException(ProfileHelperAO.getErrorMessage(responseCode, i18nResolver, pluginKeyPrefix));
        }
    }

    public static String getBaseUrl(SettingsManager settingsManager) {
        return settingsManager.getGlobalSettings().getBaseUrl();
    }

    protected static String getSessionCookie(MacroInfo info, String url, SettingsManager settingsManager) {
        log.debug("url: {}, baseUrl: {}", (Object)url, (Object)ProfileHelperAO.getBaseUrl(settingsManager));
        String cookie = null;
        if (ScriptUtils.isUrlRelative(url) || url.startsWith(ProfileHelperAO.getBaseUrl(settingsManager))) {
            if (info.getSession() != null) {
                String cookieName = null;
                if (cookieName == null) {
                    cookieName = System.getProperty("org.apache.catalina.SESSION_COOKIE_NAME");
                }
                if (cookieName == null) {
                    cookieName = "JSESSIONID";
                }
                cookie = cookieName + "=" + info.getSession().getId();
            } else {
                log.debug("No session, so session cookie could not be provided");
            }
        }
        log.debug("cookie: {}", cookie);
        return cookie;
    }

    public static String getUrlParameter(ProfileBean profileBean, MacroInfo info, String parameter, String defaultValue, BandanaManager bandanaManager, String whitelistConfigKey, String blacklistConfigKey) throws MacroExecutionException {
        String url = ProfileHelperAO.getStringParameter(info, profileBean, parameter, defaultValue);
        if (url != null && !ScriptUtils.isUrl(url) && profileBean.getUrl() != null) {
            url = ScriptUtils.appendUrls(profileBean.getUrl(), url);
        }
        ScriptUtils.checkUrlIsAllowed(url, true, bandanaManager, whitelistConfigKey, blacklistConfigKey);
        return url;
    }

    public static String getUrlParameter(ProfileBean profileBean, MacroInfo info, String parameter, String defaultValue, BandanaManager bandanaManager, String whitelistConfigKey, String blacklistConfigKey, String[] blacklistDomainValues) throws MacroExecutionException {
        String url = ProfileHelperAO.getStringParameter(info, profileBean, parameter, defaultValue);
        if (url != null && !ScriptUtils.isUrl(url) && profileBean.getUrl() != null) {
            url = ScriptUtils.appendUrls(profileBean.getUrl(), url);
        }
        ScriptUtils.checkUrlIsAllowed(url, true, bandanaManager, whitelistConfigKey, blacklistConfigKey, blacklistDomainValues);
        return url;
    }

    public static InputStream getUrlStream(MacroInfo info, ProfileBean profileBean, String name, SettingsManager settingsManager, I18nResolver i18nResolver, String pluginKeyPrefix) throws MacroExecutionException {
        if (profileBean != null && profileBean.getPassword() != null) {
            try {
                profileBean.setPassword(EncryptDecryptHelper.decryptText(profileBean.getPassword()));
            }
            catch (Exception e) {
                throw new MacroExecutionException(i18nResolver.getText(pluginKeyPrefix + ".problem.encountered.retrieving.password"));
            }
        }
        return ProfileHelperAO.getUrlStreamWithParams(info, profileBean, name, false, null, null, null, null, settingsManager, i18nResolver, pluginKeyPrefix);
    }

    public static String getStringParameter(MacroInfo info, ProfileBean profileBean, String parameter, String defaultValue) throws MacroExecutionException {
        String value = info.getMacroParams().getString(parameter, null);
        if (value == null) {
            value = ProfileHelperAO.getProfileBeanValue(info, profileBean, parameter, defaultValue);
            if (value == null) {
                value = defaultValue;
            }
        } else if (("script".equals(parameter) || "source".equals(parameter) || "style".equals(parameter)) && value.startsWith("#")) {
            value = value.substring(1);
        }
        return value;
    }

    public static String getProfileBeanValue(MacroInfo info, ProfileBean profileBean, String parameter, String defaultValue) {
        String value = info.getMacroParams().getString(parameter, null);
        if (value == null) {
            if (profileBean != null) {
                if ("script".equals(parameter) || "url".equals(parameter) || "source".equals(parameter) || "style".equals(parameter)) {
                    value = profileBean.getUrl();
                } else if ("password".equals(parameter)) {
                    value = profileBean.getPassword();
                } else if ("headerparams".equals(parameter)) {
                    value = profileBean.getHeaderParams();
                } else if ("urlparams".equals(parameter)) {
                    value = profileBean.getUrlParams();
                } else if ("accesstoken".equals(parameter)) {
                    value = profileBean.getAccessToken();
                } else if ("user".equals(parameter)) {
                    value = profileBean.getUser();
                }
            }
            if (value == null) {
                value = defaultValue;
            }
        }
        return value;
    }

    protected static String getErrorMessage(int responseCode, I18nResolver i18nResolver, String pluginKeyPrefix) {
        String message = i18nResolver.getText(pluginKeyPrefix + ".error.http.general", new Serializable[]{Integer.toString(responseCode)}) + ". ";
        switch (responseCode) {
            case 400: {
                message = message + i18nResolver.getText(pluginKeyPrefix + ".error.http.400") + ".";
                break;
            }
            case 401: {
                message = message + i18nResolver.getText(pluginKeyPrefix + ".error.http.401") + ".";
                break;
            }
            case 403: {
                message = message + i18nResolver.getText(pluginKeyPrefix + ".error.http.403") + ".";
                break;
            }
            case 404: {
                message = message + i18nResolver.getText(pluginKeyPrefix + ".error.http.404") + ".";
                break;
            }
            case 405: {
                message = message + i18nResolver.getText(pluginKeyPrefix + ".error.http.405") + ".";
                break;
            }
            case 406: {
                message = message + i18nResolver.getText(pluginKeyPrefix + ".error.http.406") + ".";
                break;
            }
            case 409: {
                message = message + i18nResolver.getText(pluginKeyPrefix + ".error.http.409") + ".";
                break;
            }
            case 415: {
                message = message + i18nResolver.getText(pluginKeyPrefix + ".error.http.415") + ".";
                break;
            }
        }
        return message;
    }
}

