/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.scriptutil.bean.ProfileBean;

public class OneDriveHelper {
    protected static final Logger log = LoggerFactory.getLogger(OneDriveHelper.class);
    static final String ONEDRIVE_GRAPH_API = "https://graph.microsoft.com/v1.0/me/drive/root:";
    static final String ONEDRIVE_ACCESSTOKEN_API = "https://login.microsoftonline.com/common/oauth2/v2.0/token";

    public static ProfileBean updateOneDriveAuth(ProfileBean profileBean, String baseUrl, I18nResolver i18nResolver, String appkey) throws MacroExecutionException {
        block5: {
            SimpleDateFormat inputFormat = new SimpleDateFormat("E MMM dd yyyy HH:mm:ss 'GMT'z", Locale.ENGLISH);
            inputFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date tokenExpiryDate = null;
            try {
                tokenExpiryDate = inputFormat.parse(profileBean.getExpiresOn());
                Date date = new Date();
                Date currentDate = inputFormat.parse(inputFormat.format(date));
                if (currentDate.compareTo(tokenExpiryDate) != 1) break block5;
                String result = OneDriveHelper.getAccessToken(profileBean, baseUrl);
                JSONObject json = new JSONObject(result);
                if (json.has("access_token")) {
                    profileBean.setAccessToken(json.getString("access_token"));
                    profileBean.setExpiry(json.getInt("expires_in"));
                    profileBean.setRefreshToken(json.getString("refresh_token"));
                    Calendar c = Calendar.getInstance();
                    c.setTime(date);
                    c.add(13, profileBean.getExpiry());
                    Date currentDatePlusOne = c.getTime();
                    profileBean.setExpiresOn(inputFormat.format(currentDatePlusOne));
                    break block5;
                }
                log.debug("Error while fetching accesstoken: {}", (Object)json.getString("error_description"));
                throw new MacroExecutionException(i18nResolver.getText(appkey + ".onedrive-access-expired"));
            }
            catch (ParseException exception) {
                log.error("Error parsing OneDrive Token Expiry date: {}", (Throwable)exception);
                throw new MacroExecutionException(i18nResolver.getText(appkey + ".error.server", new Serializable[]{exception.getMessage()}));
            }
            catch (IOException exception) {
                log.error("An error occured while getting Accesstoken {}", (Throwable)exception);
                throw new MacroExecutionException(i18nResolver.getText(appkey + ".error.server", new Serializable[]{exception.getMessage()}));
            }
            catch (Exception exception) {
                log.error("An error occured while getting Accesstoken {}", (Throwable)exception);
                throw new MacroExecutionException(i18nResolver.getText(appkey + ".error.server", new Serializable[]{exception.getMessage()}));
            }
        }
        return profileBean;
    }

    private static String getAccessToken(ProfileBean profileBean, String baseUrl) throws IOException {
        String result = "";
        String url = ONEDRIVE_ACCESSTOKEN_API;
        if (StringUtils.isNotEmpty(profileBean.getTenantId())) {
            url = StringUtils.replace(ONEDRIVE_ACCESSTOKEN_API, "common", profileBean.getTenantId());
        }
        HttpPost post = new HttpPost(url);
        StringBuilder json = new StringBuilder();
        json.append("client_id=" + profileBean.getOneDriveClientId() + "&grant_type=refresh_token&redirect_uri=" + profileBean.getOneDriveRedirectURI() + "&refresh_token=" + profileBean.getRefreshToken() + "&client_secret=" + profileBean.getOneDriveClientSecret());
        post.addHeader("content-type", "application/x-www-form-urlencoded; charset=UTF-8");
        post.setEntity((HttpEntity)new StringEntity(json.toString()));
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        return result;
    }

    public static String getOneDriveURL(String oneDrivePath, String accessToken, I18nResolver i18nResolver, String appkey) throws MacroExecutionException {
        String visioUrl = "";
        HttpURLConnection conn = null;
        try {
            String str;
            URL url = new URL(ONEDRIVE_GRAPH_API + oneDrivePath);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json;odata.metadata=none");
            conn.setRequestProperty("Authorization", accessToken);
            conn.setRequestProperty("DataType", "json");
            InputStream oneDriveInputStream = conn.getInputStream();
            InputStreamReader isReader = new InputStreamReader(oneDriveInputStream);
            BufferedReader reader = new BufferedReader(isReader);
            StringBuffer sb = new StringBuffer();
            while ((str = reader.readLine()) != null) {
                sb.append(str);
            }
            JSONObject json = new JSONObject(sb.toString());
            visioUrl = json.getString("@microsoft.graph.downloadUrl");
        }
        catch (MalformedURLException exception) {
            log.error("Graph API URL is malformed {}", (Throwable)exception);
            throw new MacroExecutionException(i18nResolver.getText(appkey + ".onedrive-location-not-found"));
        }
        catch (IOException exception) {
            log.error("An IO Exception occured while getting OneDrive Download URL {}", (Throwable)exception);
            throw new MacroExecutionException(i18nResolver.getText(appkey + ".onedrive-location-not-found"));
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return visioUrl;
    }
}

