/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.license.LicenseManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import org.swift.confluence.scriptutil.ScriptMacro;

public abstract class LicensedScriptMacro
extends ScriptMacro {
    protected final PluginLicenseManager licenseManager;

    public LicensedScriptMacro(SettingsManager settingsManager, BootstrapManager bootstrapManager, PageTemplateManager templateManager, SpaceManager spaceManager, PageManager pageManager, PermissionManager permissionManager, AttachmentManager attachmentManager, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, PluginLicenseManager licenseManager, XhtmlContent xhtmlContent) {
        super(settingsManager, bootstrapManager, templateManager, spaceManager, pageManager, permissionManager, attachmentManager, localeManager, i18NBeanFactory, xhtmlContent);
        this.licenseManager = licenseManager;
    }

    protected boolean exemptDeveloperLicense() {
        return false;
    }

    protected boolean exemptOnDemand() {
        return false;
    }

    protected void validateLicense(PluginLicenseManager licenseManager) throws MacroExecutionException {
        boolean licenseOk;
        String reason = "UNKNOWN_ERROR";
        boolean bl = licenseOk = licenseManager != null;
        if (licenseOk) {
            try {
                boolean bl2 = licenseOk = licenseManager.getLicense() != null && licenseManager.getLicense().isDefined();
                if (licenseOk) {
                    PluginLicense pluginLicense = (PluginLicense)licenseManager.getLicense().get();
                    licenseOk = pluginLicense.isValid();
                    if (!licenseOk) {
                        reason = this.getText(((LicenseError)pluginLicense.getError().get()).name());
                    }
                } else {
                    reason = this.getText(this.i18nKey + ".no-license");
                }
            }
            catch (Exception exception) {
                this.log.error(exception.getMessage());
                licenseOk = false;
            }
        }
        if (!licenseOk && this.exemptDeveloperLicense()) {
            String type = LicenseManager.getInstance().getLicense("CONF").getLicenseType().getNewLicenseTypeName();
            boolean bl3 = licenseOk = type.equalsIgnoreCase("DEVELOPER") || type.equalsIgnoreCase("DEMONSTRATION");
        }
        if (!licenseOk && this.exemptOnDemand()) {
            String onDemand = System.getProperty("atlassian.upm.on.demand");
            boolean bl4 = licenseOk = onDemand != null && onDemand.equals("true");
        }
        if (!licenseOk) {
            throw new MacroExecutionException(this.getText(this.i18nKey + ".invalid-license", reason));
        }
    }
}

