/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.IllegalBlockSizeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.crypto.EncryptDecrypt;
import org.swift.confluence.crypto.EncryptDecryptImpl;

public class EncryptDecryptHelper {
    private static final Logger log = LoggerFactory.getLogger(EncryptDecryptHelper.class);
    private static EncryptDecrypt encryptDecrypt = null;
    private static String pluginFolderPath = null;
    private static String filePrefix = null;

    public static void initialize(String pluginFolderPath, String filePrefix) throws Exception {
        if (encryptDecrypt == null) {
            EncryptDecryptHelper.pluginFolderPath = pluginFolderPath;
            EncryptDecryptHelper.filePrefix = filePrefix;
            encryptDecrypt = new EncryptDecryptImpl(pluginFolderPath, filePrefix);
        }
    }

    private static void reInitialize() throws Exception {
        encryptDecrypt = new EncryptDecryptImpl(pluginFolderPath, filePrefix);
    }

    public static String getPublicKeyBase64String() {
        return encryptDecrypt.getPublicKeyBase64String();
    }

    public static String decryptText(String data) throws Exception {
        return encryptDecrypt.decryptText(data);
    }

    public static String encryptText(String data) throws Exception {
        return encryptDecrypt.encryptText(data);
    }

    public static String decryptText(String encrypted, String defaultVal) {
        String decrypted = null;
        try {
            decrypted = EncryptDecryptHelper.isEncoded(encrypted) ? EncryptDecryptHelper.decryptText(encrypted) : encrypted;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            decrypted = defaultVal;
        }
        return decrypted;
    }

    public static String encryptText(String toBeEncrypt, String defaultVal) {
        String encrypted = null;
        try {
            encrypted = EncryptDecryptHelper.isEncoded(toBeEncrypt) ? toBeEncrypt : EncryptDecryptHelper.encryptText(toBeEncrypt);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            encrypted = defaultVal;
        }
        return encrypted;
    }

    public static boolean isEncoded(String input) {
        String pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(input);
        return m.find() && input.lastIndexOf("=") >= 0;
    }

    private static String retryDecryption(String encodedString, String profileName) {
        String decodedString = null;
        try {
            EncryptDecryptHelper.reInitialize();
            decodedString = EncryptDecryptHelper.decryptText(encodedString);
        }
        catch (Exception e1) {
            log.error("There is exception while retrying decryption {}, profile {} ", (Object)e1, (Object)profileName);
            decodedString = encodedString;
        }
        return decodedString;
    }

    public static String getDecryptedString(String encodedString, String profileName) {
        String decodedString = null;
        try {
            if (EncryptDecryptHelper.isEncoded(encodedString)) {
                decodedString = EncryptDecryptHelper.decryptText(encodedString);
            }
        }
        catch (IllegalBlockSizeException e) {
            log.info("IllegalBlockSizeException. Retrying decryption, as there was an exception {}", (Object)e.getMessage());
            decodedString = EncryptDecryptHelper.retryDecryption(encodedString, profileName);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.info("ArrayIndexOutOfBoundsException. Retrying decryption, as there was an exception {}", (Object)e.getMessage());
            decodedString = EncryptDecryptHelper.retryDecryption(encodedString, profileName);
        }
        catch (Exception e) {
            log.error("There is an exception while decrypting {}, profile {} ", (Object)e, (Object)profileName);
            decodedString = encodedString;
        }
        if (decodedString == null) {
            decodedString = encodedString;
        }
        return decodedString;
    }
}

