/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.macroutil;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.spring.container.ContainerManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ContentPropertyStorage {
    private static final String CONTENT_PROPERTY_MANAGER = "contentPropertyManager";
    private ContentPropertyManager contentPropertyManager;
    private ContentEntityObject content;

    public ContentPropertyStorage(ContentEntityObject content) {
        this.content = content;
        this.contentPropertyManager = (ContentPropertyManager)ContainerManager.getComponent((String)CONTENT_PROPERTY_MANAGER);
    }

    public Set<String> getStringSet(String name, Set<String> def) {
        String[] valueArray = this.getStringArray(name);
        if (valueArray == null || valueArray.length == 0) {
            return def;
        }
        HashSet<String> value = new HashSet<String>();
        value.addAll(Arrays.asList(valueArray));
        return value;
    }

    private String[] getStringArray(String name) {
        String fieldSizeName = name + ".length";
        Integer fieldSize = this.getBaseInteger(fieldSizeName);
        if (fieldSize != null && fieldSize >= 0) {
            String[] value = new String[fieldSize.intValue()];
            for (int i = 0; i < value.length; ++i) {
                value[i] = this.getBaseString(name + "." + i);
            }
            return value;
        }
        return null;
    }

    private Integer getBaseInteger(String fieldSizeName) {
        String value = this.contentPropertyManager.getTextProperty(this.content, fieldSizeName);
        if (value != null) {
            return new Integer(value);
        }
        return null;
    }

    private String getBaseString(String name) {
        String value = this.contentPropertyManager.getTextProperty(this.content, name);
        if (value != null) {
            return value;
        }
        return null;
    }

    public void setStringSet(String name, Set<String> values) {
        String[] valuesArray = null;
        if (values != null) {
            valuesArray = new String[values.size()];
            valuesArray = values.toArray(valuesArray);
        }
        this.setStringArray(name, valuesArray);
    }

    private void setStringArray(String name, String[] value) {
        String fieldLengthName = name + ".length";
        Integer oldLength = this.getBaseInteger(fieldLengthName);
        if (oldLength != null) {
            int oli = oldLength;
            for (int i = 0; i < oli; ++i) {
                this.setBaseString(name + "." + i, null);
            }
        }
        if (value == null) {
            this.setBaseInteger(fieldLengthName, null);
        } else {
            this.setBaseInteger(fieldLengthName, new Integer(value.length));
            for (int i = 0; i < value.length; ++i) {
                this.setBaseString(name + "." + i, value[i]);
            }
        }
    }

    private void setBaseInteger(String name, Integer value) {
        if (value != null) {
            this.contentPropertyManager.setTextProperty(this.content, name, value.toString());
        }
    }

    private void setBaseString(String name, String value) {
        if (value != null) {
            this.contentPropertyManager.setTextProperty(this.content, name, value);
        }
    }

    public ContentEntityObject getContent() {
        return this.content;
    }

    public void setContent(ContentEntityObject content) {
        this.content = content;
    }

    public void setContentPropertyManager(ContentPropertyManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }
}

