/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.crypto;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.swift.confluence.crypto.EncryptDecrypt;

public class EncryptDecryptImpl
implements EncryptDecrypt {
    private static final String ALGORITHM = "RSA";
    private static final int ENCRYPTION_KEY_LENGTH = 1024;
    private static final String PRIVATE_KEY_FILE_SUFFIX = "_private.key";
    private static final String PUBLIC_KEY_FILE_SUFFIX = "_public.key";
    private static final String UTF8_CHARSET = StandardCharsets.UTF_8.name();
    private Cipher cipherWithPublicKey = null;
    private Cipher cipherWithPrivateKey = null;
    private String publicKeyBase64String = null;

    public EncryptDecryptImpl(String pluginFolderPath, String filePrefix) throws Exception {
        this.generateAndStoreKeys(pluginFolderPath, filePrefix);
        this.initializeCipher(pluginFolderPath, filePrefix);
        if (this.publicKeyBase64String == null) {
            Path publicKeyFilePath = Paths.get(pluginFolderPath, filePrefix + PUBLIC_KEY_FILE_SUFFIX);
            byte[] keyBytes = Files.readAllBytes(publicKeyFilePath);
            this.publicKeyBase64String = new String(keyBytes, UTF8_CHARSET);
        }
    }

    @Override
    public String encryptText(String data) throws Exception {
        if (StringUtils.isNotBlank(data)) {
            return Base64.encodeBase64String(this.cipherWithPublicKey.doFinal(data.getBytes(UTF8_CHARSET)));
        }
        return data;
    }

    @Override
    public String decryptText(String data) throws Exception {
        if (StringUtils.isNotBlank(data)) {
            return new String(this.cipherWithPrivateKey.doFinal(Base64.decodeBase64(data)), UTF8_CHARSET);
        }
        return data;
    }

    @Override
    public String getPublicKeyBase64String() {
        return this.publicKeyBase64String;
    }

    private void generateAndStoreKeys(String pluginFolderPath, String filePrefix) throws Exception {
        Path privateKeyFilePath = Paths.get(pluginFolderPath, filePrefix + PRIVATE_KEY_FILE_SUFFIX);
        Path publicKeyFilePath = Paths.get(pluginFolderPath, filePrefix + PUBLIC_KEY_FILE_SUFFIX);
        if (Files.notExists(privateKeyFilePath, new LinkOption[0]) && Files.notExists(publicKeyFilePath, new LinkOption[0])) {
            KeyPair keyPair = this.generateKeyPair(1024);
            this.writeToFile(privateKeyFilePath.toFile(), Base64.encodeBase64(keyPair.getPrivate().getEncoded()));
            this.writeToFile(publicKeyFilePath.toFile(), Base64.encodeBase64(keyPair.getPublic().getEncoded()));
        }
    }

    private void initializeCipher(String pluginFolderPath, String filePrefix) throws Exception {
        if (this.cipherWithPublicKey == null) {
            this.cipherWithPublicKey = Cipher.getInstance(ALGORITHM);
            PublicKey publicKey = this.getPublicKey(pluginFolderPath, filePrefix);
            this.cipherWithPublicKey.init(1, publicKey);
        }
        if (this.cipherWithPrivateKey == null) {
            this.cipherWithPrivateKey = Cipher.getInstance(ALGORITHM);
            PrivateKey privateKey = this.getPrivateKey(pluginFolderPath, filePrefix);
            this.cipherWithPrivateKey.init(2, privateKey);
        }
    }

    private KeyPair generateKeyPair(int keylength) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM);
        keyGen.initialize(keylength);
        return keyGen.generateKeyPair();
    }

    private PrivateKey getPrivateKey(String pluginFolderPath, String filePrefix) throws Exception {
        Path privateKeyFilePath = Paths.get(pluginFolderPath, filePrefix + PRIVATE_KEY_FILE_SUFFIX);
        byte[] keyBytes = Files.readAllBytes(privateKeyFilePath);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(Base64.decodeBase64(keyBytes));
        KeyFactory kf = KeyFactory.getInstance(ALGORITHM);
        return kf.generatePrivate(spec);
    }

    private PublicKey getPublicKey(String pluginFolderPath, String filePrefix) throws Exception {
        Path publicKeyFilePath = Paths.get(pluginFolderPath, filePrefix + PUBLIC_KEY_FILE_SUFFIX);
        byte[] keyBytes = Files.readAllBytes(publicKeyFilePath);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(Base64.decodeBase64(keyBytes));
        KeyFactory kf = KeyFactory.getInstance(ALGORITHM);
        return kf.generatePublic(spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(File keyFile, byte[] key) throws IOException {
        FileOutputStream fos = null;
        try {
            keyFile.getParentFile().mkdirs();
            fos = new FileOutputStream(keyFile);
            fos.write(key);
            fos.flush();
            fos.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }
}

