/*
 * Decompiled with CFR 0.152.
 */
package com.appfire.confluence.rest.analytics;

import com.appfire.common.analytics.util.AnalyticEvent;
import com.appfire.common.analytics.util.AnalyticsHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.scriptutil.ScriptUtils;

public class Analytics {
    static final Logger log = LoggerFactory.getLogger(Analytics.class);
    private final AnalyticsHelper analyticsHelper;

    public Analytics(AnalyticsHelper analyticsHelper) {
        this.analyticsHelper = analyticsHelper;
    }

    public Analytics(@ComponentImport PluginLicenseManager licenseManager, HostLicenseInformation hostLicenseInformation) {
        this(new AnalyticsHelper(ScriptUtils.getHostInfo(hostLicenseInformation), ScriptUtils.getPluginInfo(licenseManager), Analytics.class.getClassLoader()));
    }

    public void postAnalyticsEvent(AnalyticEvent.Event collectionName, String type) {
        try {
            if (collectionName != null) {
                HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
                analyticsEventDataMap.put("type", type == null ? collectionName.getEvent() : type);
                this.analyticsHelper.postAnalyticsEvent(collectionName.getEvent(), analyticsEventDataMap);
            }
        }
        catch (Throwable e) {
            log.debug("Error while posting " + collectionName.getEvent() + " event analytics ", e);
        }
    }

    public void postInstallUninstallEvent(AnalyticEvent.Event eventType) {
        this.postAnalyticsEvent(eventType, null);
    }
}

