/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.opensymphony.webwork.ServletActionContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.swift.confluence.macroutil.ContentPropertyStorage;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.macroutil.RequestAttributeStorage;
import org.swift.confluence.scriptutil.ScriptMacro;
import org.swift.confluence.scriptutil.ScriptUtils;

public class TestMacro
extends ScriptMacro {
    protected final BandanaManager bandanaManager;
    protected final UserAccessor userAccessor;
    private final String DELIMITER_PREFIX = "[";
    private final String DELIMITER_POSTFIX = "], ";

    TestMacro(SettingsManager settingsManager, BootstrapManager bootstrapManager, PageTemplateManager templateManager, SpaceManager spaceManager, PageManager pageManager, PermissionManager permissionManager, AttachmentManager attachmentManager, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, XhtmlContent xhtmlContent, BandanaManager bandanaManager, UserAccessor userAccessor, ClusterManager clusterManager) {
        super(settingsManager, bootstrapManager, templateManager, spaceManager, pageManager, permissionManager, attachmentManager, localeManager, i18NBeanFactory, xhtmlContent);
        this.bandanaManager = bandanaManager;
        this.userAccessor = userAccessor;
    }

    @Override
    public String execute(Map<String, String> params, String body, ConversionContext context) throws MacroExecutionException {
        this.log.debug("testKey:" + params.get("testKey"));
        return super.execute(params, ScriptUtils.stripFirstParagraphTags(body), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(MacroInfo info) throws MacroExecutionException {
        StringBuilder data = new StringBuilder();
        try {
            int intMacroParam = info.getMacroParams().getInteger("intParam", 1);
            this.log.debug("<<<<<<<<<<<<<START [ {} ]>>>>>>>>>>>>>", (Object)intMacroParam);
            this.log.debug("intParam: {}", (Object)intMacroParam);
            data.append("[intParam: " + intMacroParam + "], ");
            String stringMacroParam = info.getMacroParams().getString("stringParam", null);
            this.log.debug("stringParam: {}", (Object)stringMacroParam);
            if (stringMacroParam == null) {
                this.log.debug("stringParam not given");
            }
            data.append("[stringMacroParam: " + stringMacroParam + "], ");
            Boolean booleanMacroParam = info.getMacroParams().getBoolean("booleanParam", false);
            this.log.debug("stringParam: {}", (Object)booleanMacroParam);
            if (booleanMacroParam == null) {
                this.log.debug("booleanParam not given");
            } else {
                this.log.debug("booleanParam:{}", (Object)booleanMacroParam);
            }
            data.append("[booleanMacroParam: " + booleanMacroParam + "], ");
            this.log.debug("Request seesion:{}", (Object)info.getSession().getId());
            this.log.debug("Request Attributes:{}", (Object)info.getRequest());
            this.log.debug("Request :" + ServletActionContext.getRequest());
            this.log.debug("Session id:" + ScriptUtils.getSession().getId());
            this.log.debug("request bool param:" + info.getRequestParams().getBoolean("boolParam", false));
            data.append("[booleanRequestParam: " + info.getRequestParams().getBoolean("boolParam", false) + "], ");
            this.log.debug("request intParam :" + info.getRequestParams().getInteger("intParam", 99));
            data.append("[intRequestParam: " + info.getRequestParams().getInteger("intParam", 99) + "], ");
            this.log.debug("request doubleParam :" + info.getRequestParams().getDouble("doubleParam", 98.05));
            data.append("[doubleRequestParam: " + info.getRequestParams().getDouble("doubleParam", 98.05) + "], ");
            this.log.debug("request stringParam :" + info.getRequestParams().getString("stringParam", "test"));
            data.append("[stringRequestParam: " + info.getRequestParams().getString("stringParam", "test") + "], ");
            String[] stringParamArray = info.getRequestParams().getStringArray("stringParam", new String[]{"a", "b", "c"});
            String arrayParams = "";
            for (String s : stringParamArray) {
                this.log.debug("request stringParams :" + (String)s);
                arrayParams = arrayParams + ", ";
            }
            data.append("[stringArrayRequestParam: " + arrayParams + "], ");
            ContentPropertyStorage cps = new ContentPropertyStorage(info.getContent());
            HashSet<String> testSet = new HashSet<String>();
            testSet.add("prop1");
            cps.setStringSet("TEST_MACRO_PROPERTY", testSet);
            Set<String> indexKeySet = cps.getStringSet("TEST_MACRO_PROPERTY", null);
            for (String key : indexKeySet) {
                this.log.debug("key: {}", (Object)key);
            }
            RequestAttributeStorage storage = info.getRequestAttributes();
            Integer id = null;
            if (storage != null) {
                id = storage.getInteger(this.getClass().getName(), 0) + 1;
                storage.setInteger(this.getClass().getName(), id);
            }
            this.log.debug("id:" + id);
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "Error";
            return string;
        }
        finally {
            this.log.debug("<<<<<<<<<<<<<<<<<<<<<END>>>>>>>>>>>>>>>>>>>>>>>>>");
        }
        return data.toString();
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

