/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.user.User;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.scriptutil.BlacklistDomains;
import org.swift.confluence.scriptutil.EncryptDecryptHelper;
import org.swift.confluence.scriptutil.ProfileHelper;
import org.swift.confluence.scriptutil.ScriptLibCommonBean;
import org.swift.confluence.scriptutil.ScriptUtils;

public abstract class ScriptMacro
implements Macro {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final SettingsManager settingsManager;
    protected final BootstrapManager bootstrapManager;
    protected final PageTemplateManager templateManager;
    protected final SpaceManager spaceManager;
    protected final PageManager pageManager;
    protected final PermissionManager permissionManager;
    protected final AttachmentManager attachmentManager;
    protected final LocaleManager localeManager;
    protected final I18NBeanFactory i18NBeanFactory;
    protected final XhtmlContent xhtmlContent;
    public static final String[] TEMPLATE_MACROS_ARRAY = new String[]{"noformat", "wiki-markup", "code", "code-pro"};
    public static final List<String> TEMPLATE_MACROS = Arrays.asList(TEMPLATE_MACROS_ARRAY);
    public final String i18nKey = this.getClass().getPackage().getName();

    public ScriptMacro(SettingsManager settingsManager, BootstrapManager bootstrapManager, PageTemplateManager templateManager, SpaceManager spaceManager, PageManager pageManager, PermissionManager permissionManager, AttachmentManager attachmentManager, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, XhtmlContent xhtmlContent) {
        this.settingsManager = settingsManager;
        this.bootstrapManager = bootstrapManager;
        this.templateManager = templateManager;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.attachmentManager = attachmentManager;
        this.localeManager = localeManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.xhtmlContent = xhtmlContent;
    }

    protected abstract String execute(MacroInfo var1) throws MacroExecutionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        MacroInfo info = this.createMacroInfo(params, body, conversionContext);
        try {
            String string = this.execute(info);
            return string;
        }
        finally {
            this.closeMacroInfo(info);
        }
    }

    protected MacroInfo createMacroInfo(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        return new MacroInfo(params, body, conversionContext);
    }

    protected void closeMacroInfo(MacroInfo info) {
        info.close();
    }

    protected String getMacroName() {
        return "";
    }

    public boolean hasBody() {
        return true;
    }

    public String getConfluenceHome() {
        return this.bootstrapManager.getConfluenceHome();
    }

    public String getBaseUrl() {
        return this.settingsManager.getGlobalSettings().getBaseUrl();
    }

    public String getBaseUrlWithoutContextPath() {
        String baseUrl = this.getBaseUrl();
        String contextPath = this.getContextPath();
        this.log.debug("context path: {}, baseUrl: {}", (Object)contextPath, (Object)baseUrl);
        if (contextPath.length() > 0 && (baseUrl.endsWith(contextPath) || baseUrl.endsWith(contextPath + "/"))) {
            this.log.debug("substring to: {}", (Object)baseUrl.substring(0, baseUrl.lastIndexOf(contextPath) - 1));
            return baseUrl.substring(0, baseUrl.lastIndexOf(contextPath));
        }
        return baseUrl;
    }

    protected String getSessionCookie(MacroInfo info, String url) {
        this.log.debug("url: {}, baseUrl: {}", (Object)url, (Object)this.getBaseUrl());
        String cookie = null;
        if (ScriptUtils.isUrlRelative(url) || url.startsWith(this.getBaseUrl())) {
            if (info.getSession() != null) {
                String cookieName = null;
                if (cookieName == null) {
                    cookieName = System.getProperty("org.apache.catalina.SESSION_COOKIE_NAME");
                }
                if (cookieName == null) {
                    cookieName = "JSESSIONID";
                }
                cookie = cookieName + "=" + info.getSession().getId();
            } else {
                this.log.debug("No session, so session cookie could not be provided");
            }
        }
        this.log.debug("cookie: {}", cookie);
        return cookie;
    }

    public String getContextPath() {
        return this.bootstrapManager.getWebAppContextPath();
    }

    protected String getExtension() {
        return "";
    }

    protected PageContext getPageContext() {
        return null;
    }

    protected User getRemoteUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    protected I18NBean getI18nBean() {
        return this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale(this.getRemoteUser()));
    }

    public String getText(String key, String replacement1) {
        return ScriptUtils.getText(this.getI18nBean(), key, replacement1);
    }

    public String getText(String key, String replacement1, String replacement2) {
        return ScriptUtils.getText(this.getI18nBean(), key, replacement1, replacement2);
    }

    public String getText(String key, String replacement1, String replacement2, String replacement3) {
        return ScriptUtils.getText(this.getI18nBean(), key, replacement1, replacement2, replacement3);
    }

    public String getText(String key, String[] list) {
        return this.getI18nBean().getText(key, (Object[])list);
    }

    public String getText(String key, List<String> list) {
        return this.getI18nBean().getText(key, list);
    }

    public String getText(String key) {
        return this.getI18nBean().getText(key);
    }

    public String getStringOrTranlation(String string, String defaultString) {
        if (string == null) {
            return "";
        }
        if (string.length() > 1 && string.startsWith("@")) {
            if (string.trim().equals("@default")) {
                return this.getStringOrTranlation(defaultString, null);
            }
            return this.getText(string.substring(1));
        }
        return string;
    }

    public String getStringOrTranlation(String string) {
        return this.getStringOrTranlation(string, null);
    }

    public File getScriptAsFile(String fileName) throws MacroExecutionException {
        if (fileName.replace('\\', '/').contains("../")) {
            throw new MacroExecutionException(this.getText(this.i18nKey + ".error.dot-dot-not-allowed", fileName));
        }
        File file = new File(this.getFilePath(false));
        if (!(file = new File(file, fileName)).exists()) {
            String extension = this.getExtension();
            if (extension == null || extension == "" || file.getPath().endsWith(extension)) {
                this.log.error(this.getText(this.i18nKey + ".error.neither-file-not-found", file.getPath()));
                throw new MacroExecutionException(this.getText(this.i18nKey + ".error.file-not-found-common", fileName));
            }
            String fullPath = file.getPath();
            if (!(file = new File(fullPath + extension)).exists()) {
                this.log.error(this.getText(this.i18nKey + ".error.neither-file-not-found", fullPath, file.getPath()));
                throw new MacroExecutionException(this.getText(this.i18nKey + ".error.file-not-found-common", fileName));
            }
        }
        return file;
    }

    public String getData(MacroInfo info, ProfileHelper profileHelper, String parameterName) throws MacroExecutionException {
        String parameterValue = info.getMacroParams().getString(parameterName, "").trim();
        String data = "";
        String encoding = this.getStringParameter(info, profileHelper, "encoding", "");
        try {
            if (parameterValue.length() > 0) {
                switch (ScriptUtils.getResourceType(parameterValue, false)) {
                    case 1: {
                        data = ScriptUtils.getFileAsString(this.getScriptAsFile(parameterValue.substring(1)), encoding);
                        break;
                    }
                    case 4: {
                        data = ScriptUtils.getStreamAsString(this.getAttachmentAsStream(parameterValue, info.getContent().toPageContext()), encoding);
                        break;
                    }
                    case 3: {
                        data = this.getTemplateAsString(info, parameterValue);
                        break;
                    }
                    default: {
                        throw new MacroExecutionException("Invalid " + parameterName + " parameter");
                    }
                }
            }
            return ScriptUtils.trim(data);
        }
        catch (MacroExecutionException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new MacroExecutionException("Unexpected program error: " + exception.toString());
        }
    }

    public String getDataAllowUrl(ScriptLibCommonBean scriptLibCommonBean) throws MacroExecutionException {
        MacroInfo info = scriptLibCommonBean.getMacroInfo();
        String parameterValue = info.getMacroParams().getString(scriptLibCommonBean.getParameterName(), "").trim();
        String data = "";
        String encoding = this.getStringParameter(info, scriptLibCommonBean.getProfileHelper(), "encoding", "");
        try {
            if (parameterValue.length() > 0) {
                switch (ScriptUtils.getResourceType(parameterValue, true)) {
                    case 1: {
                        data = ScriptUtils.getFileAsString(this.getScriptAsFile(parameterValue.substring(1)), encoding);
                        break;
                    }
                    case 4: {
                        data = ScriptUtils.getStreamAsString(this.getAttachmentAsStream(parameterValue, info.getContent().toPageContext()), encoding);
                        break;
                    }
                    case 3: {
                        data = this.getTemplateAsString(info, parameterValue);
                        break;
                    }
                    case 2: {
                        BandanaManager bandanaManager = scriptLibCommonBean.getBandanaManager();
                        if (BlacklistDomains.isURLBlacklisted(parameterValue.substring(1), ScriptUtils.getGlobalBlacklistDomains(bandanaManager, scriptLibCommonBean.getBlacklistConfigKey()), scriptLibCommonBean.getBlacklistDomainValues())) {
                            throw new MacroExecutionException("The data cannot be displayed because the URL is blacklisted. Contact your Confluence administrator to find out more.");
                        }
                        ScriptUtils.checkUrlWhitelisted(bandanaManager, scriptLibCommonBean.getConfigKey(), parameterValue.substring(1));
                        InputStream stream = this.getUrlStream(info, scriptLibCommonBean.getProfileHelper(), parameterValue.substring(1), scriptLibCommonBean.isWantJson(), null);
                        data = ScriptUtils.getStreamAsString(stream, encoding);
                        ScriptUtils.closeInputStream(stream);
                        break;
                    }
                    default: {
                        throw new MacroExecutionException("Invalid " + scriptLibCommonBean.getParameterName() + " parameter");
                    }
                }
            }
            return ScriptUtils.trim(data);
        }
        catch (MacroExecutionException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new MacroExecutionException("Unexpected program error: " + exception.toString());
        }
    }

    public String getDataAllowUrl(MacroInfo info, ProfileHelper profileHelper, String parameterName, boolean wantJson, BandanaManager bandanaManager, String configKey) throws MacroExecutionException {
        String parameterValue = info.getMacroParams().getString(parameterName, "").trim();
        String data = "";
        String encoding = this.getStringParameter(info, profileHelper, "encoding", "");
        try {
            if (parameterValue.length() > 0) {
                switch (ScriptUtils.getResourceType(parameterValue, true)) {
                    case 1: {
                        data = ScriptUtils.getFileAsString(this.getScriptAsFile(parameterValue.substring(1)), encoding);
                        break;
                    }
                    case 4: {
                        data = ScriptUtils.getStreamAsString(this.getAttachmentAsStream(parameterValue, info.getContent().toPageContext()), encoding);
                        break;
                    }
                    case 3: {
                        data = this.getTemplateAsString(info, parameterValue);
                        break;
                    }
                    case 2: {
                        ScriptUtils.checkUrlWhitelisted(bandanaManager, configKey, parameterValue.substring(1));
                        InputStream stream = this.getUrlStream(info, profileHelper, parameterValue.substring(1), wantJson, null);
                        data = ScriptUtils.getStreamAsString(stream, encoding);
                        ScriptUtils.closeInputStream(stream);
                        break;
                    }
                    default: {
                        throw new MacroExecutionException("Invalid " + parameterName + " parameter");
                    }
                }
            }
            return ScriptUtils.trim(data);
        }
        catch (MacroExecutionException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new MacroExecutionException("Unexpected program error: " + exception.toString());
        }
    }

    @Deprecated
    public static boolean checkUrlIsAllowed(String name, boolean throwError) throws MacroExecutionException {
        if (name.matches("(?:http|https|ftp|ftps|sftp)://.*")) {
            return true;
        }
        if (throwError) {
            throw new MacroExecutionException("URL is invalid or not allowed.");
        }
        return false;
    }

    public InputStream getUrlStream(MacroInfo info, ProfileHelper profileHelper, String name, boolean wantJson, String cookie) throws MacroExecutionException {
        return this.getUrlStreamWithParams(info, profileHelper, name, wantJson, cookie, null, null, null);
    }

    public InputStream getUrlStreamWithParams(MacroInfo info, ProfileHelper profileHelper, String name, boolean wantJson, String cookie, String headerParams, String urlParams, String pwd) throws MacroExecutionException {
        URLConnection connection = null;
        HttpURLConnection httpConnection = null;
        if (ScriptUtils.isUrlRelative(name)) {
            name = this.getBaseUrl() + (name.startsWith("/") ? "" : "/") + name;
        }
        StringBuffer urlString = new StringBuffer(name);
        if (urlParams != null && StringUtils.isNotBlank((String)urlParams)) {
            String[] urlParamsArr = urlParams.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            if (!name.contains("?")) {
                urlString.append("?");
            } else if (urlString.indexOf("?") != urlString.length() - 1) {
                urlString.append("&");
            }
            for (int i = 0; i < urlParamsArr.length; ++i) {
                urlString.append(urlParamsArr[i]);
                if (i == urlParamsArr.length - 1) continue;
                urlString.append("&");
            }
        }
        try {
            connection = new URL(urlString.toString()).openConnection();
            Integer timeout = this.getIntegerParameter(info, profileHelper, "timeout", -1);
            if (timeout > 0) {
                connection.setConnectTimeout(timeout);
                connection.setReadTimeout(timeout);
            }
            String user = this.getStringParameter(info, profileHelper, "user", null);
            this.log.debug("user:{}", (Object)user);
            if (StringUtils.isNotBlank((String)user)) {
                String password;
                String string = password = StringUtils.isNotBlank((String)pwd) ? pwd : this.getStringParameter(info, profileHelper, "password", null);
                if (StringUtils.isBlank((String)password)) {
                    throw new MacroExecutionException(this.getText(this.i18nKey + ".error.password-required"));
                }
                password = EncryptDecryptHelper.decryptText(password, password);
                this.log.debug("Using basic authentication.");
                String basic = user + ":" + password;
                String encoding = new String(Base64.encodeBase64(basic.getBytes()));
                connection.setRequestProperty("Authorization", "Basic " + encoding);
            }
            if (wantJson) {
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Accept", "text/json, text/x-json, application/json, application/vnd.atl.plugins+json, application/vnd.atl.plugins.plugin+json, application/vnd.atl.plugins.installed+json, application/json;odata=verbose");
            }
            if (headerParams != null && StringUtils.isNotBlank((String)headerParams)) {
                String[] headerParamsArr;
                for (String headerParam : headerParamsArr = headerParams.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
                    connection.setRequestProperty(headerParam.split(":")[0].trim(), headerParam.split(":")[1].trim());
                }
            }
            if (cookie != null) {
                this.log.debug("Connection using cookie: {}", (Object)cookie);
                connection.setRequestProperty("Cookie", cookie);
            }
            ScriptUtils.log(connection.getRequestProperties(), "request properties");
            InputStream stream = connection.getInputStream();
            return stream;
        }
        catch (MalformedURLException e) {
            this.log.debug("Malformed: {}", (Object)e.getMessage());
            throw new MacroExecutionException(this.getText(this.i18nKey + ".error.http.invalid") + ".");
        }
        catch (FileNotFoundException e) {
            this.log.debug("Not found: {}", (Object)e.getMessage());
            throw new MacroExecutionException(this.getText(this.i18nKey + ".error.http.not-found") + ".");
        }
        catch (MacroExecutionException e) {
            this.log.debug("MacroExecutionException: {}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            int responseCode = -1;
            this.log.debug("Unexpected exception: " + e.getMessage());
            if (connection instanceof HttpURLConnection) {
                try {
                    httpConnection = (HttpURLConnection)connection;
                    responseCode = httpConnection.getResponseCode();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Error retrieving server data: {}. Details: {}", (Object)responseCode, (Object)e.toString());
                        String errors = ScriptUtils.getStreamAsString(httpConnection.getErrorStream(), null);
                        this.log.debug("Server reported errors: {}", (Object)errors);
                    }
                }
                catch (IOException e1) {
                    this.log.debug("Attempts to log more information on the failure were not successful. " + e1.getMessage());
                }
            }
            if (responseCode == -1) {
                throw new MacroExecutionException("Error loading data from " + urlString);
            }
            throw new MacroExecutionException(this.getErrorMessage(responseCode));
        }
    }

    public InputStream getUrlStream(MacroInfo info, ProfileHelper profileHelper, String name) throws MacroExecutionException {
        return this.getUrlStream(info, profileHelper, name, false, null);
    }

    protected String getErrorMessage(int responseCode) {
        String message = this.getText(this.i18nKey + ".error.http.general", Integer.toString(responseCode)) + ". ";
        switch (responseCode) {
            case 400: {
                message = message + this.getText(this.i18nKey + ".error.http.400") + ".";
                break;
            }
            case 401: {
                message = message + this.getText(this.i18nKey + ".error.http.401") + ".";
                break;
            }
            case 403: {
                message = message + this.getText(this.i18nKey + ".error.http.403") + ".";
                break;
            }
            case 404: {
                message = message + this.getText(this.i18nKey + ".error.http.404") + ".";
                break;
            }
            case 405: {
                message = message + this.getText(this.i18nKey + ".error.http.405") + ".";
                break;
            }
            case 406: {
                message = message + this.getText(this.i18nKey + ".error.http.406") + ".";
                break;
            }
            case 409: {
                message = message + this.getText(this.i18nKey + ".error.http.409") + ".";
                break;
            }
            case 415: {
                message = message + this.getText(this.i18nKey + ".error.http.415") + ".";
                break;
            }
        }
        return message;
    }

    public String getTemplateAsString(MacroInfo info, String name) throws MacroExecutionException {
        int spaceAt = name.indexOf(58);
        PageTemplate template = null;
        if (spaceAt == -1) {
            List templates = this.templateManager.getGlobalPageTemplates();
            for (PageTemplate temp : templates) {
                if (!name.trim().equals(temp.getName().trim())) continue;
                template = temp;
            }
            if (template == null) {
                throw new MacroExecutionException(this.getText(this.i18nKey + ".error.global-template-not-found", name));
            }
        } else {
            Space space;
            String spaceKey = name.substring(0, spaceAt);
            String pageName = name.substring(spaceAt + 1);
            template = this.templateManager.getPageTemplate(pageName, space = this.getSpace(spaceKey));
            if (template == null) {
                throw new MacroExecutionException(this.getText(this.i18nKey + ".error.space-template-not-found", pageName, spaceKey));
            }
        }
        final StringBuilder builder = new StringBuilder();
        try {
            this.xhtmlContent.handleMacroDefinitions(template.getContent(), info.getConversionContext(), new MacroDefinitionHandler(){

                public void handle(MacroDefinition macroDefinition) {
                    String name = macroDefinition.getName();
                    if (TEMPLATE_MACROS.contains(name)) {
                        builder.append(macroDefinition.getBodyText());
                        builder.append('\n');
                    }
                }
            });
        }
        catch (XhtmlException e) {
            this.log.debug("exception: {}", (Object)e.toString());
            throw new MacroExecutionException("Xhtml error getting template.");
        }
        return builder.toString();
    }

    protected InputStream getAttachmentAsStream(String name, ContentEntityObject entity, String spaceKey) throws MacroExecutionException, IOException {
        Attachment attachment = null;
        try {
            attachment = this.attachmentManager.getAttachment(entity, name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (attachment == null) {
            String[] replacements = new String[]{name, entity.getDisplayTitle(), spaceKey};
            throw new MacroExecutionException(this.getText(this.i18nKey + ".error.attachment-not-found", replacements));
        }
        this.log.debug("attachment id:", (Object)attachment.getContentId());
        InputStream stream = this.attachmentManager.getAttachmentData(attachment);
        if (stream != null) {
            return stream;
        }
        String[] replacements = new String[]{name, entity.getDisplayTitle(), spaceKey};
        throw new MacroExecutionException(this.getText(this.i18nKey + ".error.attachment-not-found", replacements));
    }

    public InputStream getAttachmentAsStream(String name, PageContext pageContext) throws MacroExecutionException {
        int attachAt;
        int spaceAt = name.indexOf(58);
        if (spaceAt > (attachAt = name.indexOf(94))) {
            throw new MacroExecutionException(this.getText(this.i18nKey + ".error.invalid-attachment", name));
        }
        String spaceKey = spaceAt == -1 ? pageContext.getSpaceKey() : name.substring(0, spaceAt);
        String pageName = attachAt == 0 ? pageContext.getPageTitle() : name.substring(spaceAt + 1, attachAt);
        try {
            if (attachAt == 0) {
                InputStream stream = this.getAttachmentAsStream(name.substring(1), pageContext.getEntity(), spaceKey);
                if (stream != null) {
                    return stream;
                }
                throw new MacroExecutionException(this.getText(this.i18nKey + ".error.reading-attachment", name.substring(attachAt + 1), pageName, spaceKey));
            }
            Page page = this.getPageWithSpecialValueHandling(pageName, pageContext, spaceKey);
            pageName = page.getDisplayTitle();
            if (!this.isViewPermitted(page)) {
                throw new MacroExecutionException(this.getText(this.i18nKey + ".error.not-authorized-to-view", pageName, spaceKey));
            }
            InputStream stream = this.getAttachmentAsStream(name.substring(attachAt + 1), (ContentEntityObject)page, spaceKey);
            if (stream != null) {
                return stream;
            }
            throw new MacroExecutionException(this.getText(this.i18nKey + ".error.reading-attachment", name.substring(attachAt + 1), pageName, spaceKey));
        }
        catch (IOException exception) {
            throw new MacroExecutionException(this.getText(this.i18nKey + ".error.reading-attachment", name.substring(attachAt + 1), pageName, spaceKey));
        }
    }

    public Attachment getAttachment(String name, PageContext pageContext) throws MacroExecutionException {
        Attachment attachment;
        String pageName;
        int spaceAt = name.indexOf(58);
        int attachAt = name.indexOf(94);
        if (attachAt == -1) {
            throw new MacroExecutionException(this.getText(this.i18nKey + ".error.not-attachment-expression", name));
        }
        if (spaceAt > attachAt) {
            throw new MacroExecutionException(this.getText(this.i18nKey + ".error.invalid-attachment", name));
        }
        String spaceKey = spaceAt == -1 ? pageContext.getSpaceKey() : name.substring(0, spaceAt);
        String string = pageName = attachAt == 0 ? pageContext.getPageTitle() : name.substring(spaceAt + 1, attachAt);
        if (attachAt == 0) {
            attachment = this.attachmentManager.getAttachment(pageContext.getEntity(), name.substring(1));
        } else {
            Page page = this.getPageWithSpecialValueHandling(pageName, pageContext, spaceKey);
            pageName = page.getDisplayTitle();
            if (!this.isViewPermitted(page)) {
                throw new MacroExecutionException(this.getText(this.i18nKey + ".error.not-authorized-to-view", pageName, spaceKey));
            }
            attachment = this.attachmentManager.getAttachment((ContentEntityObject)page, name.substring(attachAt + 1));
        }
        if (attachment == null) {
            throw new MacroExecutionException(this.getText(this.i18nKey + ".error.attachment-not-found", name.substring(attachAt + 1), pageName, spaceKey));
        }
        return attachment;
    }

    protected String getAttachmentUrl(Attachment attachment) {
        return this.getBaseUrl() + attachment.getDownloadPathWithoutVersion();
    }

    public Page getPage(String name, PageContext pageContext) throws MacroExecutionException {
        Page page = null;
        int spaceAt = name.indexOf(58);
        int attachAt = name.indexOf(94);
        if (attachAt > 0 && spaceAt > attachAt) {
            throw new MacroExecutionException(this.getText(this.i18nKey + ".error.invalid-page", name));
        }
        String spaceKey = spaceAt == -1 ? pageContext.getSpaceKey() : name.substring(0, spaceAt);
        String pageName = attachAt == -1 ? name.substring(spaceAt + 1) : name.substring(spaceAt + 1, attachAt);
        page = this.getPageWithSpecialValueHandling(pageName, pageContext, spaceKey);
        return page;
    }

    public Page getPageWithSpecialValueHandling(String name, PageContext pageContext, String spaceKey) throws MacroExecutionException {
        return this.getPageWithSpecialValueHandling(name, pageContext, spaceKey, false);
    }

    public Page getPageWithSpecialValueHandling(String name, PageContext pageContext, String spaceKey, boolean forgivePageNotFound) throws MacroExecutionException {
        Page page = null;
        if (spaceKey == null && pageContext != null) {
            spaceKey = pageContext.getSpaceKey();
        }
        if (spaceKey != null && "@home".equalsIgnoreCase(name)) {
            page = this.getSpace(spaceKey).getHomePage();
        }
        if (pageContext != null) {
            if ("@self".equalsIgnoreCase(name)) {
                page = this.pageManager.getPage(spaceKey, pageContext.getPageTitle());
            } else if ("@parent".equalsIgnoreCase(name) && this.pageManager.getPage(spaceKey, pageContext.getPageTitle()) != null) {
                page = this.pageManager.getPage(spaceKey, pageContext.getPageTitle()).getParent();
            }
        }
        if (page == null && (page = this.pageManager.getPage(spaceKey, name)) == null && spaceKey != null) {
            this.getSpace(spaceKey);
            if (!forgivePageNotFound) {
                throw new MacroExecutionException(this.getText(this.i18nKey + ".error.page-not-found", name, spaceKey));
            }
        }
        return page;
    }

    protected Space getSpace(String spaceKey) throws MacroExecutionException {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            throw new MacroExecutionException(this.getText(this.i18nKey + ".error.space-not-found", spaceKey));
        }
        return space;
    }

    protected boolean isViewPermitted(Page page) {
        return this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)page);
    }

    protected String getFilePath(boolean endSeparator) {
        return this.getConfluenceHome() + System.getProperty("file.separator") + "script" + (endSeparator ? System.getProperty("file.separator") : "");
    }

    protected boolean doesFileExist(String name) {
        boolean exists = false;
        if (name != null) {
            int attachAt = name.indexOf(94);
            if (attachAt >= 0) {
                Attachment attachment = null;
                int spaceAt = name.indexOf(58);
                if (spaceAt < attachAt) {
                    String pageName;
                    String spaceKey = spaceAt == -1 ? this.getPageContext().getSpaceKey() : name.substring(0, spaceAt);
                    String string = pageName = attachAt == 0 ? this.getPageContext().getPageTitle() : name.substring(spaceAt + 1, attachAt);
                    if (attachAt == 0) {
                        attachment = this.attachmentManager.getAttachment(this.getPageContext().getEntity(), name);
                    } else {
                        Page page = this.pageManager.getPage(spaceKey, pageName);
                        if (page != null) {
                            attachment = this.attachmentManager.getAttachment((ContentEntityObject)page, name);
                        }
                    }
                }
                exists = attachment != null;
            } else {
                File file = new File(this.getFilePath(false));
                file = new File(file, name);
                exists = file.exists();
            }
        }
        return exists;
    }

    protected String render(MacroInfo info, String content) throws MacroExecutionException {
        return ScriptUtils.render(this.xhtmlContent, info, content);
    }

    protected boolean isLegacy(MacroInfo info) {
        return ScriptUtils.getBoolean("legacy", false, info);
    }

    protected String getStringParameter(MacroInfo info, ProfileHelper profileHelper, String parameter, String defaultValue) throws MacroExecutionException {
        return profileHelper != null ? profileHelper.getStringParameter(parameter, defaultValue) : info.getMacroParams().getString(parameter, defaultValue);
    }

    public Integer getIntegerParameter(MacroInfo info, ProfileHelper profileHelper, String parameter, Integer defaultValue) throws MacroExecutionException {
        return profileHelper != null ? profileHelper.getIntegerParameter(parameter, defaultValue) : info.getMacroParams().getInteger(parameter, defaultValue);
    }
}

