/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.macroutil;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.scriptutil.exception.InvalidParameterException;

public class RequestAttributeStorage {
    protected static final Logger log = LoggerFactory.getLogger((String)"org.swift.confluence.scriptutil.ScriptUtils");
    private final HttpServletRequest request;

    public RequestAttributeStorage(HttpServletRequest request) {
        this.request = request;
    }

    public Boolean getBoolean(String name, boolean def) {
        try {
            if (this.request.getAttribute(name) != null) {
                return (Boolean)this.request.getAttribute(name);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new InvalidParameterException(name, e);
        }
        return def;
    }

    public Double getDouble(String name, double def) {
        try {
            if (this.request.getAttribute(name) != null) {
                return (Double)this.request.getAttribute(name);
            }
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage());
            throw new InvalidParameterException("Value for '" + name + "' is not a valid double: " + this.request.getAttribute(name), e);
        }
        return def;
    }

    public Integer getInteger(String name, Integer def) {
        try {
            if (this.request.getAttribute(name) != null) {
                return (Integer)this.request.getAttribute(name);
            }
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage());
            throw new InvalidParameterException("Value for '" + name + "' is not a valid integer: " + this.request.getAttribute(name), e);
        }
        return def;
    }

    public Enumeration<String> getRequestAttributes() {
        return this.request.getAttributeNames();
    }

    public String getString(String name, String def) {
        try {
            if (this.request.getAttribute(name) != null) {
                return String.valueOf(this.request.getAttribute(name));
            }
        }
        catch (Exception e) {
            throw new InvalidParameterException(name, e);
        }
        return def;
    }

    public String[] getStringArray(String name, String[] def) {
        if (this.request.getAttribute(name) != null) {
            return this.request.getParameterValues(name);
        }
        return def;
    }

    public void setInteger(String name, Integer value) {
        this.request.setAttribute(name, (Object)value);
    }

    public void setString(String name, String value) {
        this.request.setAttribute(name, (Object)value);
    }

    public void setBoolean(String name, Boolean value) {
        this.request.setAttribute(name, (Object)value);
    }

    public Object getObject(String name, Object def) {
        if (this.request.getAttribute(name) != null) {
            return this.request.getAttribute(name);
        }
        return def;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setObject(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public Set<String> baseNameSet() {
        Enumeration e = this.request.getAttributeNames();
        HashSet<String> names = new HashSet<String>();
        while (e.hasMoreElements()) {
            names.add((String)e.nextElement());
        }
        return names;
    }
}

