/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.atlassian.webresource.api.assembler.WebResource;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.cache.WrappedRenderer;
import org.swift.confluence.cache.util.CacheUtils;
import org.swift.confluence.scriptutil.ScriptUtils;

public final class FutureRenderer
extends HttpServlet {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final String i18nKey = ((Object)((Object)this)).getClass().getPackage().getName();
    private static final long serialVersionUID = 1L;
    protected final XhtmlContent xhtmlContent;
    protected final SubRenderer subRenderer;
    protected final PermissionManager permissionManager;
    protected final PageManager pageManager;
    protected final LocaleManager localeManager;
    protected final I18NBeanFactory i18NBeanFactory;
    protected final ContentEntityManager contentEntityManager;
    protected final TransactionTemplate transactionTemplate;

    public FutureRenderer(XhtmlContent xhtmlContent, SubRenderer subRenderer, PermissionManager permissionManager, PageManager pageManager, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, TransactionTemplate transactionTemplate) {
        this.xhtmlContent = xhtmlContent;
        this.subRenderer = subRenderer;
        this.permissionManager = permissionManager;
        this.pageManager = pageManager;
        this.localeManager = localeManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.transactionTemplate = transactionTemplate;
        this.contentEntityManager = (ContentEntityManager)ContainerManager.getComponent((String)"contentEntityManager");
    }

    protected String convertContentToHtml(long id, String content, String requestParameters, String avoidUserCheck, boolean enableRetry, boolean isLegacy) throws MacroExecutionException, XMLStreamException, XhtmlException {
        ContentEntityObject ceo = this.contentEntityManager.getById(id);
        if (ceo != null) {
            if (this.isViewPermitted(ceo)) {
                DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)ceo.toPageContext());
                WrappedRenderer renderer = new WrappedRenderer((ConversionContext)conversionContext, this.xhtmlContent, this.subRenderer, this.transactionTemplate);
                String rendered = renderer.render(ceo, content, requestParameters, avoidUserCheck, isLegacy);
                if (enableRetry && conversionContext.getProperty("org.swift.confluence.cache.retry_possible") != null) {
                    this.log.debug("Rendering indicated retry possible. Macro: {}, rendered: {}", conversionContext.getProperty("org.swift.confluence.cache.retry_possible"), (Object)rendered);
                    rendered = "org.swift.confluence.cache.retry_possible";
                }
                return rendered;
            }
            throw new MacroExecutionException(ScriptUtils.getText((I18NBean)this.getI18nBean(), (String)(this.i18nKey + ".error.not-authorized-to-view2"), (String)ceo.getDisplayTitle()));
        }
        throw new MacroExecutionException("Future macro only available in a page context.");
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String result;
        String pageIdString = httpServletRequest.getParameter("pageId");
        String requestParameters = httpServletRequest.getParameter("requestParameters");
        requestParameters = requestParameters == null ? "" : HtmlUtil.urlDecode((String)requestParameters);
        String content = httpServletRequest.getParameter("content");
        if (requestParameters != null && !requestParameters.isEmpty() && requestParameters.indexOf("outputType=PREVIEW") > 0) {
            content = ScriptUtils.htmlDecode((String)content);
        }
        String contentType = httpServletRequest.getParameter("contentType");
        String avoidUserCheck = httpServletRequest.getParameter("avoidUserCheck");
        Integer retryInterval = ScriptUtils.getIntegerOrNull((String)httpServletRequest.getParameter("retryInterval"));
        if (this.log.isDebugEnabled()) {
            this.log.debug("content: {}, contentType: {}", (Object)content, (Object)contentType);
            this.log.debug("avoid user check: {}", (Object)avoidUserCheck);
            this.log.debug("request parameters: {}", (Object)requestParameters);
            this.log.debug("retry interval: {}", (Object)retryInterval);
            this.log.debug("id string: {}", (Object)pageIdString);
        }
        try {
            long pageId = Long.parseLong(pageIdString);
            this.log.debug("id string: {}, id: {}", (Object)pageIdString, (Object)pageId);
            result = this.convertContentToHtml(pageId, content, requestParameters, avoidUserCheck, retryInterval > 0, "wiki".equals(contentType));
        }
        catch (Exception exception) {
            this.log.debug("Exception getting id from post request: {}", (Object)exception.toString());
            result = HtmlUtil.htmlEncode((String)("Error getting page id from request for future macro: " + exception.toString()));
        }
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        WebResourceSet webResourceSet = CacheUtils.getPageBuilderService() != null ? CacheUtils.getPageBuilderService().assembler().assembled().drainIncludedResources() : null;
        Predicate<WebResource> predicateWebResources = new Predicate<WebResource>(){

            public boolean apply(WebResource ws) {
                if (!(ws.toString().isEmpty() || ws.toString().contains("superbatch") || ws.toString().contains("_super:_super") || ws.toString().contains("com.atlassian.auiplugin") || ws.toString().contains("-com.atlassian.plugins.atlassian-plugins-webresource-rest:data-collector-perf-observer"))) {
                    FutureRenderer.this.log.debug("Resource '" + ws.toString() + "' shall be loaded.");
                    return true;
                }
                return false;
            }

            @Override
            public boolean test(WebResource ws) {
                return this.apply(ws);
            }
        };
        if (CacheUtils.isConfluenceVersion9()) {
            CacheUtils.processWebResourceSetGuava(webResourceSet, printWriter, predicateWebResources);
        } else {
            CacheUtils.processWebResourceSetReflection(webResourceSet, printWriter, predicateWebResources);
        }
        printWriter.print(result.length() > 0 ? result : " ");
        printWriter.flush();
    }

    protected String replaceAmpersands(String content) {
        StringBuffer builder = new StringBuffer();
        Pattern pattern = Pattern.compile("(&(?!amp;))");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String replacement = "&amp;";
            matcher.appendReplacement(builder, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(builder);
        content = builder.toString();
        return content;
    }

    protected boolean isViewPermitted(ContentEntityObject ceo) {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.VIEW, (Object)ceo);
    }

    protected I18NBean getI18nBean() {
        return this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale(this.getRemoteUser()));
    }

    protected User getRemoteUser() {
        return AuthenticatedUserThreadLocal.get();
    }
}

