/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.swift.confluence.cache.CacheMacroSupport;
import org.swift.confluence.cache.Constants;
import org.swift.confluence.cache.util.CacheUtils;
import org.swift.confluence.macrosecurity.utils.MacroSecurityUtils;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.macroutil.RequestParameterStorage;
import org.swift.confluence.scriptutil.ScriptUtils;

public final class FutureMacro
extends CacheMacroSupport {
    protected static final String FUTURE_TEMPLATE = "html/future.vm";
    protected static final String CONTENT_TYPE_WIKI = "wiki";
    protected static final String CONTENT_TYPE_XHTML = "xhtml";
    protected final BandanaManager bandanaManager;
    protected final UserAccessor userAccessor;
    protected static final ConfluenceBandanaContext bandanaContext = new ConfluenceBandanaContext();

    public FutureMacro(SettingsManager settingsManager, BootstrapManager bootstrapManager, PageTemplateManager templateManager, SpaceManager spaceManager, PageManager pageManager, PermissionManager permissionManager, AttachmentManager attachmentManager, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, PluginLicenseManager licenseManager, XhtmlContent xhtmlContent, BandanaManager bandanaManager, UserAccessor userAccessor, SubRenderer subRenderer, ConfluenceIndexer confluenceIndexer) {
        super(settingsManager, bootstrapManager, templateManager, spaceManager, pageManager, permissionManager, attachmentManager, localeManager, i18NBeanFactory, licenseManager, xhtmlContent, subRenderer, confluenceIndexer);
        this.bandanaManager = bandanaManager;
        this.userAccessor = userAccessor;
    }

    protected String getMacroName() {
        return "future";
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    @RequiresFormat(value=Format.Storage)
    public String execute(Map<String, String> params, String body, ConversionContext context) throws MacroExecutionException {
        return super.execute(params, ScriptUtils.stripFirstParagraphTags((String)body), context);
    }

    public String execute(MacroInfo info) throws MacroExecutionException {
        this.validateLicense(this.licenseManager);
        MacroSecurityUtils.securityCheck((BandanaManager)this.bandanaManager, (UserAccessor)this.userAccessor, (String)this.getMacroName(), (MacroInfo)info);
        Boolean manual = ScriptUtils.getBoolean((String)"manual", (boolean)false, (MacroInfo)info);
        int delay = info.getMacroParams().getInteger("delay", Integer.valueOf(0));
        String result = "";
        Object cacheRequestParameters = ScriptUtils.getCachePsuedoRequestParameters((MacroInfo)info);
        boolean inlineFuture = false;
        boolean inlineFutureManual = false;
        RequestParameterStorage requestParameters = info.getRequestParams();
        if (requestParameters != null) {
            inlineFuture = requestParameters.getBoolean("inlineFuture", false);
            inlineFutureManual = requestParameters.getBoolean("inlineFutureManual", false);
            this.log.debug("inline future: {}, inline future manual: {}", (Object)inlineFuture, (Object)inlineFutureManual);
        }
        if (cacheRequestParameters != null) {
            Map<String, List<String>> parameters = CacheUtils.getRequestParameterAsMap((String)cacheRequestParameters);
            inlineFuture = inlineFuture || this.getRequest(parameters, "inlineFuture");
            inlineFutureManual = inlineFutureManual || this.getRequest(parameters, "inlineFutureManual");
        } else {
            cacheRequestParameters = "";
        }
        this.log.debug("requestParameters:{}, cacheRequestParameters:{}", (Object)requestParameters, cacheRequestParameters);
        cacheRequestParameters = (String)cacheRequestParameters + "&inlineFuture=true";
        cacheRequestParameters = (String)cacheRequestParameters + "&inlineFutureManual=true";
        this.log.debug("cache request parameters after update: {}", cacheRequestParameters);
        info.getConversionContext().setProperty("org.swift.confluence.cache.request_parameters", cacheRequestParameters);
        this.log.debug("manual && not inline: {}, not manual and not inline: {}", (Object)(manual != false && !inlineFutureManual ? 1 : 0), (Object)(manual == false || !inlineFuture ? 1 : 0));
        if ((manual.booleanValue() && !inlineFutureManual || !manual.booleanValue() && !inlineFuture) && this.isInteractive(info) && this.hasPageContext(info)) {
            String title = info.getMacroParams().getString("0", null);
            title = info.getMacroParams().getString("title", title);
            int timeout = this.getTimeoutParameter(info);
            Map context = MacroUtils.defaultVelocityContext();
            context.put("manual", manual);
            context.put("useLoadText", this.useLoadText(title));
            if (!StringUtils.isBlank((CharSequence)title)) {
                context.put("futureTitle", title);
            }
            String futureId = this.getNextFutureId(info);
            context.put("futureId", futureId);
            String body = info.getConversionContext().getOutputType().equalsIgnoreCase(ConversionContextOutputType.PREVIEW.value()) ? info.getMacroBody() : HtmlUtil.htmlEncode((String)info.getMacroBody());
            context.put("macroBody", body);
            context.put("contentId", info.getContent().getId());
            context.put("contentType", this.isLegacy(info) ? CONTENT_TYPE_WIKI : CONTENT_TYPE_XHTML);
            context.put("avoidUserCheck", info.getRequest() != null && this.avoidUserCheck(info.getRequest().getRequestURI()) ? "true" : "false");
            context.put("timeout", timeout);
            context.put("retryInterval", this.getRetryIntervalParameter(info));
            context.put("delay", delay);
            String reqParams = this.getRequestParameters(info);
            reqParams = HtmlUtil.urlEncode((String)(reqParams + (String)cacheRequestParameters));
            context.put("requestParameters", reqParams);
            result = VelocityUtils.getRenderedTemplate((String)FUTURE_TEMPLATE, (Map)context);
        } else {
            result = this.render(info, info.getMacroBody(), this.isLegacy(info));
        }
        cacheRequestParameters = ScriptUtils.getCachePsuedoRequestParameters((MacroInfo)info).replaceFirst("&inlineFuture=true", "");
        this.log.debug("cache request parameters after pop: {}", cacheRequestParameters);
        cacheRequestParameters = ((String)cacheRequestParameters).replaceFirst("&inlineFutureManual=true", "");
        this.log.debug("cache request parameters after pop2: {}", cacheRequestParameters);
        info.getConversionContext().setProperty("org.swift.confluence.cache.request_parameters", cacheRequestParameters);
        return result;
    }

    protected boolean avoidUserCheck(String uri) throws MacroExecutionException {
        return MacroSecurityUtils.isSecurityEnabled((BandanaManager)this.bandanaManager) && MacroSecurityUtils.avoidUserCheckForUri((String)uri);
    }

    protected boolean getRequest(Map<String, List<String>> parameters, String key) {
        boolean result;
        block1: {
            String value;
            result = false;
            List<String> valueList = parameters.get(key);
            if (valueList == null) break block1;
            Iterator<String> iterator = valueList.iterator();
            while (iterator.hasNext() && !(result = (value = iterator.next()).equals("true"))) {
            }
        }
        return result;
    }

    protected boolean hasPageContext(MacroInfo info) {
        return info.getContent() != null && info.getContent().toPageContext() != null;
    }

    protected boolean isInteractive(MacroInfo info) {
        String type = info.getConversionContext().getOutputType();
        return type.equals(ConversionContextOutputType.DISPLAY.value()) || type.equals(ConversionContextOutputType.PREVIEW.value());
    }

    protected String getNextFutureId(MacroInfo info) {
        return (String)(info.getContent() == null ? "" : Long.toString(info.getContent().getId()) + "_") + ScriptUtils.getUniqueId();
    }

    protected int getTimeoutParameter(MacroInfo info) throws MacroExecutionException {
        int timeout;
        int globalTimeout = this.settingsManager.getGlobalSettings().getPageTimeout();
        String timeoutString = info.getMacroParams().getString("timeout", "").toLowerCase();
        try {
            timeout = timeoutString.equals("no limit") ? 0 : (timeoutString.equals("default") ? globalTimeout : info.getMacroParams().getInteger("timeout", Integer.valueOf(globalTimeout)));
        }
        catch (Exception exception) {
            throw new MacroExecutionException(exception.getMessage());
        }
        if (timeout < 0) {
            timeout = 0;
        }
        if (globalTimeout > 0 && (timeout > globalTimeout || timeout == 0)) {
            MacroSecurityUtils.securityCheck((BandanaManager)this.bandanaManager, (UserAccessor)this.userAccessor, (String)this.getMacroName(), (MacroInfo)info, (String)"timeout", null);
        }
        this.log.debug("timeout: {}", (Object)timeout);
        return timeout;
    }

    protected boolean useLoadText(String title) {
        String option = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.cache.loadTextOption");
        return StringUtils.isBlank((CharSequence)title) || option != null && !option.equalsIgnoreCase("Title");
    }

    protected int getDefaultRetryInterval() {
        Integer result = ScriptUtils.getIntegerOrNull((String)((String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.cache.retryInterval")));
        return result == null ? Constants.DEFAULT_RETRY_INTERVAL : result;
    }

    protected int getRetryIntervalParameter(MacroInfo info) throws MacroExecutionException {
        Integer retryInterval = null;
        String retryIntervalString = info.getMacroParams().getString("retryinterval", null);
        retryInterval = retryIntervalString != null && !retryIntervalString.equalsIgnoreCase("@default") ? ScriptUtils.getIntegerOrNull((String)retryIntervalString) : ScriptUtils.getIntegerOrNull((String)((String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.cache.retryInterval")));
        return retryInterval == null || retryInterval < 0 ? 0 : retryInterval;
    }

    protected String getRequestParameters(MacroInfo info) {
        if (info.getRequest() != null) {
            return CacheUtils.getMapAsRequestParameterString(info.getRequest().getParameterMap());
        }
        return "";
    }
}

