/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.TextExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.cache.CacheMacroContent;
import org.swift.confluence.cache.CacheManager;
import org.swift.confluence.cache.library.admin.DefaultCacheAdministrator;
import org.swift.confluence.cache.library.exception.StaleContentException;
import org.swift.confluence.macroutil.ContentPropertyStorage;

public class CacheExtractor
implements Extractor2 {
    private static final Logger log = LoggerFactory.getLogger(CacheExtractor.class);
    protected final GeneralCacheAdministrator admin = CacheManager.instance().getGeneralCacheAdministrator();

    public Collection<FieldDescriptor> extractFields(Object arg0) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder extractText(Object searchable) {
        ContentPropertyStorage propertyStorage;
        Set indexKeySet;
        StringBuilder builder = new StringBuilder();
        if (searchable instanceof ContentEntityObject && (indexKeySet = (propertyStorage = new ContentPropertyStorage((ContentEntityObject)searchable)).getStringSet("org.swift.confluence.cache.CacheMacro", null)) != null) {
            HashSet<String> removeKeySet = new HashSet<String>();
            log.debug("indexKeySet size: {}", (Object)indexKeySet.size());
            Set set = indexKeySet;
            synchronized (set) {
                for (String key : indexKeySet) {
                    log.debug("key: {}", (Object)key);
                    String rendered = this.getRenderedContent(key);
                    if (rendered != null) {
                        Source source = new Source((CharSequence)rendered);
                        source.fullSequentialParse();
                        TextExtractor textExtractor = new TextExtractor((Segment)source);
                        textExtractor.setIncludeAttributes(true);
                        String text = textExtractor.toString();
                        log.debug("Rendered length: {}", (Object)rendered.length());
                        log.debug("Text length: {}", (Object)text.length());
                        log.debug("Text: {}", (Object)(log.isDebugEnabled() && text.length() > 50 ? text.substring(0, 50) : text));
                        builder.append(" ").append(text);
                        continue;
                    }
                    log.debug("nothing cached");
                    removeKeySet.add(key);
                }
            }
            for (String aRemoveKeySet : removeKeySet) {
                indexKeySet.remove(aRemoveKeySet);
            }
            propertyStorage.setStringSet("org.swift.confluence.cache.CacheMacro", indexKeySet);
        }
        return builder;
    }

    protected String getRenderedContent(String key) {
        String content = null;
        try {
            CacheMacroContent currentCachedContent;
            log.debug("Key: {}", (Object)key);
            DefaultCacheAdministrator cacheAdmin = DefaultCacheAdministrator.getCacheAdministrator();
            log.debug("cacheAdmin: {}", (Object)cacheAdmin);
            if (cacheAdmin != null && (currentCachedContent = (CacheMacroContent)cacheAdmin.getDataFromCache(key)) != null) {
                log.debug("content found");
                content = (String)currentCachedContent.getContent();
            }
            log.debug("Retrieved content from cache");
        }
        catch (StaleContentException staleContentException) {
            log.debug("staleContentException exception");
            CacheMacroContent currentCachedContent = (CacheMacroContent)staleContentException.getCacheContent();
            if (currentCachedContent != null) {
                content = (String)currentCachedContent.getContent();
            }
        }
        catch (Exception exception) {
            log.debug("Unexpected exception indexing cached content: {}", (Object)exception.toString());
        }
        return content;
    }
}

