/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.swift.confluence.cache.library.bean.CacheSetting;
import org.swift.confluence.cache.library.bean.CachedContent;

public class CacheMacroContent
extends CachedContent {
    private static final long serialVersionUID = -2373539786443357679L;
    private Collection<String> webResources;
    public final String dateRendered = new Date().toString();
    Map<String, byte[]> imageDataMap = new HashMap<String, byte[]>();

    public CacheMacroContent(Object content, Set<String> webResources, long checksum, CacheSetting cacheSetting) {
        super(content, cacheSetting);
        this.webResources = webResources;
        this.checksum = checksum;
    }

    public long generateChecksum() {
        return this.checksum;
    }

    public long calculateContentSize() {
        int webResourceSize = 0;
        for (String webResource : this.webResources) {
            webResourceSize += webResource.length();
        }
        return this.getContent() != null ? this.getContent().toString().length() + webResourceSize : 0;
    }

    public Collection<String> getWebResources() {
        return this.webResources;
    }

    public void setWebResources(Collection<String> webResources) {
        this.webResources = webResources;
    }

    public Map<String, byte[]> getImageDataMap() {
        return this.imageDataMap;
    }

    public void setImageDataMap(Map<String, byte[]> imageDataMap) {
        this.imageDataMap = imageDataMap;
    }
}

