/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache;

import org.apache.commons.lang3.StringUtils;

public class CacheKey {
    private static final char SEPARATOR = ':';
    private final String spaceKey;
    private final String pageName;
    private final String id;
    private final String outputType;
    private String cacheKey = null;

    public CacheKey(String spaceKey, String pageName, String id, String outputType) {
        this.spaceKey = CacheKey.replaceIllegalChars(spaceKey);
        this.pageName = CacheKey.replaceIllegalChars(pageName);
        this.id = id;
        this.outputType = outputType;
    }

    public CacheKey withOutputType(String newOutputType) {
        return new CacheKey(this.spaceKey, this.pageName, this.id, newOutputType);
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getId() {
        return this.id;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public String toString() {
        if (this.cacheKey == null) {
            this.cacheKey = this.spaceKey + ":" + this.pageName + ":" + this.id + ":" + this.outputType;
        }
        return this.cacheKey;
    }

    public int hashCode() {
        return CacheKey.hashCode(this.spaceKey, this.pageName, this.id, this.outputType);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CacheKey)) {
            return false;
        }
        CacheKey that = (CacheKey)o;
        boolean equal = CacheKey.equals(this.spaceKey, that.spaceKey);
        equal &= CacheKey.equals(this.pageName, that.pageName);
        equal &= CacheKey.equals(this.id, that.id);
        return equal &= CacheKey.equals(this.outputType, that.outputType);
    }

    private static String replaceIllegalChars(String str) {
        return StringUtils.replaceChars((String)str, (char)':', (char)'_');
    }

    private static boolean equals(Object left, Object right) {
        return left != null && left.equals(right) || left == right;
    }

    private static int hashCode(Object ... args) {
        int hashCode = 0;
        for (Object o : args) {
            hashCode += o == null ? 0 : o.hashCode();
        }
        return hashCode;
    }
}

