/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.swift.confluence.cache.BaseSupport;
import org.swift.confluence.cache.CacheKey;
import org.swift.confluence.cache.CacheMacro;
import org.swift.confluence.cache.CacheMacroContent;
import org.swift.confluence.cache.CacheManagerCurrent;
import org.swift.confluence.cache.library.admin.CacheAdministrator;
import org.swift.confluence.cache.library.bean.CacheSetting;
import org.swift.confluence.cache.library.bean.CachedContent;
import org.swift.confluence.cache.library.exception.StaleContentException;
import org.swift.confluence.cache.util.CacheUtils;
import org.swift.confluence.macroutil.ContentPropertyStorage;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.macroutil.RequestParameterStorage;
import org.swift.confluence.scriptutil.ScriptUtils;

public class AtlassianCacheSupport
extends BaseSupport {
    private final CacheAdministrator admin;
    protected static final ConfluenceBandanaContext bandanaContext = new ConfluenceBandanaContext();
    private final BootstrapManager bootstrapManager;

    public AtlassianCacheSupport(CacheMacro macro, FormatSettingsManager formatSettingsManager, BandanaManager bandanaManager, UserAccessor userAccessor, AttachmentManager attachmentManager, SubRenderer subRenderer, ConfluenceIndexer confluenceIndexer, SettingsManager settingsManager, BootstrapManager bootstrapManager) {
        super(macro, formatSettingsManager, bandanaManager, userAccessor, attachmentManager, subRenderer, confluenceIndexer, settingsManager);
        this.admin = CacheManagerCurrent.instance().getCacheAdministrator(bandanaManager, (BandanaContext)bandanaContext);
        this.bootstrapManager = bootstrapManager;
    }

    protected String process(MacroInfo info) throws MacroExecutionException {
        CacheKey key = new CacheKey(this.pageContext.getPageTitle(), this.pageContext.getSpaceKey(), this.id, this.pageContext.getOutputType());
        String keyString = key.toString();
        this.addKeyForExtractor(keyString, this.content);
        this.log.debug("Cache key: {}", (Object)keyString);
        if (this.content != null) {
            this.handleRefresh(info, keyString, this.id);
        }
        CacheMacroContent cachedContent = this.getCachedContent(info, key, this.refreshPeriod, this.cronExpression, this.newChecksum, this.failover, this.index);
        String renderedContent = this.getRenderableContent(info, (Object)cachedContent, this.anchor, this.id, this.showDate, this.dateFormat);
        return renderedContent;
    }

    protected void addKeyForExtractor(String cacheKey, ContentEntityObject content) {
        if (this.index) {
            ContentPropertyStorage propertyStorage = new ContentPropertyStorage(content);
            Set<String> indexKeySet = propertyStorage.getStringSet("org.swift.confluence.cache.CacheMacro", null);
            if (indexKeySet == null) {
                indexKeySet = Collections.synchronizedSet(new HashSet());
            }
            this.log.debug("Adding  cacheKey  to indexKeySet: {}" + cacheKey);
            indexKeySet.add(cacheKey);
            propertyStorage.setStringSet("org.swift.confluence.cache.CacheMacro", indexKeySet);
        }
    }

    protected String getRenderableContent(MacroInfo info, Object cachedContent, String anchor, String id, boolean showDate, String dateFormat) throws MacroExecutionException {
        StringBuilder builder = new StringBuilder();
        if (cachedContent != null) {
            if (((String)anchor).equalsIgnoreCase("@default")) {
                anchor = "cache-anchor-" + id;
                String anchorWiki = "{anchor:" + (String)anchor + "}";
                builder.append(ScriptUtils.renderLegacy((SubRenderer)this.subRenderer, (PageContext)info.getConversionContext().getPageContext(), (String)anchorWiki));
            }
            String dateString = this.getDateString(((CacheMacroContent)((Object)cachedContent)).dateRendered, dateFormat);
            String extra = this.getRefreshLink(info, id, (String)anchor) + (showDate ? dateString : "");
            if (!extra.equals("")) {
                builder.append(extra).append("<br/>");
            }
            builder.append(((CacheMacroContent)((Object)cachedContent)).getContent());
            return builder.toString();
        }
        builder.append(this.macro.getText("org.swift.confluence.cache.warning.content-not-available"));
        return builder.toString();
    }

    protected void handleRefresh(MacroInfo info, String keyString, String id) throws MacroExecutionException {
        if (this.isRequestRefreshable(info.getConversionContext().getPageContext().getOutputType())) {
            RequestParameterStorage requestParameters = info.getRequestParams();
            if (requestParameters == null) {
                Map<String, List<String>> parameters;
                List<String> valueList;
                String cacheRequestParameters = ScriptUtils.getCachePsuedoRequestParameters((MacroInfo)info);
                if (cacheRequestParameters != null && (valueList = (parameters = CacheUtils.getRequestParameterAsMap(cacheRequestParameters)).get("refresh")) != null) {
                    for (String value : valueList) {
                        if (!value.equals("true") && !value.equals(id)) continue;
                        this.log.debug("refresh key: {}", (Object)keyString);
                        this.admin.flushEntry(keyString);
                    }
                }
            } else if (requestParameters.getBoolean("refresh", false).booleanValue() || requestParameters.getString("refresh", "").equals(id)) {
                this.log.debug("Forcing content to refresh with key: {}", (Object)keyString);
                this.admin.flushEntry(keyString);
            }
        }
    }

    protected CacheMacroContent getCachedContent(MacroInfo info, CacheKey cacheKey, int refreshPeriod, String cronExpression, long newChecksum, boolean failover, boolean index) throws MacroExecutionException {
        CacheMacroContent cached;
        boolean needResources = true;
        try {
            cached = this.getContentFromCache(cacheKey, refreshPeriod, cronExpression);
            this.log.debug("newChecksum: {}, oldChecksum: {} ", (Object)newChecksum, (Object)cached.getChecksum());
            if (!cached.isValid(newChecksum)) {
                this.log.debug("cache not valid based on crc check");
                cached = this.getNewCachedContent(info, cached, cacheKey, newChecksum, failover, index);
                needResources = false;
            }
            this.log.debug("Retrieved content from cache");
            if (needResources && cached.getWebResources() != null) {
                CacheUtils.loadWebResources(cached.getWebResources());
            }
        }
        catch (StaleContentException e) {
            cached = this.getNewCachedContent(info, (CacheMacroContent)e.getCacheContent(), cacheKey, newChecksum, failover, index);
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheMacroContent getNewCachedContent(MacroInfo info, CacheMacroContent staleCachedContent, CacheKey key, long newChecksum, boolean failover, boolean index) throws MacroExecutionException {
        CacheMacroContent cached;
        String keyStr = key.toString();
        boolean updated = false;
        try {
            String content = this.macro.render(info);
            Set<String> webResources = null;
            WebResourceSet webResourceSet = CacheUtils.getWebResourceSet();
            webResources = CacheUtils.getWebResourceContexts(webResourceSet);
            boolean enableRetry = this.getRetryParameter(info);
            this.log.debug("enable retry: {}", (Object)enableRetry);
            CacheSetting cacheSetting = this.buildCacheSetting(this.refreshPeriod, this.cronExpression);
            if (enableRetry && info.getConversionContext().getProperty("org.swift.confluence.cache.retry_possible") != null) {
                this.log.debug("Error with retry possible, use previous cached version: {}", (Object)staleCachedContent);
                cached = staleCachedContent;
                if (cached == null) {
                    cached = new CacheMacroContent(content, webResources, newChecksum, cacheSetting);
                } else if (cached.getWebResources() != null) {
                    CacheUtils.loadWebResources(cached.getWebResources());
                }
            } else {
                cached = new CacheMacroContent(content, webResources, newChecksum, cacheSetting);
                cached.setImageDataMap(CacheUtils.saveImages((String)cached.getContent(), this.bootstrapManager.getLocalHome().getPath(), this.getTempDirectory()));
                this.log.debug("Put in cache for key: {} ", (Object)keyStr);
                this.admin.putInCache(keyStr, (CachedContent)cached);
                CacheUtils.compareAndUpdateMaxEntriesConfiguration(this.admin, this.bandanaManager);
                updated = true;
                this.log.debug("Refreshed cache with key: {}", (Object)key);
            }
        }
        catch (Exception exception) {
            if (!failover) {
                throw new MacroExecutionException("Failed to load/refresh cache", (Throwable)exception);
            }
            this.log.warn("Failed to update cache, using previously cached version", (Throwable)exception);
            cached = staleCachedContent;
        }
        finally {
            if (updated && index && this.confluenceIndexer != null) {
                this.log.debug("request content indexing for: {}", (Object)this.pageContext.getPageTitle());
                this.confluenceIndexer.reIndex((Searchable)info.getContent());
            }
        }
        return cached;
    }

    private CacheMacroContent getContentFromCache(CacheKey key, int refreshPeriod, String cronExpression) throws StaleContentException {
        String keyStr = key.toString();
        this.log.debug("Get content for {}", (Object)keyStr);
        CacheMacroContent cachedContent = (CacheMacroContent)this.admin.getDataFromCache(keyStr);
        try {
            String renderableContent = CacheUtils.getImages(cachedContent, this.getTempDirectoryAbsolutePath(), this.getDownloadUrl());
            if (renderableContent != null) {
                cachedContent = this.reloadUpdatedCachedContentToCache(keyStr, cachedContent, renderableContent);
            }
        }
        catch (IOException e) {
            this.log.error("Error while building image..." + e);
        }
        this.updateCacheSettingInCachedContent(keyStr, cachedContent);
        return cachedContent;
    }

    private CacheMacroContent reloadUpdatedCachedContentToCache(String keyStr, CacheMacroContent cachedContent, String renderableContent) {
        CacheMacroContent updatedCachedContent = new CacheMacroContent(renderableContent, (Set)cachedContent.getWebResources(), cachedContent.getChecksum(), cachedContent.getCacheSetting());
        updatedCachedContent.setImageDataMap(cachedContent.getImageDataMap());
        this.admin.putInCache(keyStr, (CachedContent)updatedCachedContent);
        return updatedCachedContent;
    }

    private void updateCacheSettingInCachedContent(String keyStr, CacheMacroContent cachedContent) {
        if (cachedContent != null) {
            boolean needUpdate = false;
            if (this.refreshPeriod > 0 && (long)this.refreshPeriod != cachedContent.getCacheSetting().getRefreshPeriod()) {
                cachedContent.getCacheSetting().setRefreshPeriod((long)this.refreshPeriod);
                needUpdate = true;
            }
            if (this.cronExpression != null && this.cronExpression.length() > 0 && this.cronExpression != cachedContent.getCacheSetting().getCronExpression()) {
                cachedContent.getCacheSetting().setCronExpression(this.cronExpression);
                needUpdate = true;
            }
            if (needUpdate) {
                this.admin.updateCacheSetting(keyStr, cachedContent.getCacheSetting());
            }
        }
    }

    private CacheSetting buildCacheSetting(int refreshPeriod, String cronExpression) {
        CacheSetting cacheSetting = new CacheSetting();
        cacheSetting.setCronExpression(cronExpression);
        cacheSetting.setRefreshPeriod((long)refreshPeriod);
        return cacheSetting;
    }

    private String getDownloadUrl() {
        return this.bootstrapManager.getWebAppContextPath() + "/download/" + this.getTempDirectory() + "/";
    }

    private String getTempDirectoryAbsolutePath() {
        if (CacheUtils.isVersionAtLeast("8")) {
            return this.bootstrapManager.getFilePathProperty("struts.multipart.saveDir");
        }
        return this.bootstrapManager.getFilePathProperty("webwork.multipart.saveDir");
    }

    private String getTempDirectory() {
        int homeDirIndex;
        String tempDirectory = this.getTempDirectoryAbsolutePath();
        if (this.bootstrapManager.getLocalHome() != null && (homeDirIndex = tempDirectory.indexOf(this.bootstrapManager.getLocalHome().getPath())) != -1) {
            tempDirectory = tempDirectory.substring(homeDirIndex + this.bootstrapManager.getLocalHome().getPath().length() + 1);
        }
        return tempDirectory;
    }
}

