/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache.util;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.cache.CacheConfigManager;
import com.atlassian.confluence.cache.CacheStatistics;
import com.atlassian.confluence.cache.CacheStatisticsManager;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.webresource.data.DefaultPluginDataResource;
import com.atlassian.spring.container.ComponentNotFoundException;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.WebResource;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.assembler.resource.PluginCssResource;
import com.atlassian.webresource.api.assembler.resource.PluginJsResource;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.cache.CacheMacroContent;
import org.swift.confluence.cache.library.admin.CacheAdministrator;

public class CacheUtils {
    protected static final Logger log = LoggerFactory.getLogger(CacheUtils.class);

    public static String getMapAsRequestParameterString(Map<String, String[]> parameters) {
        StringBuilder builder = new StringBuilder();
        if (parameters != null) {
            String separator = "&";
            for (String key : parameters.keySet()) {
                if (key.equals("")) continue;
                HashSet<Object> values = new HashSet<Object>(Arrays.asList((Object[])parameters.get(key)));
                for (String string : values) {
                    builder.append(separator).append(key).append("=").append(CacheUtils.urlEncode(string));
                }
            }
        }
        return builder.toString();
    }

    public static Map<String, List<String>> getRequestParameterAsMap(String requestString) {
        String[] array;
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        for (String string : array = requestString.split("&")) {
            if (!string.contains("=")) continue;
            int index = string.indexOf("=");
            String key = string.substring(0, index);
            if (parameters.get(key) == null) {
                parameters.put(key, new ArrayList());
            }
            ((List)parameters.get(key)).add(CacheUtils.urlDecode(string.substring(index + 1)));
        }
        return parameters;
    }

    public static String urlEncode(String string) {
        try {
            if (string != null) {
                return URLEncoder.encode(string, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "";
    }

    public static String urlDecode(String string) {
        try {
            if (string != null) {
                return URLDecoder.decode(string, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "";
    }

    public static PageBuilderService getPageBuilderService() {
        PageBuilderService pageBuilderService;
        try {
            pageBuilderService = (PageBuilderService)ContainerManager.getComponent((String)"pageBuilderService");
        }
        catch (ComponentNotFoundException e) {
            log.debug("Confluence version < 5.4.3: {}", (Object)e.getMessage());
            pageBuilderService = null;
        }
        return pageBuilderService;
    }

    public static WebResourceSet getWebResourceSet() {
        WebResourceSet webResourceSet = null;
        PageBuilderService pageBuilderService = CacheUtils.getPageBuilderService();
        if (pageBuilderService != null) {
            webResourceSet = pageBuilderService.assembler().assembled().peek();
        }
        return webResourceSet;
    }

    public static void loadWebResources(Collection<String> webResources) {
        PageBuilderService pageBuilderService = CacheUtils.getPageBuilderService();
        if (webResources != null && pageBuilderService != null) {
            log.debug("WebReources available before loading resources:");
            WebResourceSet webResourceSet = CacheUtils.getWebResourceSet();
            CacheUtils.printWebResourceSet(webResourceSet);
            for (String webResourceContext : webResources) {
                if (CacheUtils.isWebResourceAlreadyAvailable(webResourceContext, webResourceSet)) continue;
                if (webResourceContext.contains("com.atlassian.confluence.ext.newcode-macro-plugin:syntaxhighlighter")) {
                    pageBuilderService.assembler().resources().requireContext("com.atlassian.confluence.ext.newcode-macro-plugin:syntaxhighlighter");
                }
                pageBuilderService.assembler().resources().requireContext(webResourceContext);
                log.debug("require resource context (Confluence > 5.4.3): {}", (Object)webResourceContext);
            }
        }
    }

    private static boolean isWebResourceAlreadyAvailable(String webResourceContext, WebResourceSet webResourceSet) {
        Iterable wsIterable = webResourceSet.getResources();
        for (WebResource ws : wsIterable) {
            String resourceContext = CacheUtils.getResourceContext(ws);
            if (!webResourceContext.equalsIgnoreCase(resourceContext)) continue;
            log.debug("Web resource already available, need not be loaded again: {}", (Object)resourceContext);
            return true;
        }
        return false;
    }

    public static Set<String> getWebResourceContexts(WebResourceSet webResourceSet) {
        HashSet<String> webResources = new HashSet<String>();
        Iterable wsIterable = webResourceSet.getResources();
        for (WebResource ws : wsIterable) {
            log.debug("Confluence version >= 5.4.3... web resources: {}", (Object)ws);
            String resourceContext = CacheUtils.getResourceContext(ws);
            if (ws.toString().contains("superbatch") || webResources.contains(resourceContext) || resourceContext.isEmpty()) continue;
            log.debug("Resources to be loaded: {}", (Object)resourceContext);
            webResources.add(resourceContext);
        }
        return webResources;
    }

    private static String getResourceContext(WebResource ws) {
        String resourceContext = "";
        String resourceStaticUrl = "";
        if (ws instanceof PluginCssResource) {
            resourceStaticUrl = ((PluginCssResource)ws).getStaticUrl(UrlMode.AUTO);
        } else if (ws instanceof PluginJsResource) {
            resourceStaticUrl = ((PluginJsResource)ws).getStaticUrl(UrlMode.AUTO);
        }
        if (!resourceStaticUrl.isEmpty()) {
            String temp1 = resourceStaticUrl.substring(0, resourceStaticUrl.lastIndexOf("/"));
            resourceContext = temp1.substring(temp1.lastIndexOf("/") + 1, temp1.length());
        }
        return resourceContext;
    }

    public static void printWebResourceSet(WebResourceSet webResourceSet) {
        if (log.isDebugEnabled()) {
            Iterable wsIterable = webResourceSet.getResources();
            for (WebResource ws : wsIterable) {
                String resourceStaticUrl = "";
                if (ws instanceof PluginCssResource) {
                    resourceStaticUrl = ((PluginCssResource)ws).getStaticUrl(UrlMode.AUTO);
                } else if (ws instanceof PluginJsResource) {
                    resourceStaticUrl = ((PluginJsResource)ws).getStaticUrl(UrlMode.AUTO);
                } else if (ws instanceof DefaultPluginDataResource) {
                    log.debug("webresource key" + ((DefaultPluginDataResource)ws).getKey());
                }
                log.debug("web resources static URL: {}", (Object)resourceStaticUrl);
            }
        }
    }

    private static byte[] extractBytes(String imageFilePath) throws IOException {
        File imgPath = new File(imageFilePath);
        BufferedImage bufferedImage = ImageIO.read(imgPath);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, CacheUtils.getExtension(imageFilePath), baos);
        byte[] imageByteArray = baos.toByteArray();
        log.debug("Converted imagefile to byearray {} file-size:{} byteArraysize: {}", new Object[]{imageFilePath, imgPath.length(), imageByteArray.length});
        return imageByteArray;
    }

    private static void createImage(byte[] imageInByte, String fileName) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(imageInByte);
        BufferedImage bImageFromConvert = ImageIO.read(in);
        File file = new File(fileName);
        ImageIO.write((RenderedImage)bImageFromConvert, CacheUtils.getExtension(fileName), file);
        log.debug("Converted byearray to image {}  file-size: {}", (Object)file, (Object)file.length());
    }

    private static ArrayList<String> findImages(String input, String tempDirectory) {
        String htmlImagePath = "/download/" + tempDirectory + "/";
        ArrayList<String> imageList = new ArrayList<String>();
        Pattern p = Pattern.compile("(<img\\s*src=(\"|')/download/" + tempDirectory + "\\S*(\"|'))");
        Matcher m = p.matcher(input);
        while (m.find()) {
            log.debug("Found  " + m.group() + ".");
            String matchedString = m.group();
            String image = matchedString.substring(matchedString.indexOf(htmlImagePath) + htmlImagePath.length(), matchedString.length() - 1);
            log.debug("image : " + image);
            imageList.add(image);
        }
        return imageList;
    }

    private static Map<String, byte[]> getImageByteArray(ArrayList<String> imageList, String tempDirectory) throws IOException {
        HashMap<String, byte[]> imageDataMap = new HashMap<String, byte[]>();
        if (imageList != null) {
            for (String image : imageList) {
                imageDataMap.put(image, CacheUtils.extractBytes(tempDirectory + image));
            }
        }
        return imageDataMap;
    }

    private static boolean imageExists(String tempPath, String imageName) {
        File file = new File(tempPath + imageName);
        return file.exists();
    }

    public static Map<String, byte[]> saveImages(String input, String confluenceHome, String tempDirectory) throws IOException {
        ArrayList<String> imageList = CacheUtils.findImages(input, tempDirectory);
        Map<String, byte[]> imageDataMap = CacheUtils.getImageByteArray(imageList, tempDirectory = confluenceHome + "/" + tempDirectory + "/");
        if (imageDataMap != null) {
            for (Map.Entry<String, byte[]> imageData : imageDataMap.entrySet()) {
                log.debug(imageData.getKey() + "/" + imageData.getValue());
            }
        }
        return imageDataMap;
    }

    private static String getExtension(String key) {
        return key.substring(key.lastIndexOf(".") + 1, key.length());
    }

    public static String getImages(CacheMacroContent cachedContent, String tempDirectoryAbsolutePath, String tempUrl) throws IOException {
        tempDirectoryAbsolutePath = tempDirectoryAbsolutePath + "/";
        String renderableContent = (String)cachedContent.getContent();
        Map<String, byte[]> imageDataMap = cachedContent.getImageDataMap();
        HashMap<String, byte[]> tempImageDataMap = new HashMap<String, byte[]>();
        Iterator<Map.Entry<String, byte[]>> iterator = imageDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, byte[]> imageData = iterator.next();
            String imageName = imageData.getKey();
            if (!CacheUtils.imageExists(tempDirectoryAbsolutePath, imageData.getKey())) {
                log.debug(imageData.getKey() + " does not exist");
                CacheUtils.createImage(imageData.getValue(), tempDirectoryAbsolutePath + imageData.getKey());
            } else if (!CacheUtils.isSameImage(tempDirectoryAbsolutePath, imageData.getKey(), imageData.getValue())) {
                log.debug("Oh Noooooo :(, another file with same name {} but with DIFFERENT SIZE already exists in temp !!!", (Object)imageData.getKey());
                String newTempImage = Calendar.getInstance().getTimeInMillis() + "_" + imageData.getKey();
                CacheUtils.createImage(imageData.getValue(), tempDirectoryAbsolutePath + newTempImage);
                imageName = newTempImage;
                renderableContent = CacheUtils.updateCachedContent(renderableContent, imageData.getKey(), newTempImage);
                tempImageDataMap.put(newTempImage, imageData.getValue());
                iterator.remove();
            }
            CacheUtils.allowAccess(imageName, tempUrl);
        }
        if (tempImageDataMap != null && tempImageDataMap.size() > 0) {
            imageDataMap.putAll(tempImageDataMap);
            cachedContent.setImageDataMap(imageDataMap);
            return renderableContent;
        }
        return null;
    }

    private static String updateCachedContent(String renderableContent, String key, String newTempImage) {
        return renderableContent.replace(key, newTempImage);
    }

    private static boolean isSameImage(String tempDirectoryAbsolutePath, String imageName, byte[] imageByteArray) {
        File file = new File(tempDirectoryAbsolutePath + imageName);
        return file.length() == (long)imageByteArray.length;
    }

    private static void allowAccess(String imageName, String tempUrl) {
        String path = tempUrl.substring(tempUrl.indexOf("download")) + imageName;
        GateKeeper gateKeeper = (GateKeeper)ContainerManager.getComponent((String)"gateKeeper");
        log.debug("isAccessPermitted to path {} : {}", (Object)path, (Object)gateKeeper.isAccessPermitted(path, (User)AuthenticatedUserThreadLocal.get()));
        if (!gateKeeper.isAccessPermitted(path, (User)AuthenticatedUserThreadLocal.get())) {
            gateKeeper.addKey(path, (User)AuthenticatedUserThreadLocal.get());
            log.debug("check access again :{}", (Object)gateKeeper.isAccessPermitted(path, (User)AuthenticatedUserThreadLocal.get()));
        }
    }

    public static long getConfluenceCacheSize() {
        CacheStatisticsManager cacheStatisticsManager = (CacheStatisticsManager)ContainerManager.getComponent((String)"cacheStatisticsManager");
        CacheStatistics cacheStat = cacheStatisticsManager.getLocalCacheStatistics("org.swift.confluence.cache_cache");
        if (cacheStat != null) {
            log.debug("Max entries that can be stored in Cache:{}", (Object)cacheStat.getMaxSize());
            log.debug("No. of entries now in Cache:{}", (Object)cacheStat.getSize());
        }
        return cacheStat.getMaxSize();
    }

    public static void updateConfluenceCacheSize(int size) {
        CacheConfigManager cacheConfigManager = (CacheConfigManager)ContainerManager.getComponent((String)"cacheConfigManager");
        if (cacheConfigManager != null) {
            cacheConfigManager.changeMaxCacheSize("org.swift.confluence.cache_cache", size);
            log.debug(" Updated  max Cache entries: {}", (Object)size);
        }
    }

    public static void compareAndUpdateMaxEntriesConfiguration(CacheAdministrator admin, BandanaManager bandanaManager) throws Exception {
        CacheStatisticsManager cacheStatisticsManager = (CacheStatisticsManager)ContainerManager.getComponent((String)"cacheStatisticsManager");
        long confluenceCacheSize = cacheStatisticsManager.getLocalCacheStatistics("org.swift.confluence.cache_cache").getMaxSize();
        if (confluenceCacheSize < admin.getConfig().getMaxEntries()) {
            log.debug("Found Confluence cache Max entries(" + confluenceCacheSize + ") lower, so updating our Add-on max entries configuration.");
            admin.getConfig().setMaxEntries(confluenceCacheSize);
            CacheUtils.updateMaxEntriesConfiguration(bandanaManager, (int)admin.getConfig().getMaxEntries());
        }
    }

    public static void updateMaxEntriesConfiguration(BandanaManager bandanaManager, int maxEntries) throws Exception {
        if (maxEntries > 0) {
            log.debug("Max entries configuration  entry updated to :{}", (Object)maxEntries);
            bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.cache.maxEntries", (Object)String.valueOf(maxEntries));
        }
    }

    public static void logExceptionStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String sStackTrace = sw.toString();
        if (log.isDebugEnabled()) {
            log.debug("Stack trace :{}", (Object)sStackTrace);
        }
    }
}

