/*
 * Copyright (c) 2018, 2020 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Bob Swift Atlassian Apps EULA"
 * (https://bobswift.atlassian.net/wiki/x/WoDXBQ) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function($) {

    var FutureMacro = {
        futures : [],
        sessionStorage : {},
        init : function() {
            // this.sessionStorage = window.sessionStorage ? new WindowSessionStorage() : new InputControlSessionStorage();
            this.sessionStorage = new InputControlSessionStorage();

            FutureWidget.getAll().each(function() {
                FutureMacro.registerFuture(this.getFuture());
            });

            $.each(this.futures, function(i, future) {
                var widget = FutureWidget.get(future.id);
                if (future.manual) {
                    widget.getManualButton().bind("click", future, FutureMacro.handleManualClick);
                } else {
                    var cachedResult = FutureMacro.sessionStorage.get(future.id);
                    if (cachedResult) {
                        (new FutureMacro.FutureCallback(future)).futureImmediate(cachedResult.toString());
                        return;
                    }

                    if (future.pageId) {
                        if (future.delay > 0) {
                            setTimeout(function(){ FutureMacro.processFuture(future)}, future.delay * 1000);
                        } else {
                            FutureMacro.processFuture(future);
                        }
                    }
                    /*
                     * else FutureRenderer.convertContentToHtml(future.content, new FutureMacro.FutureCallback(future));
                     */
                }
            });

            this.registerPollInterval();
        },
        registerPollInterval : function() {
            if (this.pollInterval)
                return;

            this.pollInterval = window.setInterval(function() {
                FutureMacro.pollRenderQueue()
            }, 1000);
        },
        pollInterval : null,
        registerFuture : function(future) {
            if (!(future instanceof FutureMacro.Future))
                throw "Future object must be an instance of FutureMacro.Future";
            FutureMacro.futures.push(future);
        },
        clearPollInterval : function() {
            window.clearInterval(this.pollInterval);
            this.pollInterval = null;
        },
        pollRenderQueue : function() {
            if (this.renderQueue.length == 0)
                return;

            this.clearPollInterval();
            var nextRenderFunction = this.renderQueue.shift();
            nextRenderFunction(function() {
                FutureMacro.registerPollInterval()
            });
        },
        processFuture : function(future) {
            /////// Cache-105
            //AJS.log("Before future content loads, add attr [data-sortable] to existing "+ $('table').length +" tables (i.e. Tables outside future macro). So that enable method will not be called AGAIN for these tables.");
      var   tables = $('table');
      var confluenceVersion = AJS.Meta.get("version-number");
      //AJS.log("$('buildNumber').val():"+$("#buildNumber").val());
      if($("#buildNumber").val() >= 6183) //6183 = Confluence 5.9.1-pluginsfour019 build number
          var confluenceSortableTableModule = require('confluence-sortable-tables/sortable-tables');
      tables.each(function(){
      var thisTable = $(this);
      var hasSortableAttr = this.hasAttribute("data-sortable");
      if(!confluenceSortableTableModule){ //this code will work for confluence < 5.9
      if(!hasSortableAttr)
          thisTable.attr("data-sortable","false");
      }
      });

            AJS.$.ajax({
                type : 'POST',
                dataType : 'html',
                url : Confluence.getContextPath() + "/plugins/servlet/futureRenderer",
                data : {
                    pageId : future.pageId,
                    content : future.content,
                    contentType : future.contentType,
                    avoidUserCheck : future.avoidUserCheck,
                    requestParameters : future.requestParameters,
                    retryInterval : future.retryInterval
                },
                timeout : future.timeout * 1000,
                success : function(reply) {
                    try {
                        if (reply == 'org.swift.confluence.cache.retry_possible') {
                            setTimeout(function(){ FutureMacro.processFuture(future)}, future.retryInterval * 1000); // try again in a few seconds
                        } else {
                      if(reply.indexOf("class=\"expand-control\"") > 0){
                          $(".expand-control", $("body")).unbind("click keyup");
                      }

                      let newDiv = document.createElement("div");
                         newDiv.innerHTML = reply;
                         let scriptTags = newDiv
                             .getElementsByTagName("script");
                         for(var i=0; i < scriptTags.length; i++){
                             if (scriptTags[i]
                                       .getAttribute("data-wrm-key") != null &&
                                       scriptTags[i]
                                       .getAttribute("data-wrm-key").includes("baseurl-checker-resource,-_super")) {
                                       console
                                           .log("Removing WRM key" +
                                               scriptTags[i]
                                               .getAttribute("data-wrm-key"));
                                       newDiv
                                           .querySelector(
                                               "script[data-wrm-key=\"" +
                                               scriptTags[i]
                                               .getAttribute("data-wrm-key") +
                                               "\"]")
                                           .remove();
                                   }
                         }

                         FutureWidget.get(future.id)
                             .getContentModule().html(newDiv.innerHTML);
                         //CACHE-368 - Trigger event for table library to handle and add export icons.
                         var futureDiv = FutureWidget.get(future.id).getContentModule();
                         futureDiv.trigger('future-draw-event', [futureDiv]);     
                        if (!confluenceSortableTableModule){
                            setTimeout(FutureMacro.enableSort, 100);
                        }
                        else{
                      confluenceSortableTableModule.init();
                      setTimeout(confluenceSortableTableModule.enable, 100);
                    }
                        new FutureMacro.FutureCallback(future).callback();
                        }
                    } catch (err) {
                        new FutureMacro.FutureCallback(future).errorHandler(err);
                    }
                },
                error : function(xhr, textStatus, errorThrown) {
                    new FutureMacro.FutureCallback(future).errorHandler(errorThrown);
                }
            });
        },
        renderQueue : []
    };
    //Cache-105 : Enable sorting for tables in future macro, and this logic works only for confluence < 5.9
 FutureMacro.enableSort = function() {
      Confluence.SortableTables.init();
      Confluence.SortableTables.enable();
    };
    // NOTE to update the numbers below for any parameter additions !!!
    FutureMacro.Future = function(id, content, contentType, avoidUserCheck, requestParameters, manual, timeout, retryInterval, delay) {
        this.id = id;
        this.content = content;
        this.contentType = contentType;
        this.avoidUserCheck = avoidUserCheck;
        this.requestParameters = requestParameters;
        this.manual = manual;
        this.timeout = timeout;
        this.retryInterval = retryInterval;
        this.delay = delay;
        this.pageId = arguments.length == 10 ? arguments[9] : null; // NOTE update numbers if you add more parameters
    };

    FutureMacro.CallbackSupport = function() {
        this.revealHideDelay = {
            hide : 250,
            reveal : 600
        };
    };

    FutureMacro.CallbackSupport.prototype = {
        errorHandler : function(err) {
            if (err == 'timeout') {
                $("#future-" + this.future.id).html("<p>Timeout (" + this.future.timeout + " secs) exceeded rendering this section.</p>");
            } else {
                $("#future-" + this.future.id).html("<p>There was a problem rendering this section: " + err + "</p>");
            }
        },
        futureReplace : function(renderFinished) {
            var futureId = this.future.id;
            var revealDelay = this.revealHideDelay.reveal;
            // CACHE-62: Looks like slideUp doesnt work when control is not visible. So explicitly set display property to None.
            $("#future-" + futureId).css("display", "none");
            $("#future-" + futureId).slideUp(this.revealHideDelay.hide, function() {
                $("#future-module-" + futureId).slideDown(revealDelay, renderFinished)
            });
        },
        futureImmediate : function(xhtml) {
            var futureId = this.future.id;
            this.module.html(xhtml);
            $("#future-" + futureId).css("display", "none"); // stop showing the Loading message
            $("#future-module-" + futureId).css("display", "block"); // start showing the content
        },
        callback : function() {
            var current = this;
            FutureMacro.sessionStorage.put(this.future.id, FutureWidget.get(this.future.id).getContentModule().html());
            FutureMacro.renderQueue.push(function(renderFinished) {
                current.futureReplace(renderFinished)
            })
        }
    };

    FutureMacro.FutureCallback = function(future) {
        this.future = future;
        this.module = $("#future-module-" + future.id);
    };

    FutureMacro.FutureCallback.prototype = new FutureMacro.CallbackSupport();

    FutureMacro.handleManualClick = function(e) {
        var future = e.data;
        $("#future-button-cont-" + future.id).css("display", "none");
        $("#future-" + future.id).css("display", "block");
        FutureMacro.processFuture(future);
    };

    var FutureWidget = function() {
        if (arguments.length == 1)
            this.id = arguments[0];
    };

    FutureWidget.prototype.getMacroPanel = function() {
        return $("#future-" + this.id);
    };

    FutureWidget.prototype.getFuture = function() {
        return new FutureMacro.Future(this.id, this.getContent(), this.getContentType(), this.getAvoidUserCheck(), this.getRequestParameters(),
                this.isManual(), this.getTimeout(), this.getRetryInterval(), this.getDelay(), this.getPageId());
    };

    FutureWidget.prototype.isManual = function() {
        return false;
    };

    FutureWidget.prototype.getContentModule = function() {
        return $("#future-module-" + this.id);
    };

    FutureWidget.prototype.getPageId = function() {
        return $("#future-page-id-" + this.id).val();
    };

    FutureWidget.prototype.getContent = function() {
        return $("#future-content-" + this.id).val();
    };

    FutureWidget.prototype.getContentType = function() {
        return $("#future-content-type-" + this.id).val();
    };

    FutureWidget.prototype.getAvoidUserCheck = function() {
        return $("#future-avoid-user-check-" + this.id).val();
    };
    FutureWidget.prototype.getRequestParameters = function() {
        return $("#future-request-parameters-" + this.id).val();
    };

    FutureWidget.prototype.getTimeout = function() {
        return $("#future-timeout-" + this.id).val();
    };

    FutureWidget.prototype.getRetryInterval = function() {
        return $("#future-retry-interval-" + this.id).val();
    };

    FutureWidget.prototype.getDelay = function() {
        return $("#future-delay-" + this.id).val();
    };

    FutureWidget.prototype.getRenderCache = function() {
        return $("#future-render-cache-" + this.id);
    };

    FutureWidget.getAll = function() {
        return $("div.future-macro").map(function() {
            var futureId = this.id.replace("future-", "");
            return FutureWidget.get(futureId);
        });
    };

    FutureWidget.get = function(id) {
        var macro = $("#future-" + id);
        if (!macro)
            return null;

        return macro.hasClass("manual-future") ? new ManualFutureWidget(id) : new FutureWidget(id);
    };

    var ManualFutureWidget = function(id) {
        arguments.callee.prototype.constructor.apply(this, [ id ])
    };
    ManualFutureWidget.prototype = new FutureWidget();

    ManualFutureWidget.prototype.getManualButton = function() {
        return $("#future-button-cont-" + this.id);
    };

    ManualFutureWidget.prototype.isManual = function() {
        return true;
    };

    var WindowSessionStorage = function() {
    };

    WindowSessionStorage.prototype.get = function(id) {
        return window.sessionStorage.getItem(id);
    };

    WindowSessionStorage.prototype.put = function(id, val) {
        window.sessionStorage.setItem(id, val);
    };

    var InputControlSessionStorage = function() {
    };

    InputControlSessionStorage.prototype.get = function(id) {
        var val = FutureWidget.get(id).getRenderCache().val();
        if (val == null || val == "")
            return null;

        if (val == "!")
            return "";

        return val.toString().substr(1);
    };

    InputControlSessionStorage.prototype.put = function(id, val) {
        FutureWidget.get(id).getRenderCache().val("!" + val);
    };

    $(function() {
        FutureMacro.init()
    });

})(AJS.$);
