/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache.config;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.cache.CacheManagerCurrent;
import org.swift.confluence.cache.Constants;
import org.swift.confluence.cache.library.admin.CacheAdministrator;
import org.swift.confluence.cache.library.admin.DefaultCacheAdministrator;
import org.swift.confluence.cache.library.bean.Config;
import org.swift.confluence.cache.util.CacheUtils;
import org.swift.confluence.scriptutil.ScriptUtils;

public class ConfigurePluginAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = 1L;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public String loadTextOption;
    public String retry;
    public String retryInterval;
    public String confirm;
    public String maxEntries;
    public String cacheCapacity;
    protected BandanaManager bandanaManager;
    protected BootstrapManager bootstrapManager = null;
    private PluginLicenseManager licenseManager;
    private final String I18N_PREFIX_KEY = ConfigurePluginAction.class.getPackage().getName();
    private HostLicenseInformation hostLicenseInformation;
    protected static final ConfluenceBandanaContext bandanaContext = new ConfluenceBandanaContext();

    public void setPluginLicenseManager(PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public String getActionName(String fullClassName) {
        return this.getText("org.swift.confluence.cache.configure");
    }

    public String input() {
        return "input";
    }

    public boolean isReadOnly() {
        return ScriptUtils.isReadOnly();
    }

    public String save() throws Exception {
        String result = "success";
        if (ScriptUtils.isReadOnly()) {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".readonly-warning-message"));
            return "error";
        }
        boolean firstTimeFlag = this.checkIfFirstTimeConfigSaving();
        HttpServletRequest request = ServletContextThreadLocal.getRequest();
        this.confirm = request.getParameter("confirm");
        this.log.debug("confirm: {}", (Object)this.confirm);
        if ("true".equals(this.confirm)) {
            if (!this.saveLoadTextOption()) {
                result = "error";
            }
            if (!this.saveRetry()) {
                result = "error";
            }
            if (!this.saveRetryInterval()) {
                result = "error";
            }
            if (!this.saveMaxEntries()) {
                result = "error";
            }
            if (!this.saveCacheCapacity()) {
                result = "error";
            }
            if (result.equals("success")) {
                String message = "Settings saved.";
                this.log.debug("Saving new configurations...");
                CacheAdministrator admin = CacheManagerCurrent.instance().getCacheAdministrator(this.bandanaManager, (BandanaContext)bandanaContext);
                Config config = admin.getConfig();
                config.setCacheCapacity(Long.parseLong(this.cacheCapacity));
                int maxCacheEntries = Integer.parseInt(this.maxEntries);
                long maxConfluenceAllocatedCacheSize = CacheUtils.getConfluenceCacheSize();
                this.log.debug("maxConfluenceAllocatedCacheSize " + maxConfluenceAllocatedCacheSize + "maxCacheEntries " + maxCacheEntries);
                if (maxConfluenceAllocatedCacheSize < (long)maxCacheEntries) {
                    CacheUtils.updateConfluenceCacheSize(maxCacheEntries);
                    message = message + " " + this.getText(this.I18N_PREFIX_KEY + ".maximumnumber-of-entries-hasbeen-increased-to") + maxCacheEntries + ".";
                    config.setMaxEntries(Long.parseLong(this.maxEntries));
                    admin.setConfig(config);
                }
                this.addActionMessage(message);
            }
        } else {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".settings-couldnotsave-loginexpired"));
            result = "error";
        }
        return result;
    }

    public boolean saveLoadTextOption() {
        boolean success = true;
        this.log.debug("saving: {}", (Object)this.loadTextOption);
        try {
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.cache.loadTextOption", (Object)this.loadTextOption);
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unabletostore-loadtext-settings-tryagain"));
            success = false;
        }
        return success;
    }

    @ParameterSafe
    public void setLoadTextOption(String loadTextOption) {
        this.loadTextOption = loadTextOption;
    }

    public String getLoadTextOption() {
        try {
            this.loadTextOption = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.cache.loadTextOption");
        }
        catch (Exception exception) {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unabletoretrive-previous-loadtext-usedefault"));
            this.loadTextOption = null;
        }
        this.log.debug("retrieved load text option: {}", (Object)this.loadTextOption);
        return this.loadTextOption;
    }

    public boolean saveRetry() {
        boolean success = true;
        this.log.debug("saving: {}", (Object)this.retry);
        try {
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.cache.retry", (Object)this.retry);
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unabletostore-retry-tryagain"));
            success = false;
        }
        return success;
    }

    @ParameterSafe
    public void setRetry(String retry) {
        this.retry = retry;
    }

    @ParameterSafe
    public String getRetry() {
        try {
            this.retry = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.cache.retry");
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unabletoretrive-previous-retry-usedefault"));
        }
        if (this.retry == null) {
            this.retry = "off";
        }
        this.log.debug("retrieved retry: {}", (Object)this.retry);
        return this.retry;
    }

    public boolean saveRetryInterval() {
        boolean success = true;
        this.log.debug("saving: {}", (Object)this.retryInterval);
        Integer interval = ScriptUtils.getIntegerOrNull((String)this.retryInterval);
        this.log.debug("Retry Interval " + interval);
        try {
            if (!StringUtils.isBlank((CharSequence)this.retryInterval) && Integer.parseInt(this.retryInterval) >= Constants.DEFAULT_RETRY_INTERVAL) {
                if (StringUtils.isNumeric((CharSequence)this.retryInterval)) {
                    this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.cache.retryInterval", (Object)this.retryInterval);
                } else {
                    this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".retryinteval-please-enter-valid-integer"));
                    success = false;
                }
            } else {
                this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".retryinteval-mustbe-15-orgreater"));
                success = false;
            }
        }
        catch (NumberFormatException exception) {
            this.log.error(exception.getMessage());
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".retryinterval-mustbe-positive-number"));
            success = false;
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unabletostore-retryinterval-tryagain"));
            success = false;
        }
        return success;
    }

    @ParameterSafe
    public void setRetryInterval(String retryInterval) {
        this.retryInterval = retryInterval;
    }

    @ParameterSafe
    public String getRetryInterval() {
        try {
            this.retryInterval = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.cache.retryInterval");
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unabletoretrive-previous-retryinterval-usedefault"));
        }
        if (this.retryInterval == null) {
            this.retryInterval = Constants.DEFAULT_RETRY_INTERVAL.toString();
        }
        this.log.debug("retrieved retry interval: {}", (Object)this.retryInterval);
        return this.retryInterval;
    }

    public boolean saveMaxEntries() {
        boolean success = true;
        this.log.debug("saving: {}", (Object)this.maxEntries);
        try {
            if (!StringUtils.isBlank((CharSequence)this.maxEntries) && Integer.parseInt(this.maxEntries) >= Constants.DEFAULT_MAX_ENTRIES) {
                if (StringUtils.isNumeric((CharSequence)this.maxEntries)) {
                    CacheUtils.updateMaxEntriesConfiguration(this.bandanaManager, Integer.parseInt(this.maxEntries));
                } else {
                    this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".maxentries-please-enter-valid-integer"));
                    success = false;
                }
            } else {
                this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".number-mustbe-1000-orgreater"));
                success = false;
            }
        }
        catch (NumberFormatException exception) {
            this.log.error(exception.getMessage());
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".maximum-mustbe-positive-number"));
            success = false;
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".cannot-store-maxentries-tryagain"));
            success = false;
        }
        return success;
    }

    @ParameterSafe
    public void setMaxEntries(String entries) {
        this.maxEntries = entries;
    }

    @ParameterSafe
    public String getMaxEntries() {
        try {
            this.maxEntries = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.cache.maxEntries");
        }
        catch (Exception exception) {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unableto-retrieve-previous-maxentries-usedefault"));
        }
        if (this.maxEntries == null) {
            this.maxEntries = Constants.DEFAULT_MAX_ENTRIES.toString();
        }
        this.log.debug("retrieved maxEntries: {}", (Object)this.maxEntries);
        return this.maxEntries;
    }

    public boolean saveCacheCapacity() {
        boolean success = true;
        this.log.debug("saving: {}", (Object)this.cacheCapacity);
        try {
            Long cacheCapacityInput = Long.valueOf(this.cacheCapacity);
            if (!StringUtils.isBlank((CharSequence)this.cacheCapacity) && cacheCapacityInput >= (long)Constants.DEFAULT_CACHE_CAPACITY.intValue()) {
                if (StringUtils.isNumeric((CharSequence)this.cacheCapacity)) {
                    this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.cache.cacheCapacity", (Object)this.cacheCapacity);
                } else {
                    this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".cachecapacity-please-enter-valid-integer"));
                    success = false;
                }
            } else {
                this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".cachesize-mustbe-100mb-greater"));
                success = false;
            }
        }
        catch (NumberFormatException exception) {
            this.log.error(exception.getMessage());
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".maxcachesize-mustbe-positive-number"));
            success = false;
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".cannot-store-maxcachesize-tryagain"));
            success = false;
        }
        return success;
    }

    @ParameterSafe
    public void setCacheCapacity(String cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    @ParameterSafe
    public String getCacheCapacity() {
        try {
            this.cacheCapacity = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.cache.cacheCapacity");
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unableto-retrieve-previous-cachecapacity-usedefault"));
        }
        if (this.cacheCapacity == null) {
            this.cacheCapacity = Constants.DEFAULT_CACHE_CAPACITY.toString();
        }
        this.log.debug("retrieved cacheCapacity: {}", (Object)this.cacheCapacity);
        return this.cacheCapacity;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public boolean checkIfFirstTimeConfigSaving() {
        boolean firstTimeFlag = false;
        try {
            ConfluenceBandanaContext banadanContext = new ConfluenceBandanaContext();
            String checkMaxEntries = (String)this.bandanaManager.getValue((BandanaContext)banadanContext, "org.swift.confluence.cache.maxEntries");
            String checkRetry = (String)this.bandanaManager.getValue((BandanaContext)banadanContext, "org.swift.confluence.cache.retry");
            String checkRetryInterval = (String)this.bandanaManager.getValue((BandanaContext)banadanContext, "org.swift.confluence.cache.retryInterval");
            String checkLoadTextOption = (String)this.bandanaManager.getValue((BandanaContext)banadanContext, "org.swift.confluence.cache.loadTextOption");
            String checkCacheCapacity = (String)this.bandanaManager.getValue((BandanaContext)banadanContext, "org.swift.confluence.cache.cacheCapacity");
            if (checkMaxEntries == null && checkRetry == null && checkRetryInterval == null && checkLoadTextOption == null && checkCacheCapacity == null) {
                firstTimeFlag = true;
            }
        }
        catch (Exception e) {
            firstTimeFlag = true;
        }
        return firstTimeFlag;
    }

    public String expireCache() throws Exception {
        try {
            DefaultCacheAdministrator administrator = DefaultCacheAdministrator.getCacheAdministrator();
            CacheManagerCurrent admin = CacheManagerCurrent.instance();
            administrator = admin.getCacheAdministrator(this.bandanaManager, (BandanaContext)bandanaContext);
            if (administrator != null) {
                administrator.flushAll();
                this.addActionMessage(this.getText(this.I18N_PREFIX_KEY + ".expired-cache-for-all-macros"));
                this.log.debug("Removed Cache for all macros ");
                return "success";
            }
        }
        catch (Exception e) {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".problem-trying-to-expire-cache"));
            this.log.error("Error while expiring the cache: {}", (Throwable)e);
            return "error";
        }
        return "error";
    }

    public void setHostLicenseInformation(HostLicenseInformation hostLicenseInformation) {
        this.hostLicenseInformation = hostLicenseInformation;
    }
}

