/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import org.apache.commons.lang.StringUtils;
import org.swift.confluence.cache.Constants;
import org.swift.confluence.cache.library.admin.CacheAdministrator;
import org.swift.confluence.cache.library.admin.DefaultCacheAdministrator;
import org.swift.confluence.cache.library.bean.Config;

public class CacheManagerCurrent {
    private static CacheAdministrator admin;
    private static CacheManagerCurrent instance;

    private CacheManagerCurrent() {
    }

    public static CacheManagerCurrent instance() {
        if (instance == null) {
            instance = new CacheManagerCurrent();
        }
        return instance;
    }

    public CacheAdministrator getCacheAdministrator(BandanaManager bandanaManager, BandanaContext bandanaContext) {
        admin = DefaultCacheAdministrator.getCacheAdministrator();
        if (admin == null) {
            Config config = new Config();
            config.setCacheKey("org.swift.confluence.cache_cache");
            config.setCacheCapacity((long)this.getCacheCapacity(bandanaManager, bandanaContext).intValue());
            config.setMaxEntries((long)this.getMaxEntries(bandanaManager, bandanaContext).intValue());
            admin = DefaultCacheAdministrator.getInstance((Config)config);
        }
        return admin;
    }

    protected Integer getMaxEntries(BandanaManager bandanaManager, BandanaContext bandanaContext) {
        String maxEntries = (String)bandanaManager.getValue(bandanaContext, "org.swift.confluence.cache.maxEntries");
        if (!StringUtils.isBlank((String)maxEntries)) {
            return Integer.valueOf(maxEntries);
        }
        return Constants.DEFAULT_MAX_ENTRIES;
    }

    protected Integer getCacheCapacity(BandanaManager bandanaManager, BandanaContext bandanaContext) {
        String cacheCapacity = (String)bandanaManager.getValue(bandanaContext, "org.swift.confluence.cache.cacheCapacity");
        if (!StringUtils.isBlank((String)cacheCapacity)) {
            return Integer.valueOf(cacheCapacity);
        }
        return Constants.DEFAULT_CACHE_CAPACITY;
    }

    static {
        instance = null;
    }
}

