/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.util.Collection;
import java.util.Map;
import org.swift.confluence.cache.AtlassianCacheSupport;
import org.swift.confluence.cache.CacheMacroSupport;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.scriptutil.ScriptUtils;

public class CacheMacro
extends CacheMacroSupport {
    private final BandanaManager bandanaManager;
    private final UserAccessor userAccessor;
    protected final FormatSettingsManager formatSettingsManager;

    public CacheMacro(SettingsManager settingsManager, BootstrapManager bootstrapManager, PageTemplateManager templateManager, SpaceManager spaceManager, PageManager pageManager, PermissionManager permissionManager, AttachmentManager attachmentManager, LocaleManager localeManager, FormatSettingsManager formatSettingsManager, I18NBeanFactory i18NBeanFactory, PluginLicenseManager licenseManager, XhtmlContent xhtmlContent, BandanaManager bandanaManager, UserAccessor userAccessor, SubRenderer subRenderer, ConfluenceIndexer confluenceIndexer) {
        super(settingsManager, bootstrapManager, templateManager, spaceManager, pageManager, permissionManager, attachmentManager, localeManager, i18NBeanFactory, licenseManager, xhtmlContent, subRenderer, confluenceIndexer);
        this.bandanaManager = bandanaManager;
        this.userAccessor = userAccessor;
        this.formatSettingsManager = formatSettingsManager;
    }

    protected String getMacroName() {
        return "cache";
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    @RequiresFormat(value=Format.Storage)
    public String execute(Map<String, String> params, String body, ConversionContext context) throws MacroExecutionException {
        return super.execute(params, ScriptUtils.stripFirstParagraphTags((String)body), context);
    }

    public String execute(MacroInfo info) throws MacroExecutionException {
        this.validateLicense(this.licenseManager);
        try {
            long startTime = System.currentTimeMillis();
            String renderedContent = null;
            AtlassianCacheSupport atlCache = new AtlassianCacheSupport(this, this.formatSettingsManager, this.bandanaManager, this.userAccessor, this.attachmentManager, this.subRenderer, this.confluenceIndexer, this.settingsManager, this.bootstrapManager);
            atlCache.initialize(info);
            renderedContent = atlCache.process(info);
            this.log.debug("Total elapsed time: {} ms", (Object)(System.currentTimeMillis() - startTime));
            return renderedContent;
        }
        catch (MacroExecutionException exception) {
            throw exception;
        }
        catch (Exception exception) {
            this.log.error(info.getMacroBody(), (Throwable)exception);
            throw new MacroExecutionException("Unexpected program error: " + exception.toString());
        }
    }

    protected void logDebugSet(String text, Collection<String> collection) {
        if (collection != null && this.log.isDebugEnabled()) {
            for (String string : collection) {
                this.log.debug(text + ": {}", (Object)string);
            }
        }
    }

    protected String render(MacroInfo info) throws MacroExecutionException {
        return this.render(info, info.getMacroBody(), this.isLegacy(info));
    }
}

