/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.v2.SubRenderer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.cache.CacheMacro;
import org.swift.confluence.macrosecurity.utils.MacroSecurityUtils;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.macroutil.RequestAttributeStorage;
import org.swift.confluence.scriptutil.DateHelper;
import org.swift.confluence.scriptutil.ScriptUtils;

public class BaseSupport {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_REFRESH = (int)TimeUnit.DAYS.toSeconds(1L);
    protected CacheMacro macro;
    protected final BandanaManager bandanaManager;
    protected final UserAccessor userAccessor;
    protected final FormatSettingsManager formatSettingsManager;
    protected final AttachmentManager attachmentManager;
    protected final ConfluenceIndexer confluenceIndexer;
    protected final SubRenderer subRenderer;
    protected final SettingsManager settingsManager;
    protected PageContext pageContext;
    protected int refreshPeriod;
    protected ContentEntityObject content;
    protected boolean showDate;
    protected boolean index;
    protected boolean checkAttachments;
    protected boolean failover;
    protected String cronExpression;
    protected String dateFormat;
    protected String id;
    protected String anchor;
    protected List<Attachment> attachmentList;
    protected long newChecksum;

    public BaseSupport(CacheMacro macro, FormatSettingsManager formatSettingsManager, BandanaManager bandanaManager, UserAccessor userAccessor, AttachmentManager attachmentManager, SubRenderer subRenderer, ConfluenceIndexer confluenceIndexer, SettingsManager settingsManager) {
        this.macro = macro;
        this.bandanaManager = bandanaManager;
        this.userAccessor = userAccessor;
        this.formatSettingsManager = formatSettingsManager;
        this.attachmentManager = attachmentManager;
        this.subRenderer = subRenderer;
        this.confluenceIndexer = confluenceIndexer;
        this.settingsManager = settingsManager;
    }

    public void initialize(MacroInfo info) throws Exception {
        String spaceKey;
        MacroSecurityUtils.securityCheck((BandanaManager)this.bandanaManager, (UserAccessor)this.userAccessor, (String)this.macro.getMacroName(), (MacroInfo)info);
        this.pageContext = info.getConversionContext().getPageContext();
        this.refreshPeriod = this.getRefreshPeriod(info);
        this.content = info.getContent();
        this.showDate = ScriptUtils.getBoolean((String)"showDate", (boolean)false, (MacroInfo)info);
        this.index = this.content != null && ScriptUtils.getBoolean((String)"index", (boolean)false, (MacroInfo)info) && info.getConversionContext().getOutputType().equals(ConversionContextOutputType.DISPLAY.value());
        this.checkAttachments = ScriptUtils.getBoolean((String)"checkattachments", (boolean)true, (MacroInfo)info);
        this.failover = ScriptUtils.getBoolean((String)"failover", (boolean)true, (MacroInfo)info);
        this.cronExpression = info.getMacroParams().getString("cron", null);
        this.dateFormat = info.getMacroParams().getString("dateFormat", "");
        this.id = info.getMacroParams().getString("id", null);
        this.anchor = info.getMacroParams().getString("anchor", "").trim();
        this.attachmentList = !this.checkAttachments || this.content == null ? null : this.attachmentManager.getLatestVersionsOfAttachments(this.content);
        this.newChecksum = this.getChecksum(info, this.attachmentList);
        if (this.id == null) {
            Integer uniqueId = this.getUniqueId(this.getClass().getName(), info);
            this.id = String.valueOf(uniqueId == null ? this.newChecksum : new Long(uniqueId.intValue()));
        }
        if ((spaceKey = this.pageContext.getSpaceKey()) == null) {
            spaceKey = "_DASHBOARD_";
            this.index = false;
        }
    }

    protected Integer getUniqueId(String key, MacroInfo info) throws Exception {
        Integer id = null;
        try {
            RequestAttributeStorage storage = info.getRequestAttributes();
            if (storage != null) {
                id = storage.getInteger(key, Integer.valueOf(0)) + 1;
                storage.setInteger(key, id);
            }
        }
        catch (Exception exception) {
            this.log.debug("Problem getting unique id - ignore. Problem with underlying api.", (Throwable)exception);
        }
        return id;
    }

    protected String getRefreshLink(MacroInfo info, String id, String anchor) {
        boolean showRefresh = ScriptUtils.getBoolean((String)"showRefresh", (boolean)false, (MacroInfo)info);
        String refreshLink = "";
        if (info.getContent() != null && showRefresh) {
            String title = info.getMacroParams().getString("title", this.macro.getText("org.swift.confluence.cache.refresh"));
            String anchorString = anchor.equals("") ? "" : "#" + ScriptUtils.generateAnchor((PageContext)info.getConversionContext().getPageContext(), (String)anchor);
            this.log.debug("anchor string: {}, from anchor: {}", (Object)anchorString, (Object)anchor);
            Map contextMap = MacroUtils.defaultVelocityContext();
            contextMap.put("id", id);
            contextMap.put("title", GeneralUtil.htmlEncode((String)title));
            contextMap.put("anchor", anchorString);
            contextMap.put("urlPath", info.getContent().getUrlPath());
            try {
                refreshLink = VelocityUtils.getRenderedTemplate((String)"html/cachemacro.vm", (Map)contextMap);
            }
            catch (Exception exception) {
                this.log.debug("Error while trying to display refresh icon", (Throwable)exception);
            }
        }
        return refreshLink;
    }

    private int getRefreshPeriod(MacroInfo info) {
        int refreshPeriod;
        String refresh = info.getMacroParams().getString("refresh", "");
        if (refresh.equalsIgnoreCase("true")) {
            refresh = "0";
        }
        this.log.debug("refresh: {}", (Object)refresh);
        char[] timeChars = new char[]{'s', 'm', 'h', 'd'};
        int findAt = StringUtils.indexOfAny((String)refresh, (char[])timeChars);
        String value = findAt < 0 ? refresh : refresh.substring(0, findAt);
        try {
            refreshPeriod = Integer.parseInt(value.trim());
        }
        catch (NumberFormatException ignore) {
            refreshPeriod = DEFAULT_REFRESH;
        }
        if (findAt >= 0 && refresh.charAt(findAt) != 's') {
            refreshPeriod *= 60;
            if (refresh.charAt(findAt) != 'm') {
                refreshPeriod *= 60;
                if (refresh.charAt(findAt) != 'h') {
                    refreshPeriod *= 24;
                }
            }
        }
        this.log.debug("Refresh period: {} in seconds: {}", (Object)refresh, (Object)refreshPeriod);
        return refreshPeriod;
    }

    protected long getChecksum(MacroInfo info, List<Attachment> attachmentList) {
        CRC32 crc = new CRC32();
        String macroBody = info.getMacroBody().trim();
        macroBody = this.ignoreMacroIds(macroBody);
        crc.update(macroBody.getBytes());
        if (attachmentList != null && attachmentList.size() > 0) {
            StringBuilder attachmentCheck = new StringBuilder();
            for (Attachment attachment : attachmentList) {
                attachmentCheck.append(attachment.getFileName()).append("_v").append(attachment.getVersion()).append("_").append(attachment.getLastModificationDate().getTime()).append("_");
            }
            crc.update(attachmentCheck.toString().getBytes());
        }
        this.log.debug("crcValue: {}", (Object)crc.getValue());
        return crc.getValue();
    }

    private String ignoreMacroIds(String macroBody) {
        macroBody = macroBody.replaceAll("ac:macro-id=\"\\S*\"", "ac:macro-id=\"\"");
        return macroBody;
    }

    protected String getDateString(String dateRendered, String dateFormat) throws MacroExecutionException {
        String result = "";
        DateHelper dateHelper = new DateHelper(this.settingsManager, this.formatSettingsManager, this.userAccessor);
        if (dateRendered != null) {
            try {
                result = dateHelper.formatDate(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH).parse(dateRendered), dateHelper.getDateFormatWithCheck(dateFormat));
            }
            catch (ParseException exception) {
                this.log.debug("Exception parsing rendered date: {}", (Object)dateRendered, (Object)exception.toString());
                result = dateRendered;
            }
        }
        return GeneralUtil.htmlEncode((String)result);
    }

    protected boolean getRetryParameter(MacroInfo info) throws MacroExecutionException {
        boolean result;
        String retryString = info.getMacroParams().getString("retry", null);
        if (retryString == null || retryString.equalsIgnoreCase("@default")) {
            result = this.getDefaultRetry();
            this.log.debug("default retry: {}", (Object)result);
        } else {
            result = "on".equalsIgnoreCase(retryString);
        }
        return result;
    }

    protected boolean getDefaultRetry() {
        String value = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.cache.retry");
        return "on".equalsIgnoreCase(value);
    }

    public boolean isRequestRefreshable(String outputType) {
        return !ConversionContextOutputType.PDF.value().equals(outputType) && !ConversionContextOutputType.HTML_EXPORT.value().equals(outputType) && !ConversionContextOutputType.WORD.value().equals(outputType);
    }
}

