/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache.util;

import com.appfire.common.analytics.util.AnalyticEvent;
import com.appfire.common.analytics.util.AnalyticsHelper;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.cache.bean.CacheParamBean;
import org.swift.confluence.cache.bean.FutureParamBean;
import org.swift.confluence.cache.bean.GlobalConfigBean;
import org.swift.confluence.scriptutil.ScriptUtils;

public class CacheAnalyticsHelper {
    private static final Logger log = LoggerFactory.getLogger(CacheAnalyticsHelper.class);
    private AnalyticsHelper analyticsHelper = null;

    public CacheAnalyticsHelper(AnalyticsHelper analyticsHelper) {
        this.analyticsHelper = analyticsHelper;
    }

    public CacheAnalyticsHelper(PluginLicenseManager licenseManager, HostLicenseInformation hostLicenseInformation) {
        this(new AnalyticsHelper(ScriptUtils.getHostInfo((HostLicenseInformation)hostLicenseInformation), ScriptUtils.getPluginInfo((PluginLicenseManager)licenseManager), ScriptUtils.getClientInfo(), CacheAnalyticsHelper.class.getClassLoader()));
    }

    public void postAnalyticsEvent(AnalyticEvent.Event collectionName, String type) {
        try {
            if (collectionName != null) {
                HashMap<String, String> analyticsEventDataMap = new HashMap<String, String>();
                analyticsEventDataMap.put("type", type == null ? collectionName.getEvent() : type);
                this.analyticsHelper.postAnalyticsEvent(collectionName.getEvent(), analyticsEventDataMap);
            }
        }
        catch (Throwable e) {
            log.debug("Error while posting " + collectionName.getEvent() + " event analytics ", e);
        }
    }

    public void postGlobalConfigAnalyticsEvent(GlobalConfigBean configBean) {
        try {
            if (configBean != null) {
                HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
                analyticsEventDataMap.put("type", AnalyticEvent.Event.GLOBALCONFIG.getEvent());
                analyticsEventDataMap.put("settings", configBean);
                this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.GLOBALCONFIG.getEvent(), analyticsEventDataMap);
            }
        }
        catch (Throwable e) {
            log.debug("Error while posting globalconfig event analytics", e);
        }
    }

    public void postNewMacroAnalytics(String macroName, Map<String, String> parameters) {
        if (parameters != null) {
            HashMap<String, String> paramMap = new HashMap<String, String>(parameters);
            HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
            analyticsEventDataMap.put("type", AnalyticEvent.SubEvent.NEWMACRO.getEvent());
            analyticsEventDataMap.put("macroName", macroName);
            analyticsEventDataMap.put("macroParams", paramMap);
            this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.MACRO.getEvent(), analyticsEventDataMap);
        }
    }

    public void postInstallUninstallEvent(AnalyticEvent.Event eventType) {
        this.postAnalyticsEvent(eventType, null);
    }

    public void postErrorEvent(String errorMessage) {
        try {
            HashMap<String, String> analyticsEventDataMap = new HashMap<String, String>();
            analyticsEventDataMap.put("type", AnalyticEvent.Event.ERROR.getEvent());
            analyticsEventDataMap.put("error", errorMessage);
            this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.ERROR.getEvent(), analyticsEventDataMap);
        }
        catch (Throwable e) {
            log.debug("Error while posting " + AnalyticEvent.Event.ERROR.getEvent() + " event analytics ", e);
        }
    }

    public Map<String, Object> convertToMap(Object bean) {
        ObjectMapper m = new ObjectMapper();
        Map beanMap = null;
        beanMap = (Map)m.convertValue(bean, Map.class);
        this.adjustDateFields(bean, beanMap);
        return beanMap;
    }

    private void adjustDateFields(Object bean, Map<String, Object> beanMap) {
        if (beanMap != null) {
            if (bean instanceof CacheParamBean) {
                if (((CacheParamBean)bean).getConfigUpdated() != null) {
                    beanMap.put("configUpdated", new Date(((CacheParamBean)bean).getConfigUpdated().getTime()));
                }
            } else if (bean instanceof FutureParamBean && ((FutureParamBean)bean).getConfigUpdated() != null) {
                beanMap.put("configUpdated", new Date(((FutureParamBean)bean).getConfigUpdated().getTime()));
            }
        }
    }
}

