/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache.listener;

import com.appfire.common.analytics.util.AnalyticEvent;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.event.PluginLicenseAddedEvent;
import com.atlassian.upm.api.license.event.PluginLicenseUpdatedEvent;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.atlassian.upm.datacentercompatibility.impl.CompatibilityHostLicenseInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.swift.confluence.cache.util.CacheAnalyticsHelper;

public class CacheAnalyticsListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(CacheAnalyticsListener.class);
    private final EventPublisher eventPublisher;
    protected final PluginLicenseManager licenseManager;
    protected BandanaManager bandanaManager;
    private final XhtmlContent xhtmlManager;
    private final HostLicenseInformation hostLicenseInformation;
    private final PluginLicenseEventRegistry pluginLicenseEventRegistry;
    private final CacheAnalyticsHelper cacheAnalyticsHelper;

    public CacheAnalyticsListener(EventPublisher eventPublisher, PluginLicenseManager licenseManager, BandanaManager bandanaManager, XhtmlContent xhtmlManager, com.atlassian.upm.api.license.HostLicenseInformation upmHostLicenseInformation, LicenseHandler licenseHandler, PluginLicenseEventRegistry pluginLicenseEventRegistry) {
        this.eventPublisher = eventPublisher;
        this.eventPublisher.register((Object)this);
        this.licenseManager = licenseManager;
        this.bandanaManager = bandanaManager;
        this.xhtmlManager = xhtmlManager;
        this.pluginLicenseEventRegistry = pluginLicenseEventRegistry;
        this.pluginLicenseEventRegistry.register((Object)this);
        this.hostLicenseInformation = new CompatibilityHostLicenseInformation(upmHostLicenseInformation, licenseHandler);
        this.cacheAnalyticsHelper = new CacheAnalyticsHelper(licenseManager, this.hostLicenseInformation);
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        Plugin thisPlugin = event.getPlugin();
        try {
            if (thisPlugin.getKey().equalsIgnoreCase("org.swift.confluence.cache")) {
                this.cacheAnalyticsHelper.postInstallUninstallEvent(AnalyticEvent.Event.INSTALL);
            }
        }
        catch (Exception e) {
            log.error("Error in Analytics Listener : {}", (Object)e.getMessage());
        }
    }

    @EventListener
    public void onPageCreateEvent(PageCreateEvent e) {
        if (this.getSendStatistics().equalsIgnoreCase("on")) {
            try {
                this.xhtmlManager.handleMacroDefinitions(e.getPage().getBodyAsString(), (ConversionContext)new DefaultConversionContext(new RenderContext()), new MacroDefinitionHandler(){

                    public void handle(MacroDefinition macroDefinition) {
                        String macroName = macroDefinition.getName();
                        if ("cache".equals(macroName) || "future".equals(macroName)) {
                            CacheAnalyticsListener.this.cacheAnalyticsHelper.postNewMacroAnalytics(macroDefinition.getName(), macroDefinition.getParameters());
                        }
                    }
                });
            }
            catch (XhtmlException ex) {
                log.error("XHTML Exception Keen IO for Create Event : {}", (Object)ex.getMessage());
            }
        }
    }

    public void destroy() throws Exception {
        this.cacheAnalyticsHelper.postInstallUninstallEvent(AnalyticEvent.Event.UNINSTALL);
        log.info("destroy called");
        this.eventPublisher.unregister((Object)this);
        this.pluginLicenseEventRegistry.unregister((Object)this);
    }

    @EventListener
    public void onEvent(PluginLicenseAddedEvent event) {
        this.cacheAnalyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.LICENSED, AnalyticEvent.SubEvent.LICENSEADDED.getEvent());
    }

    @EventListener
    public void onEvent(PluginLicenseUpdatedEvent event) {
        this.cacheAnalyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.LICENSED, AnalyticEvent.SubEvent.LICENSEUPDATED.getEvent());
    }

    public void afterPropertiesSet() throws Exception {
    }

    private String getSendStatistics() {
        String sendStatistics = null;
        try {
            sendStatistics = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.cache.sendStatistics");
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
        }
        if (sendStatistics == null) {
            sendStatistics = "on";
        }
        log.debug("retrieved sendStatistics: {}", (Object)sendStatistics);
        return sendStatistics;
    }
}

