/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache.listener;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.atlassian.upm.datacentercompatibility.impl.CompatibilityHostLicenseInformation;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.cache.bean.GlobalConfigBean;
import org.swift.confluence.cache.util.CacheAnalyticsHelper;

public class AnalyticsUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsUpgradeTask.class);
    private final PluginAccessor pluginAccessor;
    private final PluginLicenseManager licenseManager;
    private final BandanaManager bandanaManager;
    private final HostLicenseInformation hostLicenseInformation;

    public AnalyticsUpgradeTask(PluginLicenseManager licenseManager, BandanaManager bandanaManager, PluginAccessor pluginAccessor, com.atlassian.upm.api.license.HostLicenseInformation upmHostLicenseInformation, LicenseHandler licenseHandler) {
        this.licenseManager = licenseManager;
        this.bandanaManager = bandanaManager;
        this.pluginAccessor = pluginAccessor;
        this.hostLicenseInformation = new CompatibilityHostLicenseInformation(upmHostLicenseInformation, licenseHandler);
    }

    public int getBuildNumber() {
        int buildNumber = Integer.parseInt((String)this.pluginAccessor.getPlugin("org.swift.confluence.cache").getPluginInformation().getParameters().get("build"));
        return buildNumber;
    }

    public String getShortDescription() {
        return null;
    }

    public Collection<Message> doUpgrade() throws Exception {
        CacheAnalyticsHelper helper = new CacheAnalyticsHelper(this.licenseManager, this.hostLicenseInformation);
        GlobalConfigBean configBean = this.buildConfigBean();
        if (configBean != null) {
            helper.postGlobalConfigAnalyticsEvent(configBean);
        }
        return null;
    }

    public String getPluginKey() {
        return "org.swift.confluence.cache";
    }

    private GlobalConfigBean buildConfigBean() {
        log.debug("building config bean");
        GlobalConfigBean configBean = new GlobalConfigBean();
        ConfluenceBandanaContext bandanaContext = new ConfluenceBandanaContext();
        String maxEntries = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.cache.maxEntries");
        String retry = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.cache.retry");
        String retryInterval = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.cache.retryInterval");
        String loadTextOption = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.cache.loadTextOption");
        String cacheCapacity = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.cache.cacheCapacity");
        if (maxEntries == null && retry == null && retryInterval == null && loadTextOption == null && cacheCapacity == null) {
            return null;
        }
        configBean.setRetry(retry);
        configBean.setRetryInterval(retryInterval);
        configBean.setCacheCapacity(cacheCapacity);
        configBean.setLoadTextOption(loadTextOption);
        configBean.setMaxEntries(maxEntries);
        return configBean;
    }
}

