/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.scriptutil.ScriptUtils;

public class WrappedRenderer {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final XhtmlContent xhtmlContent;
    protected final SubRenderer subRenderer;
    protected final TransactionTemplate transactionTemplate;
    protected MacroExecutionException savedException = null;
    protected final ConversionContext conversionContext;

    WrappedRenderer(ConversionContext conversionContext, XhtmlContent xhtmlContent, SubRenderer subRenderer, TransactionTemplate transactionTemplate) {
        this.conversionContext = conversionContext;
        this.xhtmlContent = xhtmlContent;
        this.subRenderer = subRenderer;
        this.transactionTemplate = transactionTemplate;
    }

    protected String render(final ContentEntityObject ceo, final String content, final String requestParameters, final String avoidUserCheck, final boolean isLegacy) throws MacroExecutionException {
        String result = (String)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<String>(){

            public String doInTransaction() {
                try {
                    if (isLegacy) {
                        return ScriptUtils.renderLegacy((SubRenderer)WrappedRenderer.this.subRenderer, (PageContext)ceo.toPageContext(), (String)content);
                    }
                    WrappedRenderer.this.conversionContext.setProperty("org.swift.confluence.cache.request_parameters", (Object)requestParameters);
                    WrappedRenderer.this.conversionContext.setProperty("org.swift.confluence.macrosecurity.avoid_user_check", (Object)avoidUserCheck);
                    return ScriptUtils.render((XhtmlContent)WrappedRenderer.this.xhtmlContent, (ConversionContext)WrappedRenderer.this.conversionContext, (String)content);
                }
                catch (MacroExecutionException exception) {
                    WrappedRenderer.this.savedException = exception;
                    return null;
                }
            }
        });
        if (this.savedException != null) {
            throw this.savedException;
        }
        return result;
    }
}

