/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.cache;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.TextExtractor;
import org.swift.confluence.cache.CacheMacroSupport;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.scriptutil.ScriptUtils;

public class TextExtractorMacro
extends CacheMacroSupport {
    public TextExtractorMacro(SettingsManager settingsManager, BootstrapManager bootstrapManager, PageTemplateManager templateManager, SpaceManager spaceManager, PageManager pageManager, PermissionManager permissionManager, AttachmentManager attachmentManager, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, PluginLicenseManager licenseManager, XhtmlContent xhtmlContent, SubRenderer subRenderer, ConfluenceIndexer confluenceIndexer) {
        super(settingsManager, bootstrapManager, templateManager, spaceManager, pageManager, permissionManager, attachmentManager, localeManager, i18NBeanFactory, licenseManager, xhtmlContent, subRenderer, confluenceIndexer);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public String execute(MacroInfo info) throws MacroExecutionException {
        this.validateLicense(this.licenseManager);
        boolean attributes = ScriptUtils.getBoolean((String)"attributes", (boolean)true, (MacroInfo)info);
        boolean compress = ScriptUtils.getBoolean((String)"compress", (boolean)false, (MacroInfo)info);
        String text = "";
        try {
            Source source = new Source((CharSequence)info.getMacroBody());
            TextExtractor textExtractor = new TextExtractor((Segment)source);
            textExtractor.setIncludeAttributes(attributes);
            text = textExtractor.toString();
            String input = info.getMacroBody();
            this.log.debug("input length: {}, input: {}", (Object)input.length(), (Object)input.substring(0, input.length() > 80 ? 80 : input.length()));
            this.log.debug("text length: {}, text: {}", (Object)text.length(), (Object)text.substring(0, text.length() > 80 ? 80 : text.length()));
            if (compress) {
                text = this.words(this.words(text));
            }
        }
        catch (Exception exception) {
            this.log.error(info.getMacroBody(), (Throwable)exception);
            throw new MacroExecutionException("Unexpected program error: " + exception.toString());
        }
        return GeneralUtil.htmlEncode((String)text);
    }

    protected Set<String> words(String string) {
        LinkedHashSet<String> words = new LinkedHashSet<String>(string.length() / 5);
        StringTokenizer parser = new StringTokenizer(string);
        while (parser.hasMoreTokens()) {
            words.add(parser.nextToken());
        }
        return words;
    }

    protected String words(Set<String> words) {
        StringBuilder output = new StringBuilder(words.size() * 6);
        for (String word : words) {
            output.append(word).append(" ");
        }
        return output.toString();
    }
}

