/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.utils;

import com.atlassian.renderer.v2.macro.MacroException;
import java.util.List;
import org.andya.confluence.utils.Duration;

public class MathUtils {
    public static Number parseNumber(String value) {
        Duration duration = Duration.parseDuration(value);
        if (duration != null) {
            return duration;
        }
        try {
            value = value.replaceAll("[^0-9\\.-]", "");
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
    }

    public static String toString(Number number) {
        if (number instanceof Duration) {
            return ((Duration)number).getDurationString();
        }
        if (number instanceof Integer) {
            return Integer.toString(number.intValue());
        }
        return Double.toString(number.doubleValue());
    }

    public static Number doCalculation(String function, List<Number> values) throws MacroException {
        return switch (function = function.trim().toLowerCase()) {
            case "sum" -> MathUtils.sum(values);
            case "avg", "average" -> MathUtils.average(values);
            case "min", "minimum" -> MathUtils.min(values);
            case "max", "maximum" -> MathUtils.max(values);
            default -> throw new MacroException("Unknown function \"" + function + "\"");
        };
    }

    public static Number sum(List<Number> values) {
        double sum = 0.0;
        boolean integerOnly = true;
        boolean duration = false;
        for (Number number : values) {
            if (number instanceof Double) {
                integerOnly = false;
            } else if (number instanceof Duration) {
                duration = true;
            }
            sum += number.doubleValue();
        }
        if (duration) {
            return new Duration((long)sum);
        }
        if (integerOnly) {
            return (int)sum;
        }
        return sum;
    }

    public static Number average(List<Number> values) {
        Number total = MathUtils.sum(values);
        double average = total.doubleValue() / (double)values.size();
        if (total instanceof Duration) {
            return new Duration((long)average);
        }
        return average;
    }

    public static Number min(List<Number> values) {
        double min = Double.MAX_VALUE;
        boolean integerOnly = true;
        boolean duration = false;
        for (Number number : values) {
            if (number instanceof Duration) {
                duration = true;
            } else if (number instanceof Double) {
                integerOnly = false;
            }
            min = Math.min(min, number.doubleValue());
        }
        if (duration) {
            return new Duration((long)min);
        }
        if (integerOnly) {
            return (int)min;
        }
        return min;
    }

    public static Number max(List<Number> values) {
        double max = Double.MIN_VALUE;
        boolean integerOnly = true;
        boolean duration = false;
        for (Number number : values) {
            if (number instanceof Duration) {
                duration = true;
            } else if (number instanceof Double) {
                integerOnly = false;
            }
            max = Math.max(max, number.doubleValue());
        }
        if (duration) {
            return new Duration((long)max);
        }
        if (integerOnly) {
            return (int)max;
        }
        return max;
    }
}

