/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.space;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import lombok.Generated;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.content.ComalaPropertiesManager;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.utils.ContentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpaceUtils.class);
    public static final String PARENT_SPACE_METADATA_NAME = "Parent";
    public static final String USERS_SPACE_METADATA_NAME = "UsersSpace";

    public static User getPersonalSpaceOwner(UserManager userManager, Space space) {
        if (!space.isPersonal()) {
            return null;
        }
        String userName = space.getCreator() != null ? space.getCreator().getName() : null;
        try {
            return userManager.getUser(userName);
        }
        catch (EntityException e) {
            return null;
        }
    }

    public static Space getParentSpace(ContentService contentService, Space space) {
        SpaceDescription description = space.getDescription();
        if (description == null) {
            log.warn("There is no space description for the space {}", (Object)space.getKey());
            return null;
        }
        MetadataValue parentKey = MetadataUtils.getRawMetadataValue(contentService, (ContentEntityObject)description, PARENT_SPACE_METADATA_NAME, null);
        SpaceManager spaceManager = contentService.getSpaceManager();
        return parentKey != null ? spaceManager.getSpace(parentKey.getWikiSnippet()) : null;
    }

    public static void setParentSpace(ContentService contentService, Space space, Space parentSpace) {
        SpaceDescription spaceDescription = space.getDescription();
        ComalaPropertiesManager contentPropertyManager = contentService.getContentPropertyManager();
        String parentKey = parentSpace.getKey();
        MetadataUtils.setMetadataValue(contentPropertyManager, (ContentEntityObject)spaceDescription, PARENT_SPACE_METADATA_NAME, parentKey);
    }

    public static boolean isUsersSpace(ContentService contentService, Space space) {
        SpaceDescription description = space.getDescription();
        MetadataValue isUsersSpaceValue = MetadataUtils.getRawMetadataValue(contentService, (ContentEntityObject)description, USERS_SPACE_METADATA_NAME, null);
        Boolean isUsersSpace = isUsersSpaceValue != null ? isUsersSpaceValue.getValueAsBoolean() : null;
        return isUsersSpace != null && isUsersSpace != false;
    }

    public static void setUsersSpace(ContentService contentService, Space space, boolean isUsersSpace) {
        SpaceDescription spaceDescription = space.getDescription();
        ComalaPropertiesManager contentPropertyManager = contentService.getContentPropertyManager();
        MetadataUtils.setMetadataValue(contentPropertyManager, (ContentEntityObject)spaceDescription, USERS_SPACE_METADATA_NAME, isUsersSpace ? "true" : "false");
    }
}

