/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.space;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.Map;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.plugins.metadata.space.AbstractSpaceMetadataMacro;
import org.andya.confluence.utils.MacroUtils;

public class SpaceMetadataFromMacro
extends AbstractSpaceMetadataMacro {
    public SpaceMetadataFromMacro() {
        super("space-metadata-from");
    }

    public boolean isInline() {
        return true;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    @Override
    public String doExecute(Map parameters, String qualifiedName, RenderContext renderContext) throws MacroException {
        try {
            String spaceKey = MacroUtils.getStringParameter(parameters, "0", null);
            String valueName = MacroUtils.getStringParameter(parameters, "1", null);
            if (spaceKey == null && valueName == null) {
                throw new MacroException("Must specify the space and the metadata to fetch");
            }
            if (valueName == null) {
                valueName = spaceKey;
                spaceKey = "@self";
            }
            if ("".equals(spaceKey)) {
                spaceKey = "@self";
            }
            SpaceDescription spaceDescription = spaceKey != null && !"@self".equals(spaceKey) ? this.getSpaceDescription(spaceKey) : this.getSpaceDescription(renderContext);
            String res = null;
            if (this.shouldBeDisplayed(spaceDescription)) {
                MetadataValue value = this.getMetadataValue((ContentEntityObject)spaceDescription, valueName);
                res = this.renderValue(renderContext, value);
            }
            return res == null ? "" : res;
        }
        catch (Exception e) {
            return this.showRenderedExceptionString(parameters, e);
        }
    }

    private boolean shouldBeDisplayed(SpaceDescription spaceDescription) {
        return this.getPermissionManager().hasPermission(this.getUser(), Permission.VIEW, (Object)spaceDescription);
    }
}

