/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.space;

import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.ArrayList;
import java.util.List;
import org.andya.confluence.plugins.metadata.AbstractMetadataMacro;

public abstract class AbstractSpaceMetadataMacro
extends AbstractMetadataMacro {
    public AbstractSpaceMetadataMacro(String macroName) {
        super(macroName);
    }

    protected Space getSpace(RenderContext renderContext) throws MacroException {
        if (renderContext instanceof PageContext) {
            PageContext pageContext = (PageContext)renderContext;
            String spaceKey = pageContext.getSpaceKey();
            return this.getSpaceManager().getSpace(spaceKey);
        }
        return null;
    }

    protected SpaceDescription getSpaceDescription(RenderContext renderContext) throws MacroException {
        if (renderContext instanceof PageContext) {
            PageContext pageContext = (PageContext)renderContext;
            String spaceKey = pageContext.getSpaceKey();
            return this.getSpaceDescription(spaceKey);
        }
        return null;
    }

    protected SpaceDescription getSpaceDescription(Page page) throws MacroException {
        return this.getSpaceDescription(page.getSpaceKey());
    }

    protected SpaceDescription getSpaceDescription(String spaceKey) {
        Space space = this.getSpaceManager().getSpace(spaceKey);
        return space.getDescription();
    }

    protected List<Space> findSpacesForCurrentUser(int maxResults) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        ListBuilder spacesListBuilder = this.getSpaceManager().getSpaces(SpacesQuery.newQuery().forUser(this.getUser()).build());
        int totalNumberOfSpaces = spacesListBuilder.getAvailableSize();
        do {
            spaces.addAll(spacesListBuilder.getPage(spaces.size(), 500));
        } while (spaces.size() < totalNumberOfSpaces && spaces.size() < maxResults);
        if (spaces.size() >= maxResults) {
            reportLimitHitFlag.set(true);
        }
        return spaces;
    }
}

