/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.renderers;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.LinkRenderer;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.SubRenderer;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.utils.ContentUtils;
import org.andya.confluence.utils.MacroUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetadataSingleValueRenderer {
    private final Log log = LogFactory.getLog(this.getClass());
    private final LinkRenderer linkRenderer;

    public MetadataSingleValueRenderer(LinkRenderer linkRenderer) {
        this.linkRenderer = linkRenderer;
    }

    public String renderSingleValue(StringBuilder html, RenderContext renderContext, String linkColumn, SubRenderer subRenderer, ConfluenceEntityObject ceo, AbstractPage page, String column, MetadataValue value) {
        Object valueString = "";
        AbstractPage pageToLink = ContentUtils.getPageToLink(column, page);
        if (pageToLink != null) {
            try {
                valueString = this.linkRenderer.render((ContentEntityObject)pageToLink, (ConversionContext)new DefaultConversionContext(renderContext));
            }
            catch (XhtmlException e) {
                this.log.warn((Object)("Error rendering link for page " + String.valueOf(page.getSpace()) + ":" + page.getTitle()), (Throwable)e);
            }
        } else {
            valueString = MacroUtils.renderValue(subRenderer, renderContext, ceo, MetadataValue.getWikiSnippet(value));
            if (column.equalsIgnoreCase(linkColumn) && page != null) {
                valueString = "<a href='" + ContentUtils.getPageURL(renderContext, page) + "'>" + (String)valueString + "</a>";
            }
        }
        html.append((String)valueString);
        return valueString;
    }
}

