/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.renderers;

import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.List;
import org.andya.confluence.plugins.metadata.model.MetadataContent;

public interface MetadataRenderer {
    public static final String ENTITY_PAGE = "Page";
    public static final String ENTITY_BLOG_POST = "Blog Post";
    public static final String ENTITY_SPACE = "Space";
    public static final String ENTITY_USER = "User";
    public static final String ENTITY_UNKNOWN = "Unknown";

    public String render(RenderContext var1, List<MetadataContent> var2, int var3, String[] var4, String var5, String var6, I18nResolver var7) throws MacroException;

    default public boolean isPageEntity(List<MetadataContent> contents, String linkColumn) {
        return contents.size() > 0 && contents.getFirst().getEntity() instanceof Page;
    }

    default public boolean isBlogPostEntity(List<MetadataContent> contents, String linkColumn) {
        return contents.size() > 0 && contents.getFirst().getEntity() instanceof BlogPost;
    }

    default public boolean isSpaceEntity(List<MetadataContent> contents, String linkColumn) {
        return contents.size() > 0 && contents.getFirst().getEntity() instanceof SpaceDescription || ENTITY_SPACE.equalsIgnoreCase(linkColumn);
    }

    default public boolean isUserEntity(List<MetadataContent> contents, String linkColumn) {
        return contents.size() > 0 && contents.getFirst().getEntity() instanceof PersonalInformation || ENTITY_USER.equalsIgnoreCase(linkColumn);
    }

    default public String getEntityName(List<MetadataContent> contents, String linkColumn) {
        if (this.isPageEntity(contents, linkColumn)) {
            return ENTITY_PAGE;
        }
        if (this.isBlogPostEntity(contents, linkColumn)) {
            return ENTITY_BLOG_POST;
        }
        if (this.isSpaceEntity(contents, linkColumn)) {
            return ENTITY_SPACE;
        }
        if (this.isUserEntity(contents, linkColumn)) {
            return ENTITY_USER;
        }
        return ENTITY_UNKNOWN;
    }
}

