/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.license;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import java.util.Map;
import org.andya.confluence.plugins.metadata.license.MetadataLicenseManager;
import org.springframework.stereotype.Component;

@Component
public class DefaultMetadataLicenseManager
implements MetadataLicenseManager {
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager licenseManager;
    protected final SystemInformationService systemInformationService;
    private static final String LICENSE_MSG_TEMPLATE = "templates/licenseMessage.vm";

    public DefaultMetadataLicenseManager(@ComponentImport I18nResolver i18nResolver, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport SystemInformationService systemInformationService) {
        this.i18nResolver = i18nResolver;
        this.licenseManager = licenseManager;
        this.systemInformationService = systemInformationService;
    }

    @Override
    public Option<PluginLicense> getLicense() {
        return this.licenseManager.getLicense();
    }

    @Override
    public boolean isLicensed() {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            return !pluginLicense.getError().isDefined();
        }
        return false;
    }

    @Override
    public String getLicenseMessageHtml() {
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("licenseManager", this);
        contextMap.put("i18nResolver", this.i18nResolver);
        contextMap.put("license", this.getLicense());
        return VelocityUtils.getRenderedTemplate((String)LICENSE_MSG_TEMPLATE, (Map)contextMap);
    }

    @Override
    public boolean isDevelopmentMode() {
        boolean isConfluenceOnDevMode = this.systemInformationService.getConfluenceInfo().isDevMode();
        boolean isComalatechDevMode = Boolean.parseBoolean(System.getProperty("comalatech.dev", "false"));
        return isConfluenceOnDevMode && isComalatechDevMode && this.isConfluenceDevLicence();
    }

    private boolean isConfluenceDevLicence() {
        com.atlassian.license.LicenseType licenseType;
        License confluenceLicense = LicenseManager.getInstance().getLicense("CONF");
        if (confluenceLicense != null && (licenseType = confluenceLicense.getLicenseType()) != null) {
            LicenseType type = LicenseType.valueOf((String)licenseType.getNewLicenseTypeName());
            return LicenseType.DEVELOPER.equals((Object)type) || LicenseType.TESTING.equals((Object)type);
        }
        return false;
    }
}

