/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.aop;

import com.atlassian.renderer.v2.components.HtmlEscaper;
import java.util.Arrays;
import lombok.Generated;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class HtmlEncodingAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HtmlEncodingAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ HtmlEncodingAspect ajc$perSingletonInstance;

    @Around(value="@annotation(org.andya.confluence.plugins.metadata.aop.HtmlEncoding) && execution(* *(..))")
    public Object encodeMetadataValue(ProceedingJoinPoint pjp) throws Throwable {
        HtmlEncodingAspect.log.debug(pjp.toShortString());
        Object value = pjp.proceed();
        return this.escapeHtml(value);
    }

    @Around(value="@annotation(org.andya.confluence.plugins.metadata.aop.HtmlEncodingParameter) && execution(* *(..))")
    public Object encodeMetadataParameter(ProceedingJoinPoint pjp) throws Throwable {
        HtmlEncodingAspect.log.debug(pjp.toShortString());
        Object[] args = pjp.getArgs();
        HtmlEncodingAspect.log.debug("args of {}", (Object)pjp.getSourceLocation());
        return pjp.proceed(Arrays.stream(args).map(this::escapeHtml).toArray());
    }

    private Object escapeHtml(Object value) {
        if (value instanceof String) {
            value = this.escapeHtml((String)value);
        } else if (value instanceof String[]) {
            value = this.escapeHtml(value);
        }
        return value;
    }

    private String[] escapeHtml(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.escapeHtml(values[i]);
        }
        return values;
    }

    private String escapeHtml(String value) {
        value = HtmlEscaper.escapeAll((String)value, (boolean)true);
        log.debug("the value has been escaped to '{}'", (Object)value);
        return value;
    }

    static {
        try {
            HtmlEncodingAspect.ajc$perSingletonInstance = new HtmlEncodingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static HtmlEncodingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.andya.confluence.plugins.metadata.aop.HtmlEncodingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

