/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import java.util.List;
import java.util.Map;
import org.andya.confluence.plugins.metadata.MetadataUsingMacro;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.utils.ContentService;
import org.andya.confluence.utils.MacroUtils;

public class MetadataValuesMacro
extends MetadataUsingMacro {
    public MetadataValuesMacro() {
        super("metadata-values");
    }

    public boolean isInline() {
        return false;
    }

    @Override
    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    @Override
    public String doExecute(Map parameters, String body, RenderContext renderContext) {
        try {
            String pageName = MacroUtils.getStringParameter(parameters, "0", "@self");
            Page page = this.getPage(renderContext, pageName);
            if (this.getPermissionManager().hasPermission(this.getUser(), Permission.VIEW, (Object)page)) {
                boolean horizontal = MacroUtils.getBooleanParameter(parameters, "orientation", "horizontal", false);
                ContentService contentService = this.getContentService();
                List<String> names = MetadataUtils.getAllMetadataNames(contentService.getContentPropertyManager(), (ContentEntityObject)page);
                if (names.size() == 0) {
                    return this.renderString(renderContext, "{warning}No metadata is attached to page \"" + pageName + "\"{warning}\n");
                }
                StringBuilder buffer = new StringBuilder();
                if (horizontal) {
                    for (String name : names) {
                        buffer.append("||");
                        buffer.append(name);
                    }
                    buffer.append("||\n");
                    for (String name : names) {
                        MetadataValue value = this.getMetadataValue((ContentEntityObject)page, name, "");
                        String valueString = value != null ? value.getWikiSnippet() : "";
                        buffer.append("|");
                        buffer.append(valueString.length() == 0 ? " " : valueString);
                    }
                    buffer.append("|\n");
                } else {
                    for (String name : names) {
                        MetadataValue value = this.getMetadataValue((ContentEntityObject)page, name, "");
                        String valueString = value != null ? value.getWikiSnippet() : "";
                        buffer.append("||");
                        buffer.append(name);
                        buffer.append("|");
                        buffer.append(valueString.length() == 0 ? " " : valueString);
                        buffer.append("|\n");
                    }
                }
                return this.renderString(renderContext, (ContentEntityObject)page, buffer.toString());
            }
        }
        catch (Exception e) {
            return this.showRenderedExceptionString(parameters, e.getMessage());
        }
        return "";
    }
}

