/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.andya.confluence.plugins.metadata.content.ComalaPropertiesManager;
import org.andya.confluence.plugins.metadata.model.MetadataContent;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.utils.ContentService;

public class MetadataUtils {
    public static final String METADATA_KEY = "metadata.";
    public static final String METADATA_NAMES_KEY = "metadatakeys";
    public static final char METADATA_KEYS_SEPARATOR = '|';
    private static final String MAX_PAGE_RESULTS_PROPERTY = "com.comalatech.confluence.metadata.page.maxresults";
    protected static final String DISABLE_MAX_PAGE_RESULTS_PROPERTY = "com.comalatech.metadata.page.limit.disabled";
    private static final String MAX_SPACE_RESULTS_PROPERTY = "com.comalatech.confluence.metadata.space.maxresults";
    protected static final String DISABLE_MAX_SPACE_RESULTS_PROPERTY = "com.comalatech.metadata.space.limit.disabled";
    private static final String MAX_USER_RESULTS_PROPERTY = "com.comalatech.confluence.metadata.user.maxresults";
    protected static final String DISABLE_MAX_USER_RESULTS_PROPERTY = "com.comalatech.metadata.user.limit.disabled";
    private static final String PAGE_LIMIT_MSG_TEMPLATE = "templates/record-limit-message.vm";
    public static final int CQL_QUERY_PAGE_SIZE = 500;

    public static int getSystemMaxPageResults() {
        String maxResults = System.getProperty(MAX_PAGE_RESULTS_PROPERTY, "1000");
        return Integer.parseInt(maxResults);
    }

    public static int getSystemMaxSpaceResults() {
        String maxResults = System.getProperty(MAX_SPACE_RESULTS_PROPERTY, "1000");
        return Integer.parseInt(maxResults);
    }

    public static int getSystemMaxUserResults() {
        String maxResults = System.getProperty(MAX_USER_RESULTS_PROPERTY, "500");
        return Integer.parseInt(maxResults);
    }

    public static String getMetadataKey(String valueName) {
        return METADATA_KEY + valueName.trim();
    }

    public static Map<String, String> getAllMetadata(ContentService contentService, ContentEntityObject ceo) {
        HashMap<String, String> results = new HashMap<String, String>();
        List<String> names = MetadataUtils.getAllMetadataNames(contentService.getContentPropertyManager(), ceo);
        for (String name : names) {
            MetadataValue v = MetadataUtils.getMetadataValue(contentService, (ConfluenceEntityObject)ceo, name, null);
            results.put(name, v.getValue().toString());
        }
        return results;
    }

    public static void clearAllMetadata(ComalaPropertiesManager contentPropertyManager, ContentEntityObject ceo) {
        List<String> names = MetadataUtils.getAllMetadataNames(contentPropertyManager, ceo);
        for (String name : names) {
            contentPropertyManager.removeProperty(ceo, MetadataUtils.getMetadataKey(name));
        }
        contentPropertyManager.removeProperty(ceo, METADATA_NAMES_KEY);
    }

    public static List<String> getAllMetadataNames(ComalaPropertiesManager contentPropertyManager, ContentEntityObject ceo) {
        List<String> names = new ArrayList<String>();
        String metadataNamesString = contentPropertyManager.getProperty(ceo, METADATA_NAMES_KEY);
        if (metadataNamesString != null && metadataNamesString.length() > 0) {
            names = Arrays.asList(metadataNamesString.split("\\|"));
        }
        return names;
    }

    private static void registerMetadataName(ComalaPropertiesManager contentPropertyManager, ContentEntityObject ceo, String valueName) {
        String metadataNamesString = contentPropertyManager.getProperty(ceo, METADATA_NAMES_KEY);
        String newMetadataNamesString = MetadataUtils.addMetadataName(metadataNamesString, valueName);
        if (!newMetadataNamesString.equals(metadataNamesString)) {
            contentPropertyManager.setProperty(ceo, METADATA_NAMES_KEY, newMetadataNamesString);
        }
    }

    static String addMetadataName(String namesString, String name) {
        if (name == null || name.length() == 0) {
            return namesString;
        }
        if (namesString == null || namesString.length() == 0) {
            return name;
        }
        List<String> names = Arrays.asList(namesString.split("\\|"));
        if (!names.contains(name)) {
            return namesString + "|" + name;
        }
        return namesString;
    }

    private static void removeMetadataName(ComalaPropertiesManager contentPropertyManager, ContentEntityObject ceo, String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        String metadataNamesString = contentPropertyManager.getProperty(ceo, METADATA_NAMES_KEY);
        List<String> names = Arrays.asList(metadataNamesString.split("\\|"));
        String newMetadataNamesString = names.stream().filter(n -> !n.equals(name)).collect(Collectors.joining("|"));
        contentPropertyManager.setProperty(ceo, METADATA_NAMES_KEY, newMetadataNamesString);
    }

    public static MetadataValue getMetadataValue(ContentService contentService, ConfluenceEntityObject ceo, String valueName, Object defaultValue) {
        Object value = null;
        String string = valueName = valueName != null ? valueName.trim() : null;
        if (ceo instanceof ContentEntityObject && (value = MetadataUtils.getRawMetadataValue(contentService, (ContentEntityObject)ceo, valueName, null)) == null) {
            value = MetadataUtils.getScaffoldingValue(contentService, (ContentEntityObject)ceo, valueName, null);
        }
        if (value == null) {
            value = contentService.getContentValue(ceo, valueName);
        }
        if (value instanceof MetadataValue) {
            return value;
        }
        return contentService.createMetadataValue(valueName, value, defaultValue);
    }

    public static MetadataValue getRawMetadataValue(ContentService contentService, ContentEntityObject ceo, String valueName, Object defaultValue) {
        if (ceo == null) {
            throw new IllegalArgumentException("Attempted to fetch metadata value for null ContentEntityObject");
        }
        if (valueName == null) {
            throw new IllegalArgumentException("Attempted to fetch metadata value for null valueName");
        }
        String key = MetadataUtils.getMetadataKey(valueName);
        ComalaPropertiesManager contentPropertyManager = contentService.getContentPropertyManager();
        String value = contentPropertyManager != null ? contentPropertyManager.getProperty(ceo, key) : null;
        return contentService.createMetadataValue(valueName, value, defaultValue);
    }

    public static void removeMetadataValue(ComalaPropertiesManager contentPropertyManager, ContentEntityObject ceo, String valueName) {
        if (ceo == null) {
            throw new IllegalArgumentException("Attempted to fetch metadata value for null ContentEntityObject");
        }
        if (valueName == null) {
            throw new IllegalArgumentException("Attempted to fetch metadata value for null valueName");
        }
        String key = MetadataUtils.getMetadataKey(valueName);
        contentPropertyManager.removeProperty(ceo, key);
        MetadataUtils.removeMetadataName(contentPropertyManager, ceo, valueName);
    }

    public static void setMetadataValue(ComalaPropertiesManager contentPropertyManager, ContentEntityObject ceo, String valueName, String unrenderedValue) {
        if (ceo == null) {
            throw new IllegalArgumentException("Attempted to set metadata value for null ContentEntityObject");
        }
        if (valueName == null) {
            throw new IllegalArgumentException("Attempted to set metadata value for null valueName");
        }
        valueName = valueName.trim();
        String key = MetadataUtils.getMetadataKey(valueName);
        contentPropertyManager.setProperty(ceo, key, unrenderedValue);
        MetadataUtils.registerMetadataName(contentPropertyManager, ceo, valueName);
    }

    public static void setMetadataValue(ComalaPropertiesManager contentPropertyManager, RenderContext renderContext, String valueName, String unrenderedValue) {
        String outputType = renderContext.getOutputType();
        if (outputType != null && !outputType.equals("display")) {
            return;
        }
        if (renderContext instanceof PageContext) {
            PageContext pageContext = (PageContext)renderContext;
            ContentEntityObject ceo = pageContext.getEntity();
            if (pageContext.getOriginalContext() == pageContext && ceo != null) {
                MetadataUtils.setMetadataValue(contentPropertyManager, ceo, valueName, unrenderedValue);
            }
        }
    }

    public static List<MetadataContent> getMetadataContent(ContentService contentService, List<ConfluenceEntityObject> entities) {
        ArrayList<MetadataContent> content = new ArrayList<MetadataContent>();
        for (ConfluenceEntityObject entity : entities) {
            content.add(new MetadataContent(contentService, entity));
        }
        return content;
    }

    public static List<Number> getMetadataNumbers(List<MetadataContent> contents, String valueName, String matchingName, String matchingValue) {
        ArrayList<Number> numbers = new ArrayList<Number>();
        for (MetadataContent content : contents) {
            Number number;
            MetadataValue value;
            MetadataValue contentMetadataValue;
            if (matchingName != null && !matchingValue.equals((contentMetadataValue = content.getMetadataValue(matchingName)).getWikiSnippet()) || (value = content.getMetadataValue(valueName)) == null || (number = value.getValueAsNumber()) == null) continue;
            numbers.add(number);
        }
        return numbers;
    }

    private static String getScaffoldingValue(ContentService contentService, ContentEntityObject content, String key, String defaultValue) {
        if (content == null) {
            throw new IllegalArgumentException("Attempted to fetch metadata value for null ContentEntityObject");
        }
        key = MetadataUtils.getScaffoldingKey(key);
        ComalaPropertiesManager contentPropertyManager = contentService.getContentPropertyManager();
        String value = contentPropertyManager != null ? contentPropertyManager.getProperty(content, key) : null;
        return value != null ? value : defaultValue;
    }

    private static String getScaffoldingKey(String key) {
        return "scaffold." + key;
    }

    public static String getPageLimitMessage(String entityName, I18nResolver i18nResolver) {
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("i18nResolver", i18nResolver);
        contextMap.put("entityName", entityName);
        return VelocityUtils.getRenderedTemplate((String)PAGE_LIMIT_MSG_TEMPLATE, (Map)contextMap);
    }
}

