/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.andya.confluence.plugins.metadata.AbstractMetadataMacro;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.model.MetadataContent;
import org.andya.confluence.utils.MathUtils;
import org.andya.confluence.utils.page.PageLocator;
import org.andya.confluence.utils.page.PageSearchContext;

public abstract class MetadataUsingMacro
extends AbstractMetadataMacro {
    protected MetadataUsingMacro(String macroName) {
        super(macroName);
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public boolean suppressMacroRenderingDuringWysiwyg() {
        return true;
    }

    public List<MetadataContent> getMatchingPages(Map parameters, RenderContext renderContext, boolean ordered, int maxResults) throws MacroException {
        PermissionManager permissionManager = this.getPermissionManager();
        PageSearchContext context = new PageSearchContext(parameters, this.getLabelManager(), renderContext, this.getPageManager(), permissionManager, this.getCqlSearchService(), maxResults);
        PageLocator source = new PageLocator();
        List pages = source.getPages(context);
        pages = this.removeDuplicates(pages);
        pages = permissionManager.getPermittedEntities(this.getUser(), Permission.VIEW, pages);
        return this.getSortedContents(parameters, pages, ordered ? "Title" : null);
    }

    private List<Page> removeDuplicates(List<Page> contents) {
        HashMap<String, String> contentMap = new HashMap<String, String>();
        ArrayList<Page> filteredList = new ArrayList<Page>();
        for (Page o : contents) {
            if (contentMap.containsKey(o.getIdAsString())) continue;
            contentMap.put(o.getIdAsString(), o.getIdAsString());
            filteredList.add(o);
        }
        return filteredList;
    }

    protected String renderCalculation(String functionName, List<Number> values) throws MacroException {
        if (values.isEmpty()) {
            return "";
        }
        Number result = MathUtils.doCalculation(functionName, values);
        if (AbstractMetadataMacro.reportLimitHitFlag.get().booleanValue()) {
            return MetadataUtils.getPageLimitMessage("Page", this.getI18nResolver()) + "\n" + MathUtils.toString(result);
        }
        return MathUtils.toString(result);
    }
}

