/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.Map;
import org.andya.confluence.plugins.metadata.MetadataUsingMacro;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.utils.MacroUtils;

public class MetadataFromMacro
extends MetadataUsingMacro {
    public MetadataFromMacro() {
        super("metadata-from");
    }

    @Override
    public String doExecute(Map parameters, String qualifiedName, RenderContext renderContext) throws MacroException {
        try {
            String pageName = MacroUtils.getStringParameter(parameters, "0", null);
            String valueName = MacroUtils.getStringParameter(parameters, "1", null);
            if (pageName == null && valueName == null) {
                throw new MacroException("Must specify the page and the metadata to fetch");
            }
            if (valueName == null) {
                valueName = pageName;
                pageName = "@self";
            }
            if (pageName == null || pageName.isEmpty()) {
                pageName = "@self";
            }
            Page page = this.getPage(renderContext, pageName);
            String res = "";
            if (this.shouldBeDisplayed(page)) {
                MetadataValue value = this.getMetadataValue((ContentEntityObject)page, valueName);
                res = value != null ? this.renderValue(renderContext, (ContentEntityObject)page, value) : "";
            }
            return res;
        }
        catch (Exception e) {
            return this.showRenderedExceptionString(parameters, e.getMessage());
        }
    }

    public boolean isInline() {
        return true;
    }

    private boolean shouldBeDisplayed(Page page) {
        return this.getPermissionManager().hasPermission(this.getUser(), Permission.VIEW, (Object)page);
    }
}

