/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.utils;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.renderer.RenderContext;
import com.atlassian.user.User;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ContentUtils {
    public static String getPageLink(Page page) {
        return String.format("[%s:%s]", page.getSpaceKey(), page.getTitle());
    }

    public static String getPageLink(String title, Page page) {
        return "[" + title + "|" + page.getSpaceKey() + ":" + title + "]";
    }

    public static String getBlogPostLink(BlogPost blogPost) {
        return String.format("[%s:/%s/%s]", blogPost.getSpaceKey(), blogPost.getDatePath(), blogPost.getTitle());
    }

    private static String getCommentLink(int commentsCount, String cdata) {
        return "[" + commentsCount + " comment" + (commentsCount == 1 ? "" : "s") + "|" + cdata + "]";
    }

    public static String getCommentLink(int commentsCount, Comment comment) {
        return ContentUtils.getCommentLink(commentsCount, "$" + comment.getId());
    }

    public static String getBlogpostCommentsLink(int commentsCount, BlogPost ceo) {
        return ContentUtils.getCommentLink(commentsCount, ceo.getSpaceKey() + ":/" + ceo.getDatePath() + "/" + ceo.getTitle() + "#comments");
    }

    public static String getAttachmentLink(Attachment attachment) {
        return String.format("[%s:%s^%s]", attachment.getSpace().getKey(), Objects.requireNonNull(attachment.getContainer()).getTitle(), attachment.getFileName());
    }

    public static String getAttachmentLink(Attachment attachment, String title) {
        return String.format("[%s|%s:%s^%s]", title, attachment.getSpace().getKey(), Objects.requireNonNull(attachment.getContainer()).getTitle(), attachment.getFileName());
    }

    public static String getSpaceLink(Space space) {
        return "[" + space.getName() + "|" + space.getKey() + ":]";
    }

    public static String getUserLink(User user) {
        return ContentUtils.getUserLink(user.getName());
    }

    public static String getUserLink(String userName) {
        return userName != null ? "[~" + userName + "]" : "";
    }

    public static String getEmailLink(User user) {
        String email = user.getEmail();
        return StringUtils.isBlank((CharSequence)email) ? null : ContentUtils.getEmailLink(email);
    }

    public static String getEmailLink(String email) {
        return "[mailto:" + email + "]";
    }

    public static String getPageURL(RenderContext pageContext, AbstractPage page) {
        String pageURL = page.getUrlPath();
        return pageContext.getSiteRoot() + pageURL;
    }

    public static boolean isHomePage(Page page) {
        return page.equals((Object)page.getSpace().getHomePage());
    }

    public static AbstractPage getPageToLink(String key, AbstractPage page) {
        if ("Title".equals(key) || "Page".equals(key)) {
            return page;
        }
        if ("Parent".equals(key) && page instanceof Page) {
            return ((Page)page).getParent();
        }
        return null;
    }

    public static String quoteString(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        return "\"" + text + "\"";
    }
}

