/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.transformer;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Arrays;
import java.util.List;
import org.andya.confluence.plugins.metadata.transformer.AbstractTransformer;
import org.apache.commons.lang3.StringUtils;

public class HtmlBlockOnMarkdownTransformer
extends AbstractTransformer {
    private final I18nResolver i18n;
    private static final List affectedMacrosList = Arrays.asList("metadata-list", "space-metadata-list");

    public HtmlBlockOnMarkdownTransformer(I18nResolver i18n) {
        this.i18n = i18n;
    }

    @Override
    public boolean shouldApply(String content, ConversionContext context) {
        if (context != null && context.getProperty("macroDefinition") != null) {
            return affectedMacrosList.contains(((MacroDefinition)context.getProperty("macroDefinition")).getName());
        }
        return false;
    }

    @Override
    public String transform(String content, ConversionContext context) {
        String licensingWarningTitle = this.i18n.getRawText("plugin.license.storage.admin.license.details");
        if (StringUtils.isNotBlank((CharSequence)licensingWarningTitle) && content.contains(licensingWarningTitle)) {
            return content.replaceAll("<br/>", "");
        }
        return content;
    }
}

