/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata.model;

import com.atlassian.renderer.v2.macro.MacroException;
import java.util.ArrayList;
import java.util.Comparator;
import org.andya.confluence.plugins.metadata.model.MetadataContent;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.apache.commons.collections4.comparators.ComparatorChain;

public class MetadataSortOrder {
    private final String metadataName;
    private final boolean ascending;
    protected final String sortMethod;

    public MetadataSortOrder(String metadataName, boolean ascending, String sortMethod) {
        this.metadataName = metadataName;
        this.ascending = ascending;
        this.sortMethod = sortMethod;
    }

    public String getMetadataName() {
        return this.metadataName;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public Comparator<MetadataContent> getComparator() {
        return (o1, o2) -> {
            String metadataName = this.getMetadataName();
            MetadataValue value1 = o1.getMetadataValue(metadataName);
            MetadataValue value2 = o2.getMetadataValue(metadataName);
            if (value1 == null) {
                return value2 == null ? 0 : 1;
            }
            if (value2 == null) {
                return -1;
            }
            if (this.sortMethod.equals("as istring")) {
                return (this.isAscending() ? 1 : -1) * value1.compareValueAsIStringTo(value2);
            }
            if (this.sortMethod.equals("as string")) {
                return (this.isAscending() ? 1 : -1) * value1.compareValueAsStringTo(value2);
            }
            if (this.sortMethod.equals("as number")) {
                return (this.isAscending() ? 1 : -1) * value1.compareValueAsNumberTo(value2);
            }
            if (this.sortMethod.equals("as date")) {
                return (this.isAscending() ? 1 : -1) * value1.compareTo(value2);
            }
            int result = value1.compareTo(value2);
            return this.isAscending() ? result : -result;
        };
    }

    public static Comparator<MetadataContent> getComparator(MetadataSortOrder[] sortOrders, String defaultColumn) {
        ArrayList<Comparator<Comparator<MetadataContent>>> comparators = new ArrayList<Comparator<Comparator<MetadataContent>>>();
        if (sortOrders != null) {
            for (MetadataSortOrder sortOrder : sortOrders) {
                comparators.add(sortOrder.getComparator());
            }
        }
        if (defaultColumn != null) {
            comparators.add(new MetadataSortOrder(defaultColumn, true, "as istring").getComparator());
        }
        return new ComparatorChain<MetadataContent>(comparators);
    }

    public static MetadataSortOrder[] getMetadataSortOrders(String commaSeparatedSorts) throws MacroException {
        if ((commaSeparatedSorts = commaSeparatedSorts.trim()).length() == 0) {
            return null;
        }
        String[] sortOrderStrings = commaSeparatedSorts.split(",");
        int sortOrderCount = sortOrderStrings.length;
        MetadataSortOrder[] sortOrders = new MetadataSortOrder[sortOrderCount];
        for (int i = 0; i < sortOrderCount; ++i) {
            String sortOrder = sortOrderStrings[i].trim();
            String sortMethod = "as istring";
            if (sortOrder.length() == 0) {
                throw new MacroException("Missing metadata name for sort value \"" + commaSeparatedSorts + "\"");
            }
            if (sortOrder.contains("as date")) {
                sortMethod = "as date";
            } else if (sortOrder.contains("as number")) {
                sortMethod = "as number";
            } else if (sortOrder.contains("as string")) {
                sortMethod = "as string";
            } else if (sortOrder.contains("as istring")) {
                sortMethod = "as istring";
            }
            sortOrder = sortOrder.replace(sortMethod, "");
            int lastSpaceIndex = sortOrder.lastIndexOf(32);
            String metadataName = sortOrder;
            boolean ascending = true;
            if (lastSpaceIndex >= 0) {
                String lastWord = sortOrder.substring(lastSpaceIndex + 1).toLowerCase();
                boolean bl = ascending = !lastWord.startsWith("desc");
                if (lastWord.startsWith("asc") || lastWord.startsWith("desc")) {
                    metadataName = sortOrder.substring(0, lastSpaceIndex);
                }
            }
            sortOrders[i] = new MetadataSortOrder(metadataName, ascending, sortMethod);
        }
        return sortOrders;
    }
}

