/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import com.atlassian.renderer.v2.macro.MacroException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.andya.confluence.plugins.metadata.AbstractMetadataMacro;
import org.andya.confluence.plugins.metadata.MetadataUsingMacro;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.model.MetadataContent;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.utils.MacroUtils;
import org.apache.commons.lang3.BooleanUtils;

public class MetadataTableMacro
extends MetadataUsingMacro {
    private static final int SUMMARISE_SUM = 1;
    private static final int SUMMARIZE_COUNT = 2;
    private static final int SUMMARIZE_MAX = 3;
    private static final int SUMMARIZE_MIN = 4;
    private static final int SUMMARIZE_TEXT = 5;
    protected static final String X_KEY = "x";
    protected static final String Y_KEY = "y";
    protected static final String VALUE_KEY = "value";
    protected static final String SUM_KEY = "summarise";
    protected static final String VALUE_NAME_KEY = "value-name";

    public MetadataTableMacro() {
        super("metadata-table");
    }

    @Override
    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    @Override
    public String doExecute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            HashMap col;
            String xValue = MacroUtils.getStringParameter(parameters, X_KEY, null);
            String yValue = MacroUtils.getStringParameter(parameters, Y_KEY, null);
            String tableValue = MacroUtils.getStringParameter(parameters, VALUE_KEY, null);
            String summarise = MacroUtils.getStringParameter(parameters, SUM_KEY, "SUM");
            StringBuilder html = new StringBuilder();
            int maxResults = this.getMaxResultsForPages(parameters);
            List<MetadataContent> contents = this.getMatchingPages(parameters, renderContext, true, this.getSystemMaxResultsForPages());
            int totalResults = contents.size();
            boolean truncated = false;
            if (totalResults > maxResults) {
                contents = contents.subList(0, maxResults);
                truncated = true;
            }
            int sum = 1;
            if (summarise.compareToIgnoreCase("SUM") == 0) {
                sum = 1;
            } else if (summarise.compareToIgnoreCase("COUNT") == 0) {
                sum = 2;
            } else if (summarise.compareToIgnoreCase("MAX") == 0) {
                sum = 3;
            } else if (summarise.compareToIgnoreCase("MIN") == 0) {
                sum = 4;
            } else if (summarise.compareToIgnoreCase("TEXT") == 0) {
                sum = 5;
            }
            ArrayList<String> yValues = new ArrayList<String>();
            ArrayList<String> xValues = new ArrayList<String>();
            HashMap<String, HashMap> table = new HashMap<String, HashMap>();
            BigDecimal lastNumber = new BigDecimal(0);
            block14: for (MetadataContent content : contents) {
                MetadataValue y = content.getMetadataValue(yValue);
                MetadataValue x = content.getMetadataValue(xValue);
                if (y == null || x == null) continue;
                String yString = y.getValue().toString();
                String xString = x.getValue().toString();
                MetadataValue currentValue = content.getMetadataValue(tableValue);
                Number tempNumber = currentValue != null ? (Number)currentValue.getValueAsNumber() : (Number)null;
                BigDecimal currentNumber = tempNumber == null ? new BigDecimal(0) : BigDecimal.valueOf(tempNumber.doubleValue());
                if (!yValues.contains(yString)) {
                    yValues.add(yString);
                    col = new HashMap();
                    table.put(yString, col);
                } else {
                    col = (HashMap)table.get(yString);
                }
                if (!xValues.contains(xString)) {
                    xValues.add(xString);
                }
                if (sum != 5) {
                    lastNumber = col.get(xString) != null ? (BigDecimal)col.get(xString) : (sum == 4 ? new BigDecimal(Integer.MAX_VALUE) : (sum == 3 ? new BigDecimal(Integer.MIN_VALUE) : new BigDecimal(0)));
                }
                switch (sum) {
                    case 5: {
                        col.put(xString, MetadataValue.getWikiSnippet(currentValue));
                        continue block14;
                    }
                    case 2: {
                        col.put(xString, new BigDecimal(lastNumber.intValue() + 1));
                        continue block14;
                    }
                    case 4: {
                        if (lastNumber.compareTo(currentNumber) < 0) continue block14;
                        col.put(xString, currentNumber);
                        continue block14;
                    }
                    case 3: {
                        if (lastNumber.compareTo(currentNumber) >= 0) continue block14;
                        col.put(xString, currentNumber);
                        continue block14;
                    }
                }
                col.put(xString, new BigDecimal(currentNumber.intValue() + lastNumber.intValue()));
            }
            try {
                Collections.sort(yValues);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Collections.sort(xValues);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (BooleanUtils.isTrue((Boolean)AbstractMetadataMacro.reportLimitHitFlag.get())) {
                html.append(MetadataUtils.getPageLimitMessage("Page", this.getI18nResolver()));
            }
            html.append("<table class=\"confluenceTable tablesorter\">\n");
            html.append("<thead>");
            html.append("<tr class=\"sortableHeader\">");
            html.append("<th class=\"confluenceTh sortableHeader tablesorter-headerSortDown\">");
            html.append(HtmlEscaper.escapeAll((String)xValue, (boolean)true));
            html.append("</th>");
            for (String value : yValues) {
                html.append("<th class='confluenceTh sortableHeader'>");
                html.append(value);
                html.append("</th>");
            }
            html.append("</tr>");
            html.append("</thead>");
            html.append("<tbody class = \"\">");
            for (String value : xValues) {
                html.append("<tr>\n");
                html.append("<th class='confluenceTh'>");
                html.append(value);
                html.append("</th>");
                for (String s : yValues) {
                    html.append("<td class='confluenceTd'>");
                    try {
                        col = (HashMap)table.get(s);
                        if (col != null) {
                            html.append(col.get(value) != null ? col.get(value) : "");
                        } else {
                            html.append(" ");
                        }
                    }
                    catch (Exception e) {
                        html.append(" ");
                    }
                    html.append("</td>\n");
                }
                html.append("</tr>\n");
            }
            if (truncated) {
                html.append("<tr><td colspan=").append(yValues.size() + 1).append(" class='confluenceTd'>");
                html.append("First ").append(maxResults).append(" results of ").append(totalResults).append("...");
                html.append("</td></tr>\n");
            }
            html.append("</tbody>");
            html.append("</table>\n");
            return html.toString();
        }
        catch (Exception e) {
            return MacroUtils.showRenderedExceptionString(parameters, "Unable to render metadata table macro", e.getMessage());
        }
    }
}

