/*
 * Decompiled with CFR 0.152.
 */
package org.andya.confluence.plugins.metadata;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.plugins.index.api.TextFieldDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.andya.confluence.plugins.metadata.MetadataUtils;
import org.andya.confluence.plugins.metadata.model.MetadataValue;
import org.andya.confluence.utils.ContentService;

public class MetadataExtractor
implements Extractor2 {
    private final ContentService contentService;

    public MetadataExtractor(ContentService contentService) {
        this.contentService = contentService;
    }

    public StringBuilder extractText(Object o) {
        StringBuilder defaultSearchableText = new StringBuilder();
        if (o instanceof ContentEntityObject) {
            ContentEntityObject ceo = (ContentEntityObject)o;
            List<String> metadataNames = MetadataUtils.getAllMetadataNames(this.contentService.getContentPropertyManager(), ceo);
            for (String name : metadataNames) {
                MetadataValue value = MetadataUtils.getMetadataValue(this.contentService, (ConfluenceEntityObject)ceo, name, "");
                if (value == null) continue;
                defaultSearchableText.append(value.getWikiSnippet()).append(" ");
            }
        }
        return defaultSearchableText;
    }

    public Collection<FieldDescriptor> extractFields(Object o) {
        ArrayList<FieldDescriptor> fieldList = new ArrayList<FieldDescriptor>();
        if (o instanceof ContentEntityObject) {
            ContentEntityObject ceo = (ContentEntityObject)o;
            List<String> metadataNames = MetadataUtils.getAllMetadataNames(this.contentService.getContentPropertyManager(), ceo);
            for (String name : metadataNames) {
                MetadataValue value = MetadataUtils.getMetadataValue(this.contentService, (ConfluenceEntityObject)ceo, name, "");
                if (value == null) continue;
                fieldList.add((FieldDescriptor)new TextFieldDescriptor(name, value.getWikiSnippet(), FieldDescriptor.Store.YES));
            }
        }
        return fieldList;
    }
}

